'         GENCVT - Convert GENIFER programs to CLIPPER format
'                 Copyright (c) Nordic Systems - 1987
'
' GENCVT - convert Genifer generated programs to allow compilation
'          by Clipper.  Converts procedure names to a standard form
'          of:
'                 . first six characters of input program name
'                 . next two characters of a sequence number
'
'          Note that this works only if your programs names are unique
'          within the first six characters of name.
'
' GENCVT works as follows:
'
'          1. You are asked for the program name you wish to convert
'          2. You are then asked for the type of program:
'
'                . Update
'                . Inquiry
'                . Report
'                . Menu
'
'          Depending on your answer to program type, one of four
'          subprograms is called.  Three of these programs use an
'          array of standard procedure names emitted by Genifer as
'          a source to look for string information in the generated
'          Genifer program.  Each then generates a corresponding array
'          of "new" procedure names to be substituted in the Genifer
'          text. The fourth program deals with menus and is more
'          interactive.  Upon locating a call to a procedure, it asks
'          if the call is to a procedure or another menu.  If it is a
'          menu, the "SET" statement is removed and the remaining "DO"
'          statement remains in the text to be executed.
'
'          Generally, the input program is read and appropriate substitutions are
'          are made to the text.  This text is written on a temporary file
'          with the same name as your input program with an extension
'          of "$$$".  If the translation finishes correctly, your
'          original ".PRG" file will be renamed with an extension of
'          ".BAK".  The "$$$" file will then be renamed with an extension
'          of ".PRG".  This way you always have a backup of your original
'          program should anything malfunction in the conversion process.


' Set up shared variables with subprograms to be used in printing
' final results of conversion

' rep             - number of replacements
' prog$           - old program name
' newprog$        - new program name
' temp$           - output line for new file
' firstime$       - flag for first time through the loop
' procname$       - main procedure name to be replaced
' filter$         - filter expression to be replaced
' index$          - index expression to be replaced
' killflag$       - flag which says files to kill arent there

COMMON SHARED rep,prog$,newprog$,temp$,procname$,filter$,index$,killflag$

' Print screen title

call SCRTITLE

' Set up error handling for opening PRG files

on error goto ERRORHANDLE

' Set lowest array boundary to 1 (makes more sense)

option base 1


' Allocate the procedure name arrays before initializing them

dim shared maint$(27,27)
dim shared inquiry$(19,19)
dim shared report$(27,27)


START:

' Clear the screen and ask for the program name to be examined

locate 10,12
print "Please enter then name of your dBase program: ";
input prog$

' Program name can't be any greater than six characters in length
' If so, chop it back to six.

if len(prog$) > 6 then
  prog$ = left$(prog$,6)
end if
infile$ = prog$+".PRG"
call UPPERCASE(infile$)
locate 10,58
print infile$;

' Lets see if we have a file by that name anywhere on the disk

open infile$ for input as #1
if number > 0 then
  number = 0
  goto start
end if

' We have the file, so now initialize the corresponding procedure name
' arrays needed to do the conversion

CALL INIT

' Enter program type. This may be "M"enu, "I"nquiry,
' "R"eport or "Update

while progtype$ <> "M" and progtype$ <> "I" _
  and progtype$ <> "R" and progtype$ <> "U"
  progtype$ = ""
  locate 12,25
  print "Please enter the program type as follows: "
  locate 14,25
  print "M - Menu program"
  locate 15,25
  print "I - Inquiry program"
  locate 16,25
  print "R - Report program"
  locate 17,25
  print "U - Update program"
  PRGLOOP:
    locate 20,30
    progtype$ = inkey$
    if len(progtype$) = 0 then
      goto PRGLOOP
    end if
  call UPPERCASE(progtype$)
  locate 20,28
  print progtype$
  call clrscr
  locate 15,24
  print "<< Now converting: " infile$ ">>"
wend

' Get a new name for the program file we are creating. It is the old
' program name with the extension $$$ added to it

newprog$ = ""
call extension

' Now let's process the file according to the program type input by
' the user

call killfile
open newprog$ for output as #2
while not eof(1)
  line input #1,temp$
  if progtype$ = "U" or progtype$ = "u" then
    call MAINT
  elseif progtype$ = "R" or progtype$ = "r" then
    tron
    call REPORT
  elseif progtype$ = "I" or progtype$ = "i" then
    call INQUIRY
  elseif progtype$ = "M" or progtype$ = "m" then
    call MENU
  end if
   print #2, temp$
wend
close

' Tell him were done with the conversion

call clrscr
locate 12,22
print "Conversion of " infile$ " is complete"
locate 14,22

' Rename the original file as a .BAK file
' and rename the temporary .$$$ file as the new .PRG file

name infile$ as prog$ + ".BAK"
name newprog$ as prog$ + ".PRG"

' Now ask if there are any more PRGs to convert


ans$ = " "
ANSLOOP:
  while ans$ <> "Y" and ans$ <> "y" and ans$ <> "N" and ans$ <> "n"
    call clrscr
    locate 12,10
    print "Are there any more PRG files to convert (Y/N)?: ";
    input ans$
    if ans$ = "Y" or ans$ = "y" then
      goto START
    end if
    if ans$ = "N" or ans$ = "n" then
      goto ENDIT
    end if
  wend

ENDIT:
  cls
  locate 12,10
  print "Conversion of Genifer programs to Clipper format is complete."
end

ERRORHANDLE:
  number = err
  if number = 53 then
    if killflag$ <> "Y" then
      locate 13,25
      print "Program file ";prog$;" does not exist"
      locate 14,30
      print "Hit any key to try again.";
      INLOOP:
	a$ = inkey$
	if len(a$) = 0 then
	  goto INLOOP
	end if
      locate 10,58
      print space$(15)
      locate 13,25
      print space$(50)
      locate 14,30
      print space$(45)
    end if
  end if
resume next

SUB EXTENSION STATIC
  mark = instr(prog$,".")
  if mark = 0 then
    newprog$ = prog$ + ".$$$"
  else
    newprog$ = left$(prog$,mark - 1) + ".$$$"
  end if
END SUB

SUB KILLFILE STATIC
  killflag$ = "Y"
  mark = instr(prog$,".")
  if mark = 0 then
    temprog$ = prog$ + ".$$$"
  else
    temprog$ = left$(prog$,mark - 1) + ".$$$"
  end if
  kill temprog$
  mark = instr(prog$,".")
  if mark = 0 then
    temprog$ = prog$ + ".BAK"
  else
    temprog$ = left$(prog$,mark - 1) + ".BAK"
  end if
  kill temprog$
END SUB

SUB MAINT STATIC
  procname$ = "PROCEDURE " + prog$
  filter$ = "set filter to &filt_str"
  index$ = ".ndx"

  ' Capture first procedure name and convert for Clipper

  mark = instr(temp$,procname$)
  if mark > 0 then
    temp$ = "PROCEDURE " + prog$ + "00"
    exit sub
  end if

  ' Trap erroneous filter setting which is not recognized by Clipper
  ' and change it to what Genifer recommends

  mark = instr(temp$,filter$)
  if mark > 0 then
    temp$ = "      set filter to"
    print #2, temp$
    temp$ = "      if '' <> trim(filt_str)"
    print #2, temp$
    temp$ = "        set filter to &filt_str
    print #2, temp$
    temp$ = "      endif"
    exit sub
  end if

  ' Trap expressions that end in .ndx and change them to .ntx

  mark = instr(temp$,index$)
  if mark > 0 then
    length = len(temp$)
    temp$ = left$(temp$, mark - 1) + ".ntx" + right$(temp$,length - mark - 3)
    exit sub
  end if

  ' Now that all the exceptions are dealt with, trap the regular
  ' procedure calls and convert them to the new numbering scheme.

  for i = 1 to 27
    target$ = "procedure "+ maint$(2,i)
    mark = instr(temp$,target$)
    if mark > 0 then
      temp$ = "procedure " + maint$(1,i)
      rep = rep + 1
      exit sub
    end if
    target$ = "do " + maint$(2,i)
    mark = instr(temp$, target$)
    if mark > 0 then
      ' grab the first part of the sentence
      part1$ = left$(temp$, mark + 2)
      ' then plug in the generated routine number
      part1$ = part1$ + maint$(1,i)
      ' get the length of the total sentence and the length of the
      ' original phrase
      templength = len(temp$)
      length = len(maint$(2,i))
      ' add three bytes to handle the DO portion
      length = length + 3
      ' calculate where to pick up the rest of the sentence if available
      mark = mark + length - 1
      part1$ = part1$ + right$(temp$, templength - mark)
      temp$ = part1$
      rep = rep + 1
      exit sub
    end if
next i
END SUB

SUB INQUIRY STATIC
    procname$ = "PROCEDURE " + prog$
    filter$ = "set filter to &filt_str"
    index$ = ".ndx"

' Capture first procedure name and convert for Clipper

  mark = instr(temp$,procname$)
  if mark > 0 then
    temp$ = "PROCEDURE " + prog$ + "00"
    exit sub
  end if

  ' Trap erroneous filter setting which is not recognized by Clipper
  ' and change it to what Genifer recommends

  mark = instr(temp$,filter$)
  if mark > 0 then
    temp$ = "      set filter to"
    print #2, temp$
    temp$ = "      if '' <> trim(filt_str)"
    print #2, temp$
    temp$ = "        set filter to &filt_str
    print #2, temp$
    temp$ = "      endif"
    exit sub
  end if

  ' Trap expressions that end in .ndx and change them to .ntx

  mark = instr(temp$,index$)
  if mark > 0 then
    length = len(temp$)
    temp$ = left$(temp$, mark - 1) + ".ntx" + right$(temp$,length - mark - 3)
    exit sub
  end if

  ' Now that all the exceptions are dealt with, trap the regular
  ' procedure calls and convert them to the new numbering scheme.

  for i = 1 to 19
    target$ = "procedure "+ inquiry$(2,i)
    mark = instr(temp$,target$)
    if mark > 0 then
      temp$ = "procedure " + inquiry$(1,i)
      rep = rep + 1
      exit sub
    end if
    target$ = "do " + inquiry$(2,i)
    mark = instr(temp$, target$)
    if mark > 0 then
      ' grab the first part of the sentence
      part1$ = left$(temp$, mark + 2)
      ' then plug in the generated routine number
      part1$ = part1$ + inquiry$(1,i)
      ' get the length of the total sentence and the length of the
      ' original phrase
      templength = len(temp$)
      length = len(inquiry$(2,i))
      ' add three bytes to handle the DO portion
      length = length + 3
      ' calculate where to pick up the rest of the sentence if available
      mark = mark + length - 1
      part1$ = part1$ + right$(temp$, templength - mark)
      temp$ = part1$
      rep = rep + 1
      exit sub
    end if
 next i
END SUB

SUB REPORT STATIC
    procname$ = "PROCEDURE " + prog$
    filter$ = "set filter to &filt_str"
    index$ = ".ndx"

' Capture first procedure name and convert for Clipper

  mark = instr(temp$,procname$)
  if mark > 0 then
    temp$ = "PROCEDURE " + prog$ + "00"
    exit sub
  end if

  ' Trap erroneous filter setting which is not recognized by Clipper
  ' and change it to what Genifer recommends

  mark = instr(temp$,filter$)
  if mark > 0 then
    temp$ = "      set filter to"
    print #2, temp$
    temp$ = "      if '' <> trim(filt_str)"
    print #2, temp$
    temp$ = "        set filter to &filt_str
    print #2, temp$
    temp$ = "      endif"
    exit sub
  end if

  ' Trap expressions that end in .ndx and change them to .ntx

  mark = instr(temp$,index$)
  if mark > 0 then
    length = len(temp$)
    temp$ = left$(temp$, mark - 1) + ".ntx" + right$(temp$,length - mark - 3)
    exit sub
  end if

  ' Now that all the exceptions are dealt with, trap the regular
  ' procedure calls and convert them to the new numbering scheme.

  for i = 1 to 27
    target$ = "procedure "+ report$(2,i)
    mark = instr(temp$,target$)
    if mark > 0 then
      temp$ = "procedure " + report$(1,i)
      rep = rep + 1
      exit sub
    end if
    target$ = "do " + report$(2,i)
    mark = instr(temp$, target$)
    if mark > 0 then
      ' grab the first part of the sentence
      part1$ = left$(temp$, mark + 2)
      ' then plug in the generated routine number
      part1$ = part1$ + report$(1,i)
      ' get the length of the total sentence and the length of the
      ' original phrase
      templength = len(temp$)
      length = len(report$(2,i))
      ' add three bytes to handle the DO portion
      length = length + 3
      ' calculate where to pick up the rest of the sentence if available
      mark = mark + length - 1
      part1$ = part1$ + right$(temp$, templength - mark)
      temp$ = part1$
      rep = rep + 1
      exit sub
    end if
  next i
END SUB


' Subprogram to convert menu programs to Clipper format

SUB MENU STATIC

  mark = instr(temp$,"enddo")
  if mark > 0 then
    exit sub
  end if
  mark = instr(temp$,"if file")
  if mark > 0 then
    line input #1,temp$
    mark = instr(temp$,"set procedure to ")
    call clrscr
    locate 12,10
    proc$ = mid$(temp$,mark+17,6)
    print "Is " proc$ " a (M)enu program or a (P)rocedure";
  MLOOP:
    input ans$
    if ans$ <> "M" and ans$ <> "m" and ans$ <> "P" and ans$ <> "p" then
      goto MLOOP
    end if
    if ans$ = "M" or ans$ = "m" then
      line input #1,temp$
      exit sub
    end if
    print #2, temp$
    line input #1,temp$
    mark = instr(temp$,"do ")
    temp$ = left$(temp$,mark+8) + "00"
    exit sub
  end if
  mark = instr(temp$,"else")
  if mark > 0 then
    line input #1,temp$
    line input #1,temp$
    line input #1,temp$
    line input #1,temp$
    exit sub
  end if
END SUB


' Subprogram to initialize the procedure name arrays

SUB INIT STATIC

' Initialize the maintenance program arrays first

  data "chk_dupl","chk_fils","clr_cal","clr_flds","delete","disp_cal"
  data "disp_msg","disp_rec","disp_scr","filter","get_flds","get_key"
  data "get_optn","help","init_fld","init_key","list","load_var"
  data "modify","pack_all","repl_rec","retrieve","save_rec","skip"
  data "tally","val_rec","add"
  for i = 1 to 27
    read maint$(2,i)
    num$ = str$(i)
    length = len(num$)
    length = length - 1
    num$ = right$(num$,length)
    maint$(1,i) = prog$+num$
  next i

' Initialize the inquiry program arrays

  data "chk_fils","clr_cal","clr_flds","disp_cal"
  data "disp_msg","disp_rec","disp_scr","filter","get_flds","get_key"
  data "get_optn","help","init_fld","init_key","list","load_var"
  data "retrieve","skip"
  data "tally"
  for i = 1 to 19
    read inquiry$(2,i)
    num$ = str$(i)
    length = len(num$)
    length = length - 1
    num$ = right$(num$,length)
    inquiry$(1,i) = prog$+num$
  next i

' Initialize the report program array

  data "adv_line","adv_page","chk_fils","detail","disp_msg","page_hd"
  data "page_ft","rept_hd","rept_ft","brk1_head","brk1_ft"
  data "brk2_head","brk2_ft","brk3_head","brk3_ft","brk4_head","brk4_ft"
  data "brk5_head","brk5_ft","brk6_head","brk6_ft","brk7_head","brk7_ft"
  data "brk8_head","brk8_ft","brk9_head","brk9_ft"
  for i = 1 to 27
    num$ = str$(i)
    length = len(num$)
    length = length - 1
    num$ = right$(num$,length)
    read report$(2,i)
    report$(1,i) = prog$+num$
  next i
END SUB


SUB SCRTITLE STATIC

' Print screen title

  for i = 1 to 78
    scrline$ = scrline$ + chr$(196)
  next i
  cls
  print chr$(218);
  print scrline$;
  print chr$(191)
  print chr$(179);
  locate 2,80
  print chr$(179)
  print chr$(192);
  print scrline$;
  print chr$(217)
  title$ = "GENCVT -> Convert GENIFER programs to CLIPPER format"
  locate 2,2
  print date$;
  locate 2,((80 - len(title$)) / 2)
  print title$;
  locate 2,72
  print time$
  for i = 1 to 78
    boxstr$ = boxstr$ + chr$(178)
  next i
  locate 24,2
  print boxstr$;
  copyr$ = " Copyright (c) 1987 - Nordic Systems "
  locate 24,((80 - len(copyr$))/2)
  print copyr$;
END SUB

SUB CLRSCR STATIC

' Clear the screen between line 4 and line 23

locate 4,1
for i = 1 to 20
  print space$(70)
next i
END SUB


SUB UPPERCASE(name$) STATIC

' UPPERCASE - Convert string to uppercase
' 
'  UPPERCASE converts a string to uppercase. If the string is already in
'  upper case nothing is done. It returns an empty string if name$ is empty.

length = len(name$)
' If input string is empty just return an empty string
if length = 0 then
  exit sub
end if
for i = 1 to length
  char = asc(mid$(name$, i, 1))
' &hdf converts from lower to upper case
  if ((char >= asc("a")) and (char <= asc("z"))) then 
    char = char and &hdf	
    mid$(name$, i, 1) = chr$(char)
  end if
next i
END SUB


