
From:    Phil Barnett 
To:      All                                      Msg #81, 03-Apr-90 10:39pm
Subject: Functions

Here are some Clipper functions that emulate the gather and scatter commands
found in other languages.
 
 *****************************
 
 PROCEDURE pubgather
 
 PARAMETERS prefix
 PRIVATE i,thisfield,lastfield
 If TYPE('PREFIX') <> 'C'      && did you specify a prefix?
    prefix = 'M'               && if you don't M is assigned
 ENDIF
 lastfield = Fcount()
 FOR i = 1 TO lastfield       && loop thru the fieldnames and make them public
    thisfield= Fieldname(i)
    PUBLIC &prefix&thisfield
 NEXT
 
 RETURN
 
 ****************************
 
 PROCEDURE gather
 
 PARAMETERS prefix
 PRIVATE i,thisfield,lastfield
 If TYPE('PREFIX') <> 'C'
    prefix = 'M'
 ENDIF
 lastfield = Fcount()
 FOR i = 1 TO lastfield       && loop thru the fieldnames and assign them
    thisfield = Fieldname(i)
    &prefix&thisfield = &thisfield
 NEXT
 
 RETURN
 
 ****************************
 
 PROCEDURE scatter
 
 PARAMETERS prefix
 PRIVATE i,thisfield,lastfield
 If TYPE('PREFIX') <> 'C'
    prefix = 'M'
 ENDIF
 lastfield = Fcount()
 FOR i = 1 TO lastfield       && loop thru the fieldnames and replace them
    thisfield = Fieldname(i)
    REPLACE &thisfield WITH &prefix&thisfield
 NEXT
 
 return
 
 ****************************
 
 PROCEDURE  relgather
 
 PARAMETERS prefix
 
 PRIVATE i,thisfield,lastfield
 If TYPE('PREFIX') <> 'C'
    prefix = 'M'
 ENDIF
 lastfield = Fcount()
 FOR i = 1 TO lastfield       && loop thru the fieldnames and release them
    RELEASE &prefix&thisfield
 NEXT
 
 return
 
 *******
 
It works like this:
 
 Select area
 pubgather()
 do while...
   gather()
   get mvars and do the reads.
   if confirm change
   scatter()
 enddo
 relgather()
 
It doesn't run as fast as hard coded mvars, but is very flexible!
 
--- TBBS v2.1/NM
