//.............................................................................
//
//   Program Name: F_BRA.PRG         Copyright: Ken Klein                                                
//   Date Created: 01/11/92           Language: Clipper 5.0                                         
//   Time Created: 14:37:44             Author: Ken Klein                                 
//   /brief/library.src
//   This program was written to answer a forum request from
//   Hans Schneider, 100033,2405.
//   
//   It is a very simple scrollable record editor.  It's purpose it to 
//   allow a scrollable edit for records containing more fields than 
//   screen rows to accomodate them. 
//   
//   For simplicity, I used ACHOICE.  It could be made much better by using 
//   a TBrowse Object.
//   
//	  I donate this code to the public domain.
//   
//   Ken Klein, 76655,2026
//.............................................................................
#include "Inkey.ch"
#include "dbstruct.ch"


FUNCTION BrowseEdit(nT,nL,nB,nR)
	LOCAL aFld := {}							  // array to browse
	LOCAL aStruct								  // structure of database
	LOCAL nW := 0								  // widest field
	LOCAL f := 1								  // field counter
	LOCAL nFld := 1								  // field counter
	LOCAL GetList := {}							  // getlist
	LOCAL editvar								  // varable to hold edit

	USE TEST NEW								  // insert any test database
	aStruct := DBSTRUCT()						  
	FOR f := 1 TO LEN(aStruct)					  // find longest var width
		nW:=IF(aStruct[f,DBS_LEN]>nW, aStruct[f,DBS_LEN], nW)
	NEXT
	nT := IF(nT==NIL,5,nT)
	nL := IF(nL==NIL,5,nL)
	nB := IF(nB==NIL,MAXROW()-5,nB)
	nR := IF(nR==NIL,nT+20+nW,nR)

	FOR f := 1 TO LEN(aStruct)
	   AADD(aFld,	PADR(aStruct[f,DBS_NAME],12)+" : "+ 			;
						Conv2Txt( EVAL( &("{||"+aStruct[f,DBS_NAME]+"}") ) ) 	;
			)
	NEXT
	nFld := 1									  // initalize for startitem
	DO WHILE LASTKEY() != K_ESC
		nFld := ACHOICE(nT,nL,nB,nR,aFld,,,nFld,)
		IF nFld > 0
			EditVar := FIELDGET(nFld)
			@ROW(),nL+15 GET EditVar
			READ
			IF LASTKEY() != K_ESC
				FIELDPUT(nFld,EditVar)
				aFld[nFld] := PADR(aStruct[nFld,DBS_NAME],12)+" : "+ 			;
						Conv2Txt( EVAL( &("{||"+aStruct[nFld,DBS_NAME]+"}") ) )

			ENDIF
		ENDIF
	ENDDO
RETURN NIL

FUNCTION Conv2txt( var )
	IF VALTYPE( var ) <> "C"
	   DO CASE
	   CASE VALTYPE( var ) == "D"
		  var := DTOC(var)
	   CASE VALTYPE( var ) == "N"
		  var := STR(var)
	   CASE VALTYPE( var ) == "L"
		  var := IF(var==.t.,"T","F")
	   CASE VALTYPE( var ) == "M"
		  var := "MEMO"
	   ENDCASE
	ENDIF
RETURN var

//    dB = tbrowseNew(5, 5, maxrow() - 5, maxcol() - 5)
//    dB:headsep = DEF_HSEP
//    dB:colsep  = DEF_CSEP
// 	dB:footsep = DEF_FSEP							
// 
//    dB:SkipBlock := ;
// 	  { |x| ;
// 		 k := IF(ABS(x) >= IF(x >= 0, LEN(aArray) - n, n - 1), ;
// 				 IF(x >= 0, LEN(aArray) - n, 1 - n), ;
// 				 x), ;
// 		 n += k, ;
// 		 k ;
// 	  }
// 
//    dB:GoTopBlock := { || n := 1 }
//    dB:GoBottomBlock := { || n := LEN(aArray) }
// 
//    // Create TBColumn objects,
//    // Initialize data retrieval blocks, and
//    // Add to TBrowse object
//    FOR nACol = 1 TO LEN( aArray[1] )
// 	  dB:AddColumn( TBColumnNew( "EDIT", ABlock("aArray[n]", nACol) ) )
//    NEXT

