****    From: Tomas Laubinger-Jorks, Gttingen, Germany
****
****    There are a couple of functions available, that help
****    programmers to create a SAA/CUA-compliant user interface.
****    By asking users we found out, that a majority of them didn't like
****    an interface that stuck too closely to these standards. So we couldn't
****    use some of the available libraries.
****    The new Funcky-II library has a few nice things for lazy programmers
****    like me, which help to write the needed functions with just a few
****    line of code
****
****    The following function creates a checkbox, from which either only
****    one element (like radiobuttons) or a few elements can be choosen
****    with the SPACE- or ENTER-key
****
****    A string consisting of spaces and one or more characters is returned
****    to the calling program. The characters indicate the position/s selected
****    and can be parsed by the next procedure.
****
****    You need the Funcky-II-library for this function !
****
****    This was done rather quickly (clients always want their
****    programs yesterday), so don't be to harsh to my coding. Anyway, if you
****    make some improvements, please let me know.
****
****     Compile:
****     clipper FunSAA /n /q /dCLIPPER /id:\FUNCky\HEADER\CLIPPER\
****     RTlink FILE FunSAA LIB CLIPPER, TERMINAL, DBFNTX, FUNCky51, FUNCkyVM, FUNCky2c, EXTEND;

****
****    If somebody still hasn't got a SAA-like Pulldown-menu,
****    I have hardcoded a working menu with Funcky-II as well. There
****    is much room for improvements, like using a multi-dimensional array
****    instead of code and thus having only two loops. I will do it
****    whenever I'll have some time ( whenever that will be ).
****
****    The parameter gives the starting position, returned to the calling
****    programm is the number of the array and array element
****
****
****

****** FunSAA.PRG *****************************************************

#include "Funcky.ch"

FUNCTION FunSaa
LOCAL nElements := 7                            && number of elements in array
LOCAL et[ nElements ]                           && array
LOCAL nPos    := 1                              && starting element
LOCAL cChar   := ''                            && character for selected
LOCAL cChoice := '      '                      && default choice
LOCAL nTopRow := 9, nCol := 47                  && row, column
LOCAL lRadio := .F.                             && Radiobuttons (.T.) .or. CheckBox (.F.)

FOR i = 1 TO nElements
   et[ i ] = etCreate(  nTopRow-1 + i , nCol, SUBSTR( cChoice, i, 1), 113, 1, '@X' )
NEXT i

cls( 7 )
aprint( 5, 20, '1 element (.T. ) or few elements (.F.) ?', 7 )  && 1 or more elements ??
@ 5,62 Get lRadio
READ
                                                     && paint the box
Box( nTopRow-2, nCol-5, nTopRow+nElements+2, nCol+20, SINGLE, 112 )
aprint( nTopRow,   nCol-1, '[ ]   ' + 'Choice 1', 112 )
aprint( nTopRow+1, nCol-1, '[ ]   ' + 'Choice 2', 112 )
aprint( nTopRow+2, nCol-1, '[ ]   ' + 'Choice 3', 112 )
aprint( nTopRow+3, nCol-1, '[ ]   ' + 'Choice 4', 112 )
aprint( nTopRow+4, nCol-1, '[ ]   ' + 'Choice 5', 112 )
aprint( nTopRow+5, nCol-1, '[ ]   ' + 'Choice 6', 112 )
aprint( nTopRow+6, nCol-1, '[ ]   ' + 'Choice 7', 112 )

aprint( 22, 22, ' and SPACE (or ENTER) to select', 7 )
aprint( 23, 22, '   PGDN to save    ESC to abort  ', 7 )

cChoice = ChkBox( et, nElements, nPos, cChoice, cChar, nTopRow, nCol, lRadio )

aprint( 22, 22, 'position        |1234567|         ', 7 )
aprint( 23, 22, 'choice          |' +  cChoice + '|        ', 7 )
csrput(  0,  0 )


/******************************************************************
**** CheckBox - Function
****    Parameters: et          array name
****                nTotal      total number of elements in array
****                nIndex      positon of cursor
****                cChoice     string with 'X' ( or any other character ) and spaces according to selected/not selected
****                cChar       character with indicates 'selected'
****                nRow        starting Row - 1
****                nCol        column
****                lRadio       TRUE   only 1 choice possible (radiobuttons )
****                            FALSE  more than 1 element can be selected
****
****    returns     cNew        string with 'X' ( or any other character ) and spaces according to selected/not selected
****
**********************************************************************/

FUNCTION ChkBox( et, nTotal, nIndex, cChoice, cChar, nRow, nCol, lRadio )
    LOCAL nKey := 0, nCount := nTotal, cNew := cChoice, x
    LOCAL lFirstRun := .T.

    DO WHILE( TRUE )

        IF lFirstRun .OR. lRadio
           lFirstRun := .F.
           FOR x := 1 TO nTotal                        && display fields
               etDisplay( et[x] )
           NEXT
           etSetFocus( et[ nIndex ], TRUE)             && set focus of starting field
        ENDIF


        etDisplay( et[nIndex] )                 && display editing field and position cursor
        csrput( etScrRow( et[nIndex] ), etScrCol( et[nIndex] ))

        nKey := inkey(0)                        && wait for keypress

        DO CASE
            CASE( nKey EQ ESC )                 && ESC ends the function and
                cNew := cChoice                 &&     restores original cChoice
                nIndex :=  0
                EXIT

            CASE( nKey EQ PGDN )                && PgDn ends function
                EXIT

            CASE( nKey EQ UPARROW  )
                etSetFocus(et[nIndex], FALSE)
                etDisplay(et[nIndex])
                nIndex := IIF( nIndex EQ 1, nTotal, nIndex - 1 )
                etSetFocus(et[nIndex], TRUE)

            CASE( nKey EQ DOWNARROW )
                etSetFocus(et[nIndex], FALSE)
                etDisplay(et[nIndex])
                nIndex := IIF( nIndex EQ nTotal, 1, nIndex + 1 )
                etSetFocus(et[nIndex], TRUE)

            CASE( nKey EQ ENTER OR nKey EQ SPACEKEY )
                                                      && for better reading an 'IF..ELSE..ENDIF'
                                                      && is used. IIF( .... ) can be used as well

               IF lRadio                               && Radiobuttons
                    FOR x = 1 TO nTotal               && clear all elements
                       et[ x ] = etCreate( nRow-1 + x, nCol, ' ', 113, 1, '@X' )
                    NEXT x                            && mark active element
                    et[ nIndex ] = etCreate(  nRow-1 + nIndex , nCol, cChar, 113, 1, '@X' )
                    cNew = SPACE( nIndex - 1 ) + cChar + SPACE( nTotal - nIndex )
                ELSE
                    IF substr( cNew, nIndex, 1 ) = ' '
                      et[ nIndex ] = etCreate(  nRow-1 + nIndex , nCol, cChar, 113, 1, '@X' )
                      cNew = LEFT( cNew, nIndex - 1 ) + cChar + RIGHT( cNew, nTotal - nIndex )
                    ELSE
                      et[ nIndex ] = etCreate(  nRow-1 + nIndex , nCol, ' ', 113, 1, '@X' )
                      cNew = LEFT( cNew, nIndex - 1 ) + ' ' + RIGHT( cNew, nTotal - nIndex )
                    ENDIF
                ENDIF
            ENDCASE
    ENDDO
   
RETURN( cNew )


****************************************************************************
****************************************************************************
**** MENUTEST.PRG ***
****
**** SAA-like Menu       // sorry, it's German
****
*****          written with Funcky-II-functions
*
* #include "Funcky.ch"
*
* FUNCTION MenuTest
* LOCAL nWahl := 11                   && Starting position
* LOCAL sScreen
*
* #define CoNrm           113         && a few colors
* #define CoMen           112
* #define CoMenSel         23
* #define CoMenPick        27
* #define CoMenPickS       30
* #define CoMenUnAvl      120
* #define CoError          79
*
* Cls( 7, '' )                           && Paint a screen
* cFrame = '͸Գ'
* box(  5,  0, 22, 79, cFrame , CoNrm )
* areplicate(  4, 0, ' ', 80, CoNrm )
* areplicate( 23, 0, ' ', 80, CoNrm )
* areplicate( 24, 0, ' ', 80, CoNrm )
*
*
* KEYB CHR( 13 )
*
* DO WHILE .T.
*    sScreen = SAVESCREEN( 0, 0, 24, 79 )
*    nWahl = Menu( nWahl )
*    RESTSCREEN( 0, 0, 24, 79, sScreen )
*    DO CASE
*    CASE nWahl = 0
*      EXIT
* *   CASE nWahl = 11
* *     ** here go the functions
* *   CASE nWahl = 12
* *     .....
* *   ..
* **    .....
* *   CASE nWahl = 59
* *     .....
*    OTHERWISE
*      aprint( 20,38, STR( nWahl, 5 ), CoError )
*      WaitKey(30)
*    ENDCASE
*    KEYB CHR( 13 )
* ENDDO
*
* RETURN( .T. )
*
* ******************************************************************
* #include "keys.ch"
*
* ** #ifdef CLIPPER
*   FUNCTION MENU( nWahl )
*   LOCAL nExit, nCol, nRow, cStr, nStandard, nEnhanced, nKey1, nKey2, sMenu, nHPos, nVPos
* ** #else
* **  PRIVATE nExit, nCol, nRow, cStr, nStandard, nEnhanced, nKey1, nKey2, sMenu, nHPos, nVPos
* **#endif
* DECLARE aMenu1[5], aMenu2[2], aMenu3[5], aMenu4[5], aMenu5[9], aMenu4[4]
*
* nHPos     = INT( nWahl / 10 )
* nVPos     = VAL( RIGHT( STR( nWahl, 2 ), 1 ) )
* nExit     = 1
* nCol      = 1
* nRow      = 5
* cStr      = ''
* nStandard = Standard( CoMen )
* nEnhanced = Enhanced( CoMenPick )
* nKey1     = 0
* nKey2     = 0
* sMenu     = savevideo( 5, 0, 22, 79 )
*
* aMenu1[1] = 'Stichwort      '
* aMenu1[2] = 'selektive Suche'
* aMenu1[3] = ''
* aMenu1[4] = 'Autor          '
* aMenu1[5] = 'Zeitschrift    '
*
* aMenu2[1] = 'Eintrag    '
* aMenu2[2] = 'Zeitschrift'
*
* aMenu3[1] = 'Update     '
* aMenu3[2] = ''
* aMenu3[3] = 'Zeitschrift'
* aMenu3[4] = 'Sachgebiet '
* aMenu3[5] = 'Wortliste  '
*
* aMenu4[1] = 'Bedienungsanleitung'
* aMenu4[2] = ''
* aMenu4[3] = 'Adressen           '
* aMenu4[4] = 'Info               '
*
* DO WHILE .T.
*     standard( CoMen )
*     enhanced( CoMenPick )
*     aprint( 4, 1, SPACE( 78 ), CoNrm )
*     ******* 1---!----1----!----2----!----3----!----4----!----5----!----6----!----7----!---', CoNrm )
*     *******  Suche  Neueingabe  Datei  Drucken  Verwaltung                       Hilfe
*     aprint( 4, 2, '^eS^suche  ^eN^seueingabe  ^eD^satei                                            ^eH^silfe', CoMen )
*
*     ****** Horizontale Eingabe
*     * nHPos = 1
*     DO WHILE .T.
*         DO CASE
*          CASE nHPos = 1
*             nCol = 2
*             cStr = '^eS^suche'
*          CASE nHPos = 2
*             nCol = 9
*             cStr = '^eN^seueingabe'
*          CASE nHPos = 3
*             nCol = 21
*             cStr = '^eD^satei'
*          CASE nHPos = 4
*             nCol = 70
*             cStr = '^eH^silfe'
*         ENDCASE
*         standard( CoMenSel )
*         enhanced( CoMenPickS )
*         aprint( 4, nCol, cStr, CoNrm )
*         nKey1 = WaitKey( 0 )
*         standard( CoMen )
*         enhanced( CoMenPick )
*         aprint( 4, nCol, cStr, CoMen )
*
*         DO CASE
*          CASE CHR( nupper( nKey1 ) ) = 'S'
*             nHPos = 1
*             nKey1 = ENTER
*          CASE CHR( nupper( nKey1 ) ) = 'N'
*             nHPos = 2
*             nKey1 = ENTER
*          CASE CHR( nupper( nKey1 ) ) = 'D'
*             nHPos = 3
*             nKey1 = ENTER
*          CASE CHR( nupper( nKey1 ) ) = 'H'
*             nHPos = 6
*             nKey1 = ENTER
*          ENDCASE
*
*          DO CASE
*          CASE nKey1 = ESC .OR. nKey1 = ENTER
*             EXIT
*          CASE nKey1 = RIGHTARROW
*             nHPos = IIF( nHPos < 4, nHPos + 1, 1 )
*          CASE nKey1 = LEFTARROW
*             nHPos = IIF( nHPos > 1, nHPos - 1, 6 )
*         ENDCASE
*     ENDDO
*
*     IF nKey1 = ESC
*         nWahl = 0
*         EXIT
*     ENDIF
*
*     DO CASE
*      ******* SUCHE
*      CASE nHPos = 1
*         box( 5, 0, 11, 18, '', CoMen )
*         arraprint( 6, 2, aMenu1, 1, 5, CoMen, 15, 0 )
*         DO WHILE .T.
*             standard( CoMenSel )
*             enhanced( CoMenPickS )
*             aprint( 5 + nVPos, 2, aMenu1[ nVPos ], CoMenSel )
*             nKey2 = WaitKey(0)
*             aprint( 5 + nVPos, 2, aMenu1[ nVPos ], CoMen )
*             DO CASE
*              CASE nKEy2 = DOWNARROW
*                 nVpos = IIF( nVPos < 5, nVPos + 1, 1 )
*              CASE nKey2 = UPARROW
*                 nVpos = IIF( nVPos > 1, nVPos - 1, 5 )
*              CASE nKey2 = ESC .OR. nKey2 = ENTER
*                 EXIT
*              CASE nKey2 = RIGHTARROW
*                 nHPos = 2
*                 nVPos = 1
*                 KEYB CHR( 13 )
*                 EXIT
*              CASE nKey2 = LEFTARROW
*                 nHPos = 6
*                 nVPos = 1
*                 KEYB CHR( 13 )
*                 EXIT
*             ENDCASE
*             IF aMenu1[ nVPos ] = ''
*                 nVPos = IIF( nKey2 = UPARROW, 2, 4 )
*             ENDIF
*         ENDDO
*          FOR i = 5 TO 12
*            aprint( i, 0, '', CoNrm )
*          NEXT i
*      ******* NEUEINGABE
*      CASE nHPos = 2
*         box( 5, 7,  8, 21, '', CoMen )
*         arraprint( 6, 9, aMenu2, 1, 2, CoMen, 11, 0 )
*         DO WHILE .T.
*             standard( CoMenSel )
*             enhanced( CoMenPickS )
*             aprint( 5 + nVPos, 9, aMenu2[ nVPos ], CoMenSel )
*             nKey2 = WaitKey(0)
*             aprint( 5 + nVPos, 9, aMenu2[ nVPos ], CoMen )
*             DO CASE
*              CASE nKEy2 = DOWNARROW
*                 nVpos = IIF( nVPos < 2, nVPos + 1, 1 )
*              CASE nKey2 = UPARROW
*                 nVpos = IIF( nVPos > 1, nVPos - 1, 2 )
*              CASE nKey2 = ESC .OR. nKey2 = ENTER
*                 EXIT
*              CASE nKey2 = RIGHTARROW
*                 nHPos = IIF( nHPos < 6, nHPos + 1, 1 )
*                 nVPos = 1
*                 KEYB CHR( 13 )
*                 EXIT
*              CASE nKey2 = LEFTARROW
*                 nHPos = IIF( nHPos > 1, nHPos - 1, 6 )
*                 nVPos = 1
*                 KEYB CHR( 13 )
*                 EXIT
*             ENDCASE
*         ENDDO
*
*      ***** DATEI
*      CASE nHPos = 3
*         box( 5, 19, 11, 34, '', CoMen )
*         arraprint( 6, 21, aMenu3, 1, 5, CoMen, 11, 0 )
*         DO WHILE .T.
*             standard( CoMenSel )
*             enhanced( CoMenPickS )
*             aprint( 5 + nVPos, 21, aMenu3[ nVPos ], CoMenSel )
*             nKey2 = WaitKey(0)
*             aprint( 5 + nVPos, 21, aMenu3[ nVPos ], CoMen )
*             DO CASE
*              CASE nKey2 = DOWNARROW
*                 nVpos = IIF( nVPos < 5, nVPos + 1, 1 )
*              CASE nKey2 = UPARROW
*                 nVpos = IIF( nVPos > 1, nVPos - 1, 5 )
*              CASE nKey2 = ESC .OR. nKey2 = ENTER
*                 EXIT
*              CASE nKey2 = RIGHTARROW
*                 nHPos = IIF( nHPos < 6, nHPos + 1, 1 )
*                 nVPos = 1
*                 KEYB CHR( 13 )
*                 EXIT
*              CASE nKey2 = LEFTARROW
*                 nHPos = IIF( nHPos > 1, nHPos - 1, 6 )
*                 nVPos = 1
*                 KEYB CHR( 13 )
*                 EXIT
*             ENDCASE
*             IF aMenu1[ nVPos ] = ''
*                 nVPos = IIF( nKey2 = UPARROW, nVPos - 1 , nVPos + 1 )
*             ENDIF
*         ENDDO
*
*
*      ***** HILFE
*      CASE nHPos = 4
*         box( 5, 57, 10, 79, '', CoMen )
*         arraprint( 6, 59, aMenu4, 1, 4, CoMen, 18, 0 )
*         DO WHILE .T.
*             standard( CoMenSel )
*             enhanced( CoMenPickS )
*             aprint( 5 + nVPos, 59, aMenu4[ nVPos ], CoMenSel )
*             nKey2 = WaitKey(0)
*             aprint( 5 + nVPos, 59, aMenu4[ nVPos ], CoMen )
*             DO CASE
*              CASE nKey2 = DOWNARROW
*                 nVpos = IIF( nVPos < 4, nVPos + 1, 1 )
*              CASE nKey2 = UPARROW
*                 nVpos = IIF( nVPos > 1, nVPos - 1, 4 )
*              CASE nKey2 = ESC .OR. nKey2 = ENTER
*                 EXIT
*              CASE nKey2 = RIGHTARROW
*                 nHPos = IIF( nHPos < 6, nHPos + 1, 1 )
*                 nVPos = 1
*                 KEYB CHR( 13 )
*                 EXIT
*              CASE nKey2 = LEFTARROW
*                 nHPos = IIF( nHPos > 1, nHPos - 1, 6 )
*                 nVPos = 1
*                 KEYB CHR( 13 )
*                 EXIT
*             ENDCASE
*             IF aMenu4[ nVPos ] = ''
*                 nVPos = IIF( nKey2 = UPARROW, nVPos - 1 , nVPos + 1 )
*             ENDIF
*         ENDDO
*          FOR i = 5 TO 12
*            aprint( i, 79, '', CoNrm )
*          NEXT i
*
*     ENDCASE
*
*     DO CASE
*      CASE nKey2 = ENTER
*         nWahl = nHPos * 10 + nVPos
*         EXIT
*     ENDCASE
*     restvideo( 5, 0, 22, 79, SMenu )
* ENDDO
*
* standard( nStandard )
* enhanced( nEnhanced )
* aprint( 4, 1, SPACE(78), CoNrm )
* RELEASE aMenu1[5], aMenu2[2], aMenu3[5], aMenu4[5], aMenu5[9], aMenu4[4]
* RETURN( nWahl )

