/* 
  Program to create a file containing "bitmap" strings
  
                      PUBLIC DOMAIN
                       NO COPYRIGHT
                       BY MATTHEW STABEN
                          STABEN TECHNOLOGIES
                          811 West 14th Avenue
                          Spokane, WA  99204
*/

clear screen
iput := spac(8)
@ 10,10 say "Filename to use (.FBM extension applied) : " get iput
read
fnm := alltrim(iput)+'.FBM'

fhndl := fcreate(fnm,0)
fwrite(fhndl,"Character Map File"+chr(26))

mapchars()
fclose(fhndl)
return(nil)


FUNCTION CHARMAP(char_arr,letter,reverse)
local string,pos,value,xxx,yyy,str

string := ''
for xxx := 1 to len(char_arr)
    /* convert each element to a decimal equivalent */
    /* by changing X's to 1's, spaces to 0's, and   */
    /* then doing the necessary math                */
    str := char_arr[xxx]
    value := 0
    for yyy := 0 to 7
        if subs(str,yyy+1,1) = 'X'
           if reverse
              value := value + (2^yyy)
           else
              value := value + (2^(7-yyy))
           endif
        endif
    next
    string := string+chr(value)
next
/* string needs to be written */
fwrite(fhndl,tnx(letter,3))
fwrite(fhndl,string,16)
return(nil)

FUNCTION tnx(value,no_chars)
local x1,x2

x1 := alltrim(str(value))
for x2 := no_chars to 2 step -1
    if value < 10^(x2-1)
       x1 := "0"+x1
    endif
next
return(x1)    
    
FUNCTION mapchars
local ma

sele 1
use chars
go top
ma := array(16)
do while .not. eof()

   for x := 1 to 16
       vbl := "SCANLINE"+alltrim(str(x))
       ma[x] := &vbl
   next
   
   charmap(ma,remap1,.f.)
   if mirror
      charmap(ma,remap2,.t.)
   endif
   skip
enddo

return(nil)
