/*
 * File......: ONTICK.C
 * Author....: Ted Means
 * Date......: $Date:
 * Revision..: $Revision:
 * Log file..: $Logfile:
 * 
 * This function is an original work by Ted Means and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log:
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FT_OnTick()
 *  $CATEGORY$
 *     <don't ask me>
 *  $ONELINER$
 *     Execute a designated Clipper routine at a designated interval.
 *  $SYNTAX$
 *     FT_OnTick( cFuncName, nInterval )
 *  $ARGUMENTS$
 *     <cFuncName> is the name of the desired function or procedure.
 *     <nInterval> is the number of clock ticks to wait between
 *                 invocations of the designated function or procedure.
 *  $RETURNS$
 *     NIL
 *  $DESCRIPTION$
 *     This function effectively allows you to run tasks in the background
 *     by transparently and periodically calling a designated routine.
 *
 *     Note that to achieve compatibility with CA-ExoSpace, you should
 *     compile this routine with the /G2 and /DEXOSPACE switches.  This will
 *     also change the function name to FT_OnTickX().
 *
 *     This function makes heavy use of several undocumented interal
 *     routines.  If this fact makes you uncomfortable then don't use
 *     this function, you quivering sack of cowardly slime.
 *  $EXAMPLES$
 *
 *     // Set up a self-updating on-screen clock
 *
 *     FT_OnTick( "CLOCK", 9 )
 *
 *     procedure Clock
 *
 *     local nRow := Row()
 *     local nCol := Col()
 * 
 *     @ 0, 0 say Time()
 *
 *     SetPos( nRow, nCol )
 *
 *     return
 *
 *  $SEEALSO$
 *     
 *  $END$
 */

#include "EXTEND.API"

typedef struct
{
   char junk[ 12 ];
   void * func;
} SYMBOL;

typedef union
{
   long far * Address;
   struct
   {
      unsigned int Offset;
      unsigned int Segment;
   } Pointer;
} LONGPTR;

SYMBOL * cdecl _Get_Sym( char * );

void cdecl _PutSym( void * );
void cdecl _evLow( unsigned int, void *, unsigned int );
void cdecl _bcopy( void *, void *, unsigned int );
void cdecl _PutQ( unsigned int );
void cdecl _xDo( unsigned int );

#ifdef EXOSPACE
long * cdecl ExoProtectedPtr( long *, unsigned int );
int cdecl ExoFreeSelector( unsigned int );
#endif

static long Ticks = 0;
static long Interval = 1;
static char funcName[ 11 ];
static char inProgress = 0;

static void cdecl TickTock( void )
{
   auto LONGPTR Timer;
   auto SYMBOL * pSym;

   if ( inProgress ) return;

   inProgress = 1;

   #ifdef EXOSPACE
   Timer.Address = ExoProtectedPtr( ( long * ) ( 0x0000046C ), sizeof( long ) );
   #else
   Timer.Address = ( long * ) ( 0x0000046C );
   #endif

   if ( *Timer.Address >= ( Ticks + Interval ) )
   {
      Ticks = *Timer.Address;

      pSym = _Get_Sym( funcName );

      if ( pSym != NULL )
      {
         _PutSym( pSym );

         _PutQ( 0 );

         _xDo( 0 );
      }
   }

   #ifdef EXOSPACE
   ExoFreeSelector( Timer.Pointer.Segment );
   #endif

   inProgress = 0;

   return;
}


#ifdef EXOSPACE
CLIPPER FT_OnTickX( void )
#else
CLIPPER FT_OnTick( void )
#endif
{
   auto unsigned int nLen = _parclen( 1 );
   auto char * pName;
   auto SYMBOL * Symbol;

   if ( nLen > 10 ) nLen = 10;

   if ( nLen == 0 )
      _evLow( 5, TickTock, FALSE );
   else
   {
      Interval = _parnl( 2 );

      pName = _parc( 1 );

      Symbol = _Get_Sym( pName );

      _bcopy( funcName, pName, nLen );

      funcName[ nLen + 1 ] = 0;

      _evLow( 5, TickTock, TRUE );
   }

   return;
}

