; File......: FLOPPY.ASM
; Author....: Ben Echols
; Date......: $Date:$
; Revision..: $Revision:$
; Log file..: $Logfile:$
; 
; The original author, has given me consent to place this file into
; public domain (he is my brother-in-law)... Kevin S. Gallagher
;
; Modification history:
; ---------------------
;
; $Log:$

;  $DOC$
;  $FUNCNAME$
;      FT_NUMDRV()
;  $CATEGORY$
;      disks
;  $ONELINER$
;      Returns the actual number of floppy disk drives present.
;  $SYNTAX$
;     FT_NUMDRV()
;  $ARGUMENTS$
;     None
;  $RETURNS$
;     - Number of floppy disk drives
;  $DESCRIPTION$
;     
;  $EXAMPLES$
;     FT_NUMDRV()
;  $END$


Public  FT_NUMDRV

extrn   __retni:far

_NanFor Segment Word PUBLIC 'CODE'
        Assume  CS:_NanFor

;////////////////////////////////////////////////////////////////////////////
;/ Function:      FT_NUMDRV;
;/
;/ Description:   This gets the number of floppy disk drives from the 
;/                equipment word
;/
;/ Inputs:        None
;/
;/ Outputs:       INT - number of floppy disk drives.
;/
;/ History:       08/12/92 -BEN-
;////////////////////////////////////////////////////////////////////////////
FT_NUMDRV       proc    far

        push    ax
        push    cx
;
;       Get the equipment word
;       Check bit 0 to see if drives installed
;       If so, shift the two drive bits right,
;               mask them,
;               and add 1.
;
        int     11h
        push    ax
        and     ax, 1
        jnz     drvnum
        pop     ax
        sub     ax, ax
        jmp     done
drvnum:
        pop     ax
        mov     cl, 6
        shr     ax, cl
        and     ax, 3
        add     ax, 1
done:
        push    ax
        call    __retni
        add     sp, 2

        pop     cx
        pop     ax

        ret

FT_NUMDRV       endp

_NanFor         ends

end
