/*
 * File......: FTDRIVES.PRG
 * Author....: Kevin S. Gallagher
 * CIS ID....: 70034,2313
 * Date......: $Date:$
 * Revision..: $Revision:$
 * Log file..: $Logfile:$
 * 
 * This is an original work by Kevin S. Gallagher and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log:$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *     FT_DRIVEBOX()
 *  $CATEGORY$
 *     DOS/BIOS
 *  $ONELINER$
 *     Change current drive with a user interface/selection box.
 *  $SYNTAX$
 *     FT_DRIVEBOX( [<cColor>, <lShadow>, <lHelp>] ) -> aResult
 *  $ARGUMENTS$
 *     <cColor>   Optional color string for the selection box
 *
 *     <lShadow>  Optional shadow for the selection box
 *
 *     <lHelp>    Displays a simple help screen above selection box
 *
 *  $RETURNS$
 *     aResult[1] logical true if operation was succuessfull, false if not.
 *     aResult[2] The drive that was selected, or a error message.
 *  $DESCRIPTION$
 *     This function presents a user with a list box that contains all the
 *     available drives on the system  that is running the current Clipper
 *     application.  The user simply selects a drive to log onto, by using
 *     the cursor keys to  highlight the desired drive  and then  pressing
 *     the [return] key to select, or they can press the letter of a drive
 *     to log on too.
 *
 *     When attempting to change to a floppy disk drive, the function will
 *     first determine if the drive is ready, and if not ready the user is
 *     presented with a message that explains the situation and prompt the
 *     user to either "retry" or "abort" the current operation.  Note that
 *     the only problems with floppies is that if there is only one floppy
 *     drive, and it was last accessed as drive B, then DOS will display a
 *     message to insert a diskette into drive B, even if drive A  was the
 *     drive selected! Also note that the function will save the status of
 *     the programs cursor, set wrap, and the screen, and restores them on
 *     exiting the function.
 *
 *     Optional parameters:
 *     The "color string" is used to display the selection box, and if not
 *     passed, the current Clipper colors are utilized.
 *     The "shadow" parameters determines if you want a shadow surrounding
 *     the boxes (defaults to no shadow).
 *     If "lHelp" is passed, a simple help screen is displayed, and if not
 *     passed the default is not to display the help screen.
 *
 *  $EXAMPLES$
 *     xDrive := FT_DRIVEBOX( "W+/B,GR+/RB", .T. )
 *     IF xDrive[1]          // returns either .T. or .F.
 *       ?"The new drive is ",xDrive[2]
 *     ENDIF
 *  $END$
 */

#xcommand DEFAULT <parm> TO <val> => IF <parm> == NIL ; <parm> := <val> ; END
#define SYSCOLOR      "W+/R,W+/N"
#define IS_CHAR(x)    (VALTYPE(x) == "C")
#define IS_LOGICAL(x) (VALTYPE(x) == "L")
#define aKeys_        {" Retry ", " Abort "}
#define aMsg_         {"FLOPPY DRIVE NOT READY", "DISKETTE NOT FORMATTED" ,;
                         "WRITE PROTECTION ON", "UNKNOWN ERROR"            }

#define aArr_  {"C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N",;
                "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z" }

#define FT_TEST
#ifdef FT_TEST
#define PICKONE "Press [enter] on a drive to test or [esc] to quit test"
#define PANEL() EVAL( {|| DISPBOX(0,0, MAXROW(),80, "", "w/b" )  ,;
                           DEVPOS(0,0), DEVOUT( PADC(PICKONE,80),"w+/b") } )
FUNCTION test
    LOCAL xDrive, oldcolor :=setcolor(), nChoice:=0
    PANEL()
    xDrive := FT_DRIVEBOX( NIL , .T., .T. )
    SETCOLOR(oldcolor)
    SCROLL()
    IF xDrive[ 1 ]
        @0,0 SAY PADR(" New drive is " + xDrive[2],    80)      COLOR "W+/B"
    ELSE
        @0,0 SAY PADR(IF( LEN( xDrive[2] ) == 1, " DRIVE " +;
             xDrive[2] + " NOT READY", xDrive[2]   ) , 80)      COLOR "W+/R"
    ENDIF
return nil
#endif

FUNCTION FT_DRIVEBOX( cColor, lshad, lHelp )
    LOCAL nByte   :=  FT_DEC2BIN( FT_PEEK(0,273) )                        ,;
          xDRIVE  :=  FT_DEFAULT()                                        ,;
          oldscrn :=  SAVESCREEN( 5, 0, 15, MAXCOL()+1 )                  ,;
          oldcur  :=  SETCURSOR( 0 )                                      ,;
          oldwrap :=  set( _SET_WRAP, .T. )                               ,;
          nTr     :=  12                                                  ,;
          nBr     :=  14                                                  ,;
          nTc     :=   0                                                  ,;
          nBc     :=   0                                                  ,;
          nChoice :=   0                                                  ,;
          nLen    :=   0                                                  ,;
          RetVal  :=  { }                                                 ,;
          aDisk_  :=  { }                                                 ,;
          nCount  :=   1


    cColor  := SETCOLOR( IF( IS_CHAR( cColor ) , cColor, "N/W,W+/N") )
    lShad   := IF( IS_LOGICAL( lShad ) , lShad, .F. )
    lHelp   := IF( IS_LOGICAL( lHelp ) , lHelp, .F. )

    IF EVAL( { || "1" $ SUBS(nByte, 2,1 ) .AND. "1" $ SUBS(nByte, 1,1 ) } )
        AEVAL( {" A "," B "}, { |x| AADD( aDisk_, x ) } )
    ELSE
        AADD( aDisk_, {" A "} )
    ENDIF

    AEVAL( aArr_ ,{ |x| IF( FT_DEFAULT( x ) == x, AADD(aDisk_," "+x+" " ), )  } )
    FT_DEFAULT(  xDRIVE )

    nLen := INT( ( 80 - ( LEN( aDisk_ ) * 3 ) ) * .5 )
    nTc  := nLen -1
    nBc  := ( ( LEN(aDisk_) * 3 ) +1 ) + nTc

    IF lHelp
        DISPBOX( nTr-5,20, nTr-2, 59, "Ŀ ")
        @nTr-4,28 SAY "S E L E C T    D R I V E"
        @nTr-3,22 SAY "[ENTER] TO SELECT - [ESC] TO ABANDON" 
    ENDIF
    DISPBOX( nTr,nTc, nBr, nBc, "Ŀ ")
    IF lShad
        FT_SHADOW( nTr,nTc, nBr, nBc ) 
        IF lHelp
            FT_SHADOW( nTr-5,20, nTr-2, 59 )
        ENDIF
    ENDIF
    WHILE nCount <= LEN( aDisk_ )
        @ 13,nLen PROMPT aDisk_[ nCount ]
        nLen +=3
        nCount++
    ENDDO

    MENU TO nChoice

    SETCOLOR( cColor )
    RESTSCREEN( 5, 0, 15, MAXCOL() +1, oldscrn )
    set( _SET_WRAP, oldwrap )
    SETCURSOR( oldcur )

    IF nChoice > 0
        RetVal := ASC( SUBSTR( aDisk_[ nChoice ], 2, 1 ) )
        DO CASE
            CASE RetVal == 65
                RETURN  { IF( _ft_flop( 0, "A" ), .T., .F. ), "A" }
            CASE RetVal == 66                 
                RETURN  { IF( _ft_flop( 1, "B" ), .T., .F. ), "B" }
            OTHERWISE
                RETURN  { .T., FT_DEFAULT( CHR( RetVal ) ) }
        ENDCASE
    ELSE
                RETURN  { .F., "USER ABORTED" }
    ENDIF
RETURN nil

FUNCTION _ft_flop( nDrive, cDrive )
    LOCAL iStatus := FT_FLOPTST( nDrive )
    WHILE iStatus <> 0
        IF iStatus == -1
            RETURN .F.
        ENDIF
        TONE(85,3.1)
        TONE(40,3.6)
        IF ALERT( aMsg_[ iStatus ] , aKeys_ ) <> 2
            iStatus := FT_FLOPTST( nDrive )
        ELSE
            RETURN .F.
        ENDIF
    ENDDO
    FT_DEFAULT( cDrive )
RETURN .T.
