/*
 * File......: xBox.Prg
 * Author....: Kevin S. Gallagher
 * Date......: $Date:$
 * Revision..: $Revision:$
 * Log file..: $Logfile:$
 * 
 * This is an original work by Kevin S. Gallagher and is placed in the
 * public domain.
 *
 *
 * This program file contains several functions for screen I/O, and may be
 * demoed with compiled with /dTESTING
 *
 * Function list:
 * --------------
 * FT_BOXDEF()      - thin line boxes, similar to Norton Utils boxes
 * FT_ZOOMBOX()     - explode a box to the console
 * FT_SHRINKBOX()   - implode a Zoomed box from the console
 * ALERT()          - alert replacement for ft_boxdef()
 *
 * The main function is ft_boxdef(), which is used to define several
 * characters for creating thin style boxes. The alert() function was
 * created, because the CA-Clipper internal alert modal box can not be
 * redefined (the line characters are hard-coded).
 *
 *
 * 
 * Modification history:
 * ---------------------
 *
 */


#include "nbox.h"

STATIC xStacks_ :={}, nWhich   := 0


#xcommand DEFAULT <parm> TO <foo> => IF <parm> == NIL ; <parm> := <foo> ; END

#xtranslate IS_NUM  ( <v> )   => ( VALTYPE ( <v> ) == "N"  )
#xtranslate IS_CHR  ( <v> )   => ( VALTYPE ( <v> ) == "C"  )
#xtranslate A_ONE   ( <v> )   => ASIZE( <v>, LEN( <v> ) -1 )

#ifdef TESTING
#define WAITER 4
#define MR MAXROW()
#define MC MAXCOL() + 1

FUNCTION TEST
    LOCAL oldcolor := setcolor("W+/RB,B/W"), oldcur := setcursor(0)
    LOCAL oError, bMyHandler, nKey := 0
    LOCAL aItems_ := {"DIRECTORY LISTING","DATA ENTRY","ABOUT","QUIT"}

    set(_SET_SCOREBOARD,.F.)

    // redefine characters
    FT_BOXDEFS()

    // draw backdrop
    FT_ZoomBox( 00, 00, MR, MC, 2,"W+/W" ,  1, NO_SHADOW )
    @00,00 say PADR(" ",MC)  color "W+/RB"
    @00,00 say THANDLE1      color "W+/N"
    @00,02 say THANDLE2      color "N/RB"

    WHILE .T.
        nKey := AChoose(10, 30, 15, 50, aItems_ )
        do case
            case nkey == len( aItems_ ) .or. nKey == 0
                exit
            case nKey == 1
                MyDir()
            case nKey == 2
                DummyGets()
            case nKey == 3
                ReadInfo()
        endcase
    ENDDO

    FT_SHRINKBOX(10)

    ALERT("PRESS ENTER TO INVOKE A PROGRAMMERS;ERROR;WHICH IS HANDLED LOCALLY",{" GET READY "})
    bMyHandler := ERRORBLOCK( { | e | Whathappened( e, .T. ) } )

    BEGIN SEQUENCE
        //
        // BASE ERROR 1098 --> arg error
        //
        ?VAL(999)
        //
        //
    RECOVER USING oError
        nKey :=ALERT("The Gig is up!;"+"Error code;"+str(oError:subcode,4), ;
              {"  Oooops  ","  Good Bye  "},"W++/G,W+/R")
    END SEQUENCE

    SETMODE ( 25 )
    setcursor( oldcur )
    IF nKey == 0
        @0,0 say "You pressed ESC" color "W+/R"
    ELSEIF nKey == 1
        @0,0 say "Sorry"           color "W+/R"
    ELSEIF nKey == 2
        @0,0 say "GoodBye"         color "W+/R"
    ENDIF

return nil

FUNCTION Whathappened( oErr, lLocal )
    IF lLocal
        BREAK oErr
    ENDIF
RETURN NIL

FUNCTION MyDir
    LOCAL aArr1_ :=DIRECTORY("*.*","D"), aDirs_ := {}, aFiles_:={}, jj, kk, i
    LOCAL oldBlink := SETBLINK(.F.)

    AEVAL( aArr1_, { | x | if(x[5] == "D" .and. !("." $ x[1]) ,;
           aadd(aDirs_, padr(x[1],20)+"D"), aadd(aFiles_, padr(x[1],20)+"F");
                             ) ;
                   };
    )
    jj := ASORT( aDirs_ )
    kk := ASORT( aFiles_ )

    for i:= 1 to len(kk)
        if(substr(kk[i],1,1) <> ".", aadd(jj,kk[i]), nil )
    next
    FT_ZoomBox( 01, 01, 05, 77, 1,"BG+*/B" ,  1, DO_SHADOW )
    @01,01 say PADR(" ",77)                                 color "W/W*+"
    @01,01 say THANDLE1                                     color "W+/N"
    @01,03 say THANDLE2                                     color "N/W+*"
    @01,30 say "-DIRECTORY LISTING-"                        color "R+/W+*"
    @02,02 say "D = Sub-directorie(s) if there are any!"    color "W+/B+*"
    @03,02 say "F = File(s)"                                color "W+/B+*"
    @04,02 say "When ready press [ENTER] for the main menu" color "W+/B+*"

    AChoose(10, 27, 18, 52, jj)
    FT_SHRINKBOX(5)
    SETBLINK( oldblink )
return nil

FUNCTION ReadInfo()
    LOCAL oldBlink := SETBLINK(.F.)
    LOCAL oldcolor := SETCOLOR("W+/B+*")
    FT_ZoomBox( 05, 01, 22, 78, 1,"W+/B+*" ,  1, NO_SHADOW )
    @06,02 say "Menu option number one, shows a directory listing with the TBrowse class."
    @07,02 say "Menu option number two, simulates a data entry screen."
    @08,02 say "When exiting the demo, I invoke a error with '?VAL(999)' to show the ALERT()"
    @09,02 say "replacement function - 'CA-Clippers' internal ALERT() routine has hard-coded"
    @10,02 say "characters that can not be redefined, hence we make our own which does the"
    @11,02 say "job. The only extra feature with the replacement ALERT() function is that it"
    @12,02 say "accepts a color string for the box color and the button colors.  The program"
    @13,02 say "file ERRORSYS.PRG needs a few tweaks for working correctly, see 'NEWERR.PRG'"
    @14,02 say "for modification notes.."
    @15,02 say "The Zoom and Shrink functions are used in place of all regular  CA-Clipper's"
    @16,02 say "box functions and background drawing routines.  When used properly they will"
    @17,02 say "save and restore prior screens. See source code for a better understanding.."
    @18,01 say CHR(195) + REPLICATE( CHR(200),76) + CHR(181)
    @19,02 say "CREDITS:"
    @20,02 say "Replacement 'ACHOICE()' for this demo was created by --> Luiz Quintela"
    @21,02 say "When ready to continue -press any key for the main menu!"
    inkey(0)
    FT_SHRINKBOX(5)
    SETBLINK( oldblink )
return nil


FUNCTION DummyGets()
    LOCAL getlist := {}
    LOCAL cFname := space(20), cLname := space(20)
    LOCAL cAddress:= space(30), cCity := space(20), cState := space(2)
    LOCAL cZipCode:= space(5), cPhone := space(12), oldcur := setcursor(3)
    LOCAL oldBlink := SETBLINK(.F.), oldcolor := setcolor("GR+/B+*,W+/N")

    FT_ZoomBox( 01, 01, 10, 77, 1,"BG+*/B+*" , 4, DO_SHADOW )
    @01,01 say PADR(" ",77)                                                  color "W/W*+"
    @01,01 say THANDLE1                                                      color "W+/N"
    @01,03 say THANDLE2                                                      color "N/W+*"
    @03,03 say "First name...: " get cFname   picture "!XXXXXXXXXXXXXXXXXXX" color "BG+/B+*,W+/N"
    @04,03 say "Last name....: " get cLname   picture "!XXXXXXXXXXXXXXXXXXX" color "BG+/B+*,W+/N"
    @05,03 say "Address......: " get cAddress picture "!XXXXXXXXXXXXXXXXXXX" color "BG+/B+*,W+/N"
    @06,03 say "City.........: " get cCity    picture "!XXXXX"               color "BG+/B+*,W+/N"
    @07,03 say "State........: " get cState   picture "@!"                   color "BG+/B+*,W+/N"
    @08,03 say "Zip code.....: " get cZipCode picture "99999"                color "BG+/B+*,W+/N"
    @09,03 say "Phone number.: " get cPhone   picture "999-999-9999"         color "BG+/B+*,W+/N"
    READ
    FT_SHRINKBOX(1)
    SETBLINK( oldblink )
    setcolor( oldcolor )
    setcursor( oldcur )
return nil
#endif

/*
 * File......: xBox.Prg
 * Author....: Kevin S. Gallagher
 * Date......: $Date:$
 * Revision..: $Revision:$
 * Log file..: $Logfile:$
 * 
 * This is an original work by Kevin S. Gallagher and is placed in the
 * public domain.
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *     FT_BOXDEFS
 *  $CATEGORY$
 *     Menus/Prompt
 *  $ONELINER$
 *     Text Mode Graphic Boxe
 *  $SYNTAX$
 *     FT_BOXDEFS
 *  $ARGUMENTS$
 *     None
 *  $RETURNS$
 *     NIL
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *     #include nbox.h
 *     FUNCTION MAIN
 *         FT_BOXDEFS()
 *         DispBox(1,1,10,79,FT_NORTBOX,"W+/B")
 *         @1,1 say replicate(" ",79)
 *         @1,1 say THANDLE1 color "w+/n"
 *         @1,col() say THANDLE2 color "w+/n"
 *         inkey(0)
 *         SETMODE( 25 )
 *         CLS
 *     RETURN NIL
 *  $END$
 */
FUNCTION FT_BOXDEFS
    local nArr_:={}, i
    local n0:=0, n1:=1, n2:=128, n3:=255, n4:=8, n5:=16, n6:=143, n7:=241

    nArr_ :={                                                               ;
    { { 127 },  { n1,n1,n1,n1,n1,n1,n1,n1,n1,n1,n1,n1,n1,n1,n1,n1 } } ,     ;
    { { 224 },  { n1,n1,n1,n1,n1,n1,n1,n1,n1,n1,n1,n1,n1,n1,n1,n3 } } ,     ;
    { { 181 },  { n1,n1,n1,n1,n1,n1,n1,n3,n1,n1,n1,n1,n1,n1,n1,n1 } } ,     ;
    { { 195 },  { n2,n2,n2,n2,n2,n2,n2,n3,n2,n2,n2,n2,n2,n2,n2,n2 } } ,     ;
    { { 200 },  { n0,n0,n0,n0,n0,n0,n0,n3,n0,n0,n0,n0,n0,n0,n0,n0 } } ,     ;
    { { 201 },  { n3,n2,n2,n2,n2,n2,n2,n2,n2,n2,n2,n2,n2,n2,n2,n2 } } ,     ;
    { { 203 },  { n0,n0,n0,n0,n0,n0,n0,n0,n0,n0,n0,n0,n0,n0,n0,n3 } } ,     ;
    { { 231 },  { n3,n1,n1,n1,n1,n1,n1,n1,n1,n1,n1,n1,n1,n1,n1,n1 } } ,     ;
    { { 205 },  { n3,n0,n0,n0,n0,n0,n0,n0,n0,n0,n0,n0,n0,n0,n0,n0 } } ,     ;
    { { 206 },  { n2,n2,n2,n2,n2,n2,n2,n2,n2,n2,n2,n2,n2,n2,n2,n3 } } ,     ;
    { { 209 },  { n3,n5,n5,n5,n5,n5,n5,n5,n5,n5,n5,n5,n5,n5,n5,n5 } } ,     ;
    { { 210 },  { n5,n5,n5,n5,n5,n5,n5,n5,n5,n5,n5,n5,n5,n5,n5,n5 } } ,     ;
    { { 211 },  { n5,n5,n5,n5,n5,n5,n5,n3,n0,n0,n0,n0,n0,n0,n0,n0 } } ,     ;
    { { 212 },  { n5,n5,n5,n5,n5,n5,n5,n3,n5,n5,n5,n5,n5,n5,n5,n5 } } ,     ;
    { { 213 },  { n3,n2,n2,n2,n2,n2,n6,n6,n2,n2,n2,n2,n2,n2,n2,n3 } } ,     ;
    { { 214 },  { n3,n1,n1,n1,n1,n1,n7,n7,n1,n1,n1,n1,n1,n1,n1,n3 } } ,     ;
    { { 215 },  { n2,n2,n2,n2,n2,n2,n2,n2,n2,n2,n2,n2,n2,n2,n2,n2 } }       }

    FOR i:= 1 TO LEN( nArr_ ) 
        NortDef( nArr_[ i, 1, 1 ], nArr_[ i, 2 ] )
    NEXT
RETURN nil

/*
 * File......: xBox.Prg
 * Author....: Kevin S. Gallagher
 * Date......: $Date:$
 * Revision..: $Revision:$
 * Log file..: $Logfile:$
 * 
 * This is an original work by Kevin S. Gallagher and is placed in the
 * public domain.
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *  FT_ZoomBox( <nTopRow>,<nTopCol>,<nBotRow>,<nBotCol>,<nType>, ;    
 *              <cColor>,<nTimeDelay>,<lShadow> ) --> NIL       
 *
 *  $CATEGORY$
 *     Menus/Prompt
 *  $ONELINER$
 *     Explode a box to the display screen
 *  $SYNTAX$
 *  FT_ZoomBox( <nTopRow>,<nTopCol>,<nBotRow>,<nBotCol>,<nType>, ;    
 *              <cColor>,<nTimeDelay>,<lShadow> ) --> NIL       
 *     
 *  $ARGUMENTS$
 *     <nTopRow> is a numeric that once the box is finshed exploding
 *     will be the upper left hand corner of the box. If this parameter
 *     is not passed the default will be row 0.
 *
 *     <nTopCol is a numeric that represents the upper left row position
 *     of the box, once it is finished exploding. If this parameter is
 *     not passed, it will default to column 0.
 *
 *     <nBotRow> is a numeric that once the box is finished exploding
 *     will be the bottom row of the box. If this parameter is not passed
 *     it will default to row 24.
 *
 *     <nBotCol is a numeric that represents the right bottom corner of
 *     the box, once it has finished exploding. If this parameter is not
 *     passed, it will default to column 79.
 *
 *     <nType> is a numeric value that designates the type of lines to 
 *     use when drawing the box. The default is box type 1.
 *
 *     <cColor> is a character string that is for coloring the box.
 *     The default color is 'White on Blue'.
 *
 *     <nDelay> represents a speed to paint the box to the console.
 *     If no value is passed, the box will not explode.
 *
 *     <lShadow> is a logical, that if passed as .T. will draw a shadow
 *     under the box, and .F. for no shadow. The default value is the
 *     default of FT_SHADOW, which is 8.
 *
 *  $RETURNS$
 *     Nil
 *
 *  $DESCRIPTION$
 *  FT_ZOOMBOX along with FT_SHRINKBOX allow a programmer to display boxes
 *  in a CA-Clipper application with zoom - in and fade - out FX. When the
 *  FT_SHRINKBOX function is used, the underlying screen will be restored
 *  in a similar fashion of if you used 'savescreen/restscreen'.
 *
 *  If this function is being used with FT_BOXDEF(), then you should use
 *  the header file, nBox.h, and use box type number 1, otherwise it can
 *  be used with regular boxes by altering NFRAME 
 *  as follows:
 *
 * #define USE_THIN
 *
 * #ifndef USE_THIN
 *    #define NFRAME {FT_NORTBOX,""}
 * #elseif
 *    #define NFRAME {"ͻȺ ", "Ŀ ","͸Գ ","ķӺ "}
 * #endif
 *
 *  $EXAMPLES$
 *  // This example will draw a box a 10,10,28,70 - using the colors
 *  // bright white on blue. The speed will be 50, and the shadow will
 *  // be the color magenta. FT_SHINKBOX will restore the old screen
 *  // once the user hits any key.
 *     FUNCTION MyTest
 *         FT_ZOOMBOX( 10, 10, 28, 70, "W+/GR", 50, .T., 5 )
 *         INKEY(0)
 *         FT_SHRINKBOX( 10 )
 *     RETURN NIL
 *  $END$
 */
FUNCTION FT_ZoomBox(nTR, nTC, nBR, nBC, nType, cColor, nDelay, lShad , nST  )
    local cDefColor, xx, nBCx, nTCx, nBRx, nTRx, xStackl_:= {}

    local savecur :=SETCURSOR(0)

    DEFAULT nTR    TO  0
    DEFAULT nTC    TO  0
    DEFAULT nBR    TO 24
    DEFAULT nBC    TO 79
    DEFAULT nType  TO  1                         //  1 or 2 for now
    DEFAULT nDelay TO  0
    DEFAULT lShad  TO .F.
    DEFAULT cColor TO "W/B"
    DEFAULT SHADOW_COLOR  TO 8

    SHADOW_COLOR := IF( SHADOW_COLOR >=9, 8, SHADOW_COLOR )

    // save initial screen for removal of box
    AADD( xStackl_, {;
    SAVESCREEN( nTr, nTc, nBr+1, nBc+2 ),nTr, nTc, nBr+1, nBc+2 } )

    nBCx := nTCx := ( INT( ( nBC - nTC + 1 ) / 2 ) + nTC )
    nBRx := nTRx := ( INT( ( nBR - nTR + 1 ) / 2 ) + nTR )
    cDefColor    := SETCOLOR( cColor )
    nDelay       := IF( IS_NUM(nDelay) ,nDelay *=10,0)
    nDelay       := IF( nDelay >= 1001 ,1000 ,nDelay )

    WHILE DRAWING

        FOR xx = 1 TO nDelay
        NEXT

        AADD( xStackl_, {;
        SAVESCREEN( nTRx, nTCx, nBRx+1, nBCx+2 ), nTRx, nTCx, nBRx+1, nBCx+2;
                        };
        )

        SETCOLOR( cColor )
        Dispbox( nTRx, nTCx, nBRx, nBCx, NFRAME[ nType ] )

        IF lShad
            FT_SHADOW( nTRx , nTCx , nBRx , nBCx, SHADOW_COLOR )
        ENDIF

        IF nTRx == nTR .AND. nTCx == nTC .AND. nBRx == nBR .AND. nBCx == nBC
            EXIT
        ENDIF

        // Increments the new coordinates
        nTRx -= IF( nTRx == nTR, 0, 1 )
        nTCx -= IF( nTCx == nTC, 0, 1 )
        nBRx += IF( nBRx == nBR, 0, 1 )
        nBCx += IF( nBCx == nBC, 0, 1 )
    ENDDO

    SETCOLOR( cDefColor )
    SETCURSOR( savecur )

    AADD( xStacks_, xStackl_ )
    nWhich++
return nil

/*
 * File......: xBox.Prg
 * Author....: Kevin S. Gallagher
 * Date......: $Date:$
 * Revision..: $Revision:$
 * Log file..: $Logfile:$
 * 
 * This is an original work by Kevin S. Gallagher and is placed in the
 * public domain.
 *
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *  FT_ShinkBox( <nDelay> )
 *
 *  $CATEGORY$
 *     Menus/Prompt
 *  $ONELINER$
 *     Implode a box that was exploded with FT_ZoomBox
 *  $SYNTAX$
 *     FT_SHRINKBOX( <nDelay> ) --> nil
 *  $ARGUMENTS$
 *     <nDelay> a numeric value that is used to either slowdown or speed
 *     up the time it takes to remove a box from the screen.
 *  $RETURNS$
 *     Nil
 *  $DESCRIPTION$
 *  This function permits a box that was exploded to the console to be 
 *  removed from the outside in, and also restore the underlying screen.
 *  $EXAMPLES$
 *  // This example will draw a box a 10,10,28,70 - using the colors
 *  // bright white on blue. The speed will be 50, and the shadow will
 *  // be the color magenta. FT_SHINKBOX will restore the old screen
 *  // once the user hits any key.
 *     FUNCTION MyTest
 *         FT_ZOOMBOX( 10, 10, 28, 70, "W+/GR", 50, .T., 5 )
 *         INKEY(0)
 *         FT_SHRINKBOX( 10 )
 *     RETURN NIL
 *  $END$
 */
FUNCTION FT_SHRINKBOX(ndelay)
    local xx, yy, zz, xStackl_, nCounter

    DEFAULT nDelay TO  50

    nDelay  := IF( IS_NUM(nDelay) ,nDelay *=10,0)
    nDelay  := IF( nDelay >= 1001 ,1000 ,nDelay )

    IF LEN( xStacks_ ) > 0
        xStackl_ := ATAIL( xStacks_[ nWhich ] )
        nCounter := LEN(   xStacks_[ nWhich ] )

        yy := nCounter
        FOR xx = yy TO 2 STEP -1
            RESTSCREEN( TOP, LEFT, BOTTOM, RIGHT, XSCRN )
            nCounter++
            FOR zz = 1 TO ndelay
            NEXT
            A_ONE( xStacks_[ nWhich ] )
            xStackl_ := ATAIL( xStacks_[ nWhich ] )
        NEXT
        A_ONE( xStacks_ )
        nWhich--
    ENDIF

return NIL


/*  $DOC$
 *  $FUNCNAME$
 *     ALERT()
 *  $CATEGORY$
 *     Menus/Prompt
 *  $ONELINER$
 *     Replacement ALERT() function for text mode graphic boxes
 *  $SYNTAX$
 *     ALERT( <cMessage>, [<aOptions>, <cColors>] ) --> nChoice
 *  $ARGUMENTS$
 *     <cMessage> is a text string, that if delimited by semi-colons can
 *                contain up to five lines of text centered. This is the
 *                same as the CA-Clippers alert function.
 *
 *     <aOptions> Same as CA-Clippers button options
 *
 *     <cColors>  Are the colors to display the alert box and text with.
 *                The proper syntax is box color/button color
 *
 *  $RETURNS$
 *     The original value converted to the new type.
 *  $DESCRIPTION$
 *  This replacement alert box was designed to allow error messages to be
 *  displayed while in Text-Mode Graphics mode. CA-Clipper's ALERT box
 *  lines can not be redefined to conform with the TMG routines.
 *
 *  Once linked into a application, this ALERT() will over-ride the ALERT()
 *  function supplied with CA-Clipper's internal alert() function.
 *
 *  Below are modifications needed to be made to the CA-Clipper file called
 *  ERRORSYS.PRG
 *
 *  Code extracted from ErrorSys.prg
 *
 *  BEFORE
 *	aOptions := {"Quit"}
 *  AFTER
 *	aOptions := {" Quit "}
 *
 *  You need to place a single space before and after the text for each
 *  button in the procedure called "ErrorSys()" for this alert box to work.
 *
 *  $EXAMPLES$
 *     FUNCTION DOSBOUND
 *         ?VAL(9)
 *     RETURN NIL
 *  $END$
 */
FUNCTION ALERT( cText, aOptions_, cNewColors )
    LOCAL oldcolor := "",                                                 ;
          oldScrn  := "",                                                 ;
          nOptions := 0,                                                  ;
          nChoice  := 0,                                                  ;
          nSpace   := 2,                                                  ;
          nSum     := 0,                                                  ;
          aLines_  := {},                                                 ;
          aText_   := {},                                                 ;
          nRows    := 0,                                                  ;
          nLines   := 0,                                                  ;
          nTr      := 0,                                                  ;
          nTc      := 0,                                                  ;
          nBr      := 0,                                                  ;
          nBc      := 0,                                                  ;
          nTemp    := 0,                                                  ;
          nIx      := 0,                                                  ;
          i        := 0

    aOptions_  := IF(valtype(aOptions_)  == "A", aOptions_ , { " Okay " } )
    nOptions   := LEN( aOptions_ )
    cNewColors := IF(valtype(cNewColors) == "C", cNewColors, "W+/R,W+/B"  ) 

    aText_     := LAArray( cText )

    set(_SET_WRAP,.T.)

    IF LEN( aText_ ) <= 5
        AEVAL( aText_,{ | x | AADD( aLines_, ALLTRIM( SUBS( x, 1,74 ) ) ) } )
    ELSEIF LEN( aText_ ) > 5
        FOR i := 1 TO 5
            AADD( aLines_, aText_[i] )
        NEXT
    ENDIF
    
    oldcolor:= setcolor( cNewColors )

    nLines  := FT_AEMAXLEN( aLines_ )

    AEVAL( aOptions_, { | x | nSum += LEN( x ) } )

    IF nLines <= nSum 
        nLines += nSum
    ENDIF

    nRows   := LEN( aLines_ )
    nTr     := INT( ( 24 - nRows  ) / 2 )
    nTc     := INT( ( 76 - nLines ) / 2 )
    nBr     := nTr + nRows  + 3
    nBc     := nTc + nLines + 3
    nIx     := nTr
    oldscrn := savescreen(nTr, nTc, nBr, nBc)

    DISPBOX(nTr, nTc, nBr, nBc, FT_NORTBOX )

    FOR i:= 1 TO nRows
        @ ++nIx, nTc+1 say PADC( aLines_[ i ], INT( ( nBc-nTc ) ) -1 )
    NEXT

    nTemp := ( INT( ( nBc-nTc ) / 2 ) - ( nSum/2 ) ) + nTc

    @ nBr-1,nTemp SAY " "
    FOR i := 1 TO nOptions
        @ nBr-1, COL() PROMPT aOptions_[ i ]
    NEXT

    MENU TO nChoice

    restscreen( nTr, nTc, nBr, nBc, oldscrn )
    setcolor( oldcolor )
RETURN nChoice

FUNCTION LAArray( cList )
    LOCAL nPos, aArray_ := {}, cDelim := ";"

    WHILE ( nPos := AT( cDelim, cList ) ) <> 0
        AADD( aArray_, SUBS( cList, 1, nPos -1 ) )
        cList    := SUBS( cList, nPos +1 )
    ENDDO

    AADD( aArray_, cList )
RETURN ( aArray_ )

FUNCTION KILL_UM
    xStacks_ :={}
    nWhich   := 0
return nil

