/*
* This file is only used for demoing the thin box function.
* It was extracted from a file that demos the new CA-Clipper v5.2 RDDs
*/

/*****
 *
 *   Application: General Purpose Routine
 *   Description: AChoice()-style menu
 *     File Name: CHOICE.PRG
 *        Author: Luiz Quintela
 *  Date created: 12-30-92
 *     Copyright: 1992 by Computer Associates
 *
 */

#define BUTTOM_COLOR                "GR+/N"
#define SCROLL_BAR_BGND_COLOR       "N/N"
#define BROW_DEFAULT_COLORS         "W+/RB,W+/N,,W+/N"

#include "nbox.h"
#include "inkey.ch"
#include "setcurs.ch"

/*****
 *
 *         Name: AChoose()
 *  Description: AChoice() replacement
 *       Author: Luiz Quintela
 * Date created: 12-30-92
 *    Copyright: Computer Associates
 *   Tweaked by: Kevin S. Gallagher
 * Date tweaked: 03/27/93
 *             :
 *    Arguments: nTop
 *             : nLeft
 *             : nBottom
 *             : nRight  -  window coordinates
 *             : aItems  - Array with Menu Items
 *             : aLogic  - Array with .T. or .F. for each item in menu
 *             : nMsgRow - Line to display messages
 *             : bBlock  - Codeblock to be executed while waiting for a key
 *             : cClrStr - Color pattern (as a string)
 *             : lShadow - Logical for using or not using a shadow
 * Return Value: nRet    - Subscript
 *     See Also:
 *
 * Modification: Added FT_ZoomBox in place of dispbox()
 *             : Added switch for disabling shadow
 *             : Added FT_Shadow() in place of Clipper coded shadow
 *             : Removed functions for Pushing/Poping old/new environment
 *             : Added header file 'nbox.h' for thin boxes
 */

FUNCTION AChoose(nTr,nTc,nBr,nBc,aItems,aLogic,nMsgRow,bBlock,cColor,lShadow)
    LOCAL oBrow, nKey, oCol, nNewPos, nLen, nInitPos, nWindow
    LOCAL nWidth, cSaveClr, nSubs, nRet, nActually
    LOCAL oldcolor := setcolor("W/N"), oldcur := setcursor( 0 )

    nLen    := Len( aItems )
    cColor  := IF(cColor == NIL, BROW_DEFAULT_COLORS, cColor)
    // lShadow := IF(valtype(lShadow) == "L", lShadow, .T. )

    // save/set  stuff


    nMsgRow := IF(nMsgRow == NIL, MaxRow(), nMsgRow)

    // No logical array so, create one!
    IF ValType(aLogic) != "A"
        aLogic := Array(nLen)
        AFill( aLogic, .T. )
    ENDIF

    nInitPos := 0
    nWindow  := nBr - nTr
    nWidth   := nBc - nTc - 1
    nRet     := 0

    bBlock   := IF( bBlock == NIL, { || .F. }, bBlock )
    FT_ZoomBox(nTr -1, nTc -1, nBr +1, nBc +1, 1, cColor , 10, .T. )
    DispBox(   nTr,    nBc +1, nBr,    nBc +1,CHR(177),SCROLL_BAR_BGND_COLOR)
    @ nTr,nBc + 1 SAY CHR(177) COLOR BUTTOM_COLOR
    oBrow := TBrowseNew( nTr, nTc, nBr, nBc )
    oBrow:colorSpec := cColor

    // nSubs is the array subscript
    nSubs := 1

    // Go Top and Go Bottom Blocks
    oBrow:goTopBlock    := {|| nSubs := 1 }
    oBrow:goBottomBlock := {|| nSubs := nLen }
    oBrow:skipBlock := {|nRequest| nActually := Iif(Abs(nRequest) >= ;
                           Iif(nRequest >= 0,;
                              nLen - nSubs, nSubs - 1),;
                                 Iif(nRequest >= 0, nLen - nSubs,;
                                    1 - nSubs),nRequest),;
                                       nSubs += nActually, ;
                                          nActually }

    oCol := TBColumnNew(, {|| aItems[nSubs]})

    // Colors for Selectable and Unselectable Items
    oCol:colorBlock := {|| Iif(aLogic[nSubs], {1, 2}, {1, 3})}
    oCol:width      := nWidth
    //
    // About Column Width:
    //
    // When browsing array elements, you need to pay attention
    // to their size. This is very importante because TBcolumn
    // will work based in the size of the first element of
    // the array being being browsed.
    // We are assuming the width between left and right margins
    //
    oBrow:addColumn(oCol)

    WHILE .T.

        DispBegin()

        WHILE !oBrow:stabilize()
            //
        ENDDO

        DispEnd()

        IF (oBrow:hitTop .OR. oBrow:hitBottom )
            Tone(87.3,1)
            Tone(40,3.5)
        ENDIF

        // Update Bar Gauge
        nNewPos := nWindow / (nLen / nSubs)
        IF nSubs == 1
            nNewPos := 0
        ELSEIF nSubs == nLen
            nNewPos := nWindow
        ENDIF
        IF ( nInitPos != nNewPos )
            @ nTr + nInitPos,nBc + 1 SAY CHR(177) ;
                                     COLOR SCROLL_BAR_BGND_COLOR
            @ nTr + nNewPos, nBc + 1 SAY CHR(177) ;
                                     COLOR BUTTOM_COLOR
            nInitPos := nNewPos
        ENDIF

        WHILE ( (nKey := InKey(0.1) ) == 0 )
            Eval(bBlock)
        ENDDO

        IF !TBMoveCursor( nKey, oBrow )
            // Key was not handled there, Lets try here
            IF ( nKey     == K_ESC )
                EXIT
            ELSEIF ( nKey == K_ENTER )
                // Is the item selectable?
                IF aLogic[nSubs]
                    // If so, return array subscript for the element
                    nRet := nSubs
                    EXIT
                ENDIF
            ENDIF
        ENDIF
    ENDDO

    FT_SHRINKBOX(5)
    setcursor( oldcur )
    setcolor( oldcolor)

RETURN (nRet)

FUNCTION TBMoveCursor( nKey, oBrow )
    LOCAL nFound
    STATIC aKeys :=                                          ;
                     { K_DOWN      , { | o | o:down()}      ,;
                       K_UP        , { | o | o:up()}        ,;
                       K_HOME      , { | o | o:home()}      ,;
                       K_END       , { | o | o:end()}       ,;
                       K_PGDN      , { | o | o:pageDown()}  ,;
                       K_PGUP      , { | o | o:pageUp()}    ,;
                       K_CTRL_PGUP , { | o | o:goTop()}     ,;
                       K_CTRL_PGDN , { | o | o:goBottom()}  ,;
                       K_RIGHT     , { | o | o:right()}     ,;
                       K_LEFT      , { | o | o:left()}      ,;
                       K_CTRL_LEFT , { | o | o:panLeft()}   ,;
                       K_CTRL_RIGHT, { | o | o:panRight()}  ,;
                       K_CTRL_HOME , { | o | o:panHome()}   ,;
                       K_CTRL_END  , { | o | o:panEnd()}     }

    nFound := ascan( aKeys, nKey )
    IF ( nFound != 0 )
        Eval( aKeys[++nFound], oBrow )

    ENDIF
RETURN ( nFound != 0 )



