* File Name: SEARCH.PRG
* Called by: DOS
*     Scope: Search file for string
*    Author: David W. Benson
*      Date: 03/29/89
*  Copyright (C) 1988 2nd Story Computing - All rights reserved
*
*
*  Compile and link with:
*
*            tlink search,,,clipper extend
*
set confirm on
fname = space(20)
s_str = space(20)
block = 0

do while .t.

   clear
   @ 01,32 say "SEARCH DEMO"
   @ 02,28 say "Type <ESC> to quit"
   @ 04,01 say "Name of file to search (d:\path\filename.ext):" ;
                get fname pict '@K!'
   @ 06,26 say "String to search for:"  get s_str pict '@k'
   read

   if empty(fname) .or. empty(s_str) .or. lastkey() = 27
      quit
   endif

   if !file("&fname")
      ?? chr(7)
      ?"File not found"
      inkey(1)
      loop
   endif

   handle = fopen(trim(fname), 2)

   do while .t.

      ptr = fsearch(handle, trim(s_str))

      if ptr < 0
         ? "End of search"
         ?
         wait
         exit
      else
         ?
         ? "Found at " + ltrim(str(ptr, 7))
         ?
         wait "Continue? (y/n)" to more
         if !more$"yY"
            exit
         endif
      endif

   enddo
   
   fclose(handle)

enddo
quit


FUNCTION fsearch
parameters hdl, string
private buffer, bytes_read, os

buffer = space(16*1024)                           && init buffer to 16k

start = fseek(hdl, 0, 1)
if start > 0
   start = fseek(hdl, 1, 1)                       && goto start of search
endif

do while .t.

   bytes_read = fread(hdl, @buffer, 16*1024)      && get 16k block

   os = at(string, buffer)                        && search block for string

   if os > 0                                      && if found

      return(fseek(hdl, (start + os - 1), 0))     && return start of string

   endif                                          && or, if not found

   ? ltrim(str(start + bytes_read, 7)) + ;        && show file position
     " - bytes read"

   if bytes_read < 16*1024                        && if eof

      return(-1)                                  && return not found

   else                                           && or if not eof

      start = fseek(hdl, -(len(string) - 1), 1)   && get new position

      buffer = space(16*1024)                     && re_initialize buffer

   endif

enddo                                             && and continue search
*


