
#include "FastGT.ch"


// **************************************************************
//
// This function draws a 3D window
//
// (C) 1992-93 Manu Roibal
//
Function GTBox( nTop, nLeft, nBottom, nRight, cColor )
Local cOldColor := SetColor( cColor )
Local lMouse    := MouseCursor( MOUSE_OFF )

    Scroll( nTop, nLeft, nBottom, nRight )

    SetColor( cOldColor )

    nBottom++                           // convert to graphic coordinates
    nRight++
    nLeft   := nLeft   *  8 + 4
    nRight  := nRight  *  8 - 5
    nTop    := nTop    * 16 + 4
    nBottom := nBottom * 16 - 5

    VESABox(  nTop - 4, nLeft - 4, nBottom + 4, nRight + 4,  7 )
    VESABox(  nTop - 3, nLeft - 3, nBottom + 3, nRight + 3, 15 )
    VESABox(  nTop - 2, nLeft - 2, nBottom + 2, nRight + 2, 15 )
    VESABox(  nTop - 1, nLeft - 1, nBottom + 1, nRight + 1,  7 )
    VESABox(  nTop,     nLeft,     nBottom,     nRight,      0 )

    MouseCursor( lMouse )

Return( Nil )




// **************************************************************
//
// This function draws a win3 window
//
// (C) 1992-93 Manu Roibal
//
Function GTWinBox( nY1, nX1, nY2, nX2, cColor, cTittle )
Local nPy1, nPx1, nPy2, nPx2, nCentre
Local lMouse    := MouseCursor( MOUSE_OFF )

    GTBox( nY1, nX1, nY2, nX2, cColor )

    nPy1 := nY1 * 16 + 5        // convert to graphic coordinates
    nPy2 := ( nY1 + 1 ) * 16
    nPx1 := nX1 * 8  + 5
    nPx2 := nX2 * 8  + 2

    VESASetArea( nPy1, nPx1 + 12, nPy2, nPx2, 1 )
    VESASetArea( nPy1, nPx1, nPy2, nPx1 + 11, 15 )

    VESABox( nPy1 + 5, nPx1 + 3, nPy2 - 4, nPx1 + 10,  8 )
    VESABox( nPy1 + 4, nPx1 + 2, nPy2 - 5, nPx1 +  9,  0 )

    VESASetArea( nPy1 + 5, nPx1 + 3, nPy2 - 6, nPx1 +  8, 15 )

    VESALine( nPy2, nPx1, nPy2, nPx2, 0 )
    VESALine( nPy1 - 1, nPx1 + 13, nPy1 - 1, nPx2, 3 )
    VESALine( nPy1 - 1, nPx1 + 13, nPy2 - 1, nPx1 + 13, 3 )

    nCentre = ( nX1 + ( nX2 - nX1 ) / 2 - Len( cTittle ) / 2 ) * 8

    VESAWriteAt( nPy1 + 2, nCentre, cTittle, 15, 1, FONT_SMALL )

    MouseCursor( lMouse )

Return( Nil )



// **************************************************************
//
// This function draws a win3 style buttom
//
// (C) 1992-93 Manu Roibal
//
Function DrawButtom( nY, nX, cMessage, lStatus )
Local nPy  := nY * 16
Local nPx  := nX * 8
Local nLen := Len( cMessage ) + 2
Local lMouse    := MouseCursor( MOUSE_OFF )

    lStatus := If( lStatus == Nil, .T., lStatus )

    VESABox( nPy, nPx, nPy + 15, nPx + nLen * 8 + 7,  0 )

    VESASetArea( nPy + 1, nPx + 1, nPy + 14, nPx + nLen * 8 + 6, 15 )

    If lStatus
      VESASetArea( nPy + 13, nPx + 2, nPy + 13, nPx + nLen * 8 + 6, 7 )
      VESASetArea( nPy + 14, nPx + 1, nPy + 14, nPx + nLen * 8 + 6, 7 )
      VESASetArea( nPy +  2, nPx + nLen * 8 + 5, nPy + 13, nPx + nLen * 8 + 5, 7 )
      VESASetArea( nPy +  1, nPx + nLen * 8 + 6, nPy + 14, nPx + nLen * 8 + 6, 7 )
      VESAWriteAt( nPy + 4, nPx + 10, cMessage, 0, 15, FONT_SMALL )
    Else
      VESASetArea( nPy + 1, nPx + 1, nPy +  1, nPx + nLen * 8 + 6, 7 )
      VESASetArea( nPy + 1, nPx + 1, nPy + 14, nPx + 1,            7 )
      VESAWriteAt( nPy + 6, nPx + 12, cMessage, 0, 15, FONT_SMALL )
    EndIf

    MouseCursor( lMouse )

Return( { nY, nX, cMessage } )



// **************************************************************
//
// This function pushs a win3 style buttom
//
// (C) 1992-93 Manu Roibal
//
Function PushButtom( hButtom )
    DrawButtom( hButtom[ 1 ], hButtom[ 2 ], hButtom[ 3 ], .F. )
    Inkey( .2 )
    DrawButtom( hButtom[ 1 ], hButtom[ 2 ], hButtom[ 3 ], .T. )
Return( Nil )



// **************************************************************
//
// This function draws an icon
//
// (C) 1992-93 Manu Roibal
//
Function DrawIcon( hIcon, lMode )
Local nInc   := If( lMode == Nil .Or. lMode,  0,  1 )
Local nRow   := hIcon[ 1 ]
Local nCol   := hIcon[ 2 ]
Local nColor := If( lMode == Nil .Or. lMode,  8,  7 )
Local lMouse := MouseCursor( MOUSE_OFF )

    VESASetArea( nRow -  2, nCol - 2,  nRow -  1, nCol + 33, 7 )

    VESALine( nRow -  1, nCol + 32, nRow + 33, nCol + 32, nColor )
    VESALine( nRow -  2, nCol + 33, nRow + 33, nCol + 33, 8 )

    VESASetArea( nRow -  2, nCol - 2,  nRow + 33, nCol -  1, 7 )

    VESALine( nRow + 32, nCol -  1, nRow + 32, nCol + 32, nColor )
    VESALine( nRow + 33, nCol -  2, nRow + 33, nCol + 33, 8 )

    VESAShowIcon( nRow + nInc, nCol + nInc, hIcon[ 3 ] )

    MouseCursor( lMouse )

Return( Nil )




// **************************************************************
//
// This function search the VESA mode to use
//
// (C) 1992-93 Manu Roibal
//
Function SearchMode()
Local nMode
Local aModes := { 261, 259, 257, 256 }
Local nInd   := 1
Local nBorra
    While ( nInd < Len( aModes ) + 1 ) .And. ( nMode == Nil )
      VESAMode( aModes[ nInd ] )
      nBorra := VESAMode()
      If ( nBorra == aModes[ nInd ] )
        nMode := Len( aModes ) - nInd
      EndIf
      nInd++
    End
Return( nMode )




// **************************************************************
//
// This function draws a bar
//
// (C) 1992-93 Manu Roibal
//
Function DrawBar( nY, nX, nHigh, nWeight, nShadow, nColor, nColShadow )
Local nInd
Local lMouse := MouseCursor( MOUSE_OFF )
    For nInd := 1 To nWeight + 1
      VESALine( nY, nX + nInd, nY - nHigh, nX + nInd, nColor )
    Next
    For nInd := 1 To nShadow
      VESALine( nY - nInd,         nX + nWeight + nInd, nY - nHigh - nInd, nX + nWeight + nInd, nColShadow )
      VESALine( nY - nHigh - nInd, nX + nInd,           nY - nHigh - nInd, nX + nWeight + nInd, nColShadow )
    Next
    MouseCursor( lMouse )
Return( Nil )




// **************************************************************
//
// This function draws a 3D box for write strings
//
// (C) 1992-93 Manu Roibal
//
Function UserBox( nY, nX, nLen, nColor1, nColor2 )
Local nX2
Local lMouse := MouseCursor( MOUSE_OFF )
    nY  *= 16          // convert text coordinates to graphic coordinates
    nX  *= 8           // a character is a 8x16 pixels
    nX2 := nX + nLen * 8
    VESALine( nY,      nX,      nY + 15, nX,      nColor1 )
    VESALine( nY,      nX2 - 1, nY + 15, nX2 - 1, nColor2 )
    VESALine( nY + 15, nX,      nY + 15, nX2 - 1, nColor2 )
    VESALine( nY,      nX,      nY,      nX2 - 1, nColor1 )
    MouseCursor( lMouse )
Return( Nil )

