/* 

 Espy Demo                                                                
 Developed by AJ Grace  CIS 72410,350                                     
                                                                          
 Demo of low level file search.  These techniques can be used on any file.  
 This search is always performed against a .dbf file.  The espy function  
 returns the number of the .dbf record where a match occured.             

*/

#include "inkey.ch"

LOCAL;
cFileName  := SPACE(8),;   // name of the .dbf file
cSearchStr := SPACE(80),;  // search string
lIsCaseSen := (.F.)    ,;  // is this a case sensitive search
lContinue  := (.F.)        // search from current pointer or TOF()

CLEAR SCREEN

DO WHILE (.T.)

   @ 10,10      SAY "File.............. "
   @ ROW()+1,10 SAY "Search For........ "
   @ ROW()+1,10 SAY "Case Sensitive.... "
   @ ROW()+1,10 SAY "Continuous Search. "

   @ 10,32      GET cFileName  
   @ ROW()+1,32 GET cSearchStr PICT "@S40"
   @ ROW()+1,32 GET lIsCaseSen PICT "Y"
   @ ROW()+1,32 GET lContinue  PICT "Y" 

   READ

   IF LASTKEY()=K_ESC
      EXIT
   ENDIF

   nRecno := Espy(cFileName,ALLTRIM(cSearchStr),lIsCaseSen,lContinue)

   IF nRecno>0
      @ 24,2 SAY "Found at "+ALLTRIM(STR(nRecNo))+".  Display Record? (Y/N)"
      INKEY(0)
      @ 24,0
      IF LASTKEY()=121.OR.LASTKEY()=89
         Displayrecord(cFileName,nRecNo)
         CLEAR SCREEN
      ENDIF
   ELSE
      @ 0,0
   ENDIF

ENDDO

********************************************************
FUNCTION Espy(cFileName,cSearchStr,lIsCaseSen,lContinue)
********************************************************
/*
Syntax: Espy( cFileName, cSearchStr, <lIsCaseSen>, <lContinue>)
Description: Espy() searches any .dbf file for a specified string.  
Arguments:   <cFileName>  file Name & extension
             <cSearchStr> character string to search for
             <lIsCaseSen> logical .T. if case sensitive search
                          logical .F. if non case sensitive search
             <lContinue>  logical .T. to continue searching from 
                          current pointer.  Logical .F. to search
                          from top of file down.
*/

LOCAL;
cOldScreen    := SAVESCREEN(24,0,24,79),;
nHandle       := 0,;
lError        := (.F.),;
nRecNo        := 0

STATIC nBytes := 0

lIsCaseSen    := IIF(lIsCaseSen==NIL,.F.,lIsCaseSen)
lContinue     := IIF(lContinue==NIL,.F.,lContinue)
nBytes        := IIF(lContinue,nBytes,0)

IF cFileName # NIL .AND. cSearchStr # NIL 
   nHandle := FOPEN(cFileName,66) //open for shared use <66>
ENDIF

lError  := nHandle <= 0

IF !lError

   nRecNo := EspySearch(nHandle,cSearchStr,@nBytes,lIsCaseSen,cFileName)

   FCLOSE(nHandle)

ELSE

   @ 24,2 SAY "Open Error or Argument Error.  Press any key..."

   INKEY(0)

   @ 24,0

ENDIF

RETURN nRecNo

**************************************************************************
STATIC FUNCTION EspySearch(nHandle,cSearchStr,nBytes,lIsCaseSen,cFileName)
**************************************************************************
LOCAL nFoundAt,nRecno

FSEEK(nHandle,nBytes,0)

nFoundAt := F_LOCATE(nHandle,cSearchStr,lIsCaseSen)  

IF nFoundAt >= 0
   nRecNo := Offset2RecNo(nFoundAt,cFileName)
   nBytes := ++nFoundAt
ELSE
   nRecNo := nFoundAt
   nBytes := 0
ENDIF

RETURN nRecNo

*************************************************
STATIC FUNCTION Offset2RecNo(nOffSet,cFileName)
*************************************************
// convert an offset to a .dbf record number

LOCAL;
cPrefix:=SUBSTR(cFileName,1,AT(".",cFileName)-1),;
nRecNo,;
lCloseit:=(.F.),;
nOldArea:=SELECT(),;
lNew

lNew:=OpenDbf(cPreFix)

nRecNo := (nOffSet-HEADER()) / RECSIZE()

IF MOD((nOffSet-HEADER()),RECSIZE())#0
   nRecNo:=INT(nRecNo)+1
ENDIF

IF lNew
   USE
   SELECT(nOldArea)
ENDIF

RETURN IIF(nRecNo=0,1,nRecNo)

**************************************************
STATIC FUNCTION F_Locate(nHandle,cSearchStr,lCase)
**************************************************
LOCAL;
nMemBlock  := 20000 
LOCAL;
cBuffer    := SPACE(nMemBlock),;
nBytesRead := nMemBlock,;
nFoundAt   := 0,;
lFound     := (.F.),;
nOffSet    := 0
lCase      := IIF(lCase==NIL,.F.,lCase)

DO WHILE nBytesRead=nMemBlock.AND.!lFound
   nOffSet    := FSEEK(nHandle,0,1)
   nBytesRead := FREAD(nHandle,@cBuffer,nMemBlock)
   nFoundAt   := AT( IIF(!lCase,UPPER(cSearchStr),cSearchstr),;
                 IIF(!lCase,UPPER(cBuffer),cBuffer))
   lFound     := nFoundAt # 0
ENDDO

RETURN IIF(lFound, nOffSet + nFoundAt,-1)

***********************************************
STATIC FUNCTION DisplayRecord(cFileName,nRecNo)
***********************************************
LOCAL cPrefix:=SUBSTR(cFileName,1,AT(".",cFileName)-1)
LOCAL;
x,;
y:=0,;
lNew:=OpenDbf(cPreFix),;
cOldArea:=SELECT()
GOTO nRecNo
PRIVATE aFields[FCOUNT()]
AFIELDS(aFields)
CLEAR SCREEN
FOR x:=1 TO FCOUNT()
   @ ROW()+1,0 SAY SUBSTR( aFields[x] + SPACE(10) ,1,10)+" "
   @ ROW(),15 SAY &(aFields[x])
   IF ++y=24
      INKEY(0)
      CLEAR SCREEN
      y:=0
   ENDIF
NEXT

INKEY(0)
CLEAR SCREEN

IF lNew
   USE
   SELECT(cOldArea)
ENDIF

RETURN NIL

**********************************
STATIC FUNCTION OpenDbf(cFileName)
**********************************
IF SELECT(cFileName)=0
   USE (cFileName) SHARED NEW
   lNew:=(.T.)
ELSE
   SELECT(cFileName)
   lNew:=(.F.)
ENDIF
RETURN lNew


//End Of Demo


