* fptest.prg
*
* Test program for FAXPak Library for Clipper
*
* Compile as usual and link as usual
*
* RTLINK Fi FPTEST Lib FPCLIP
*
*
PROCEDURE main1
 	LOCAL cCover := ;
 		"This is line one of the cover text" + CHR(10) + ;
 		"This is line two of the cover text" + CHR(10) + ;
 		"This is the third line of some text to appear on the cover" + CHR(10)
	
	LOCAL nEvent, nResult, aData := {}
	LOCAL	aArr := { ;
		nil, ;							// from (use default name from board)
		"Jeff Hofstetter", ;			// to
		"1.303.440.7683", ;			// phone
		nil, ;							// date
		nil, ;							// time
		1, ;								// type 1 = fax standard resolution
		"c:\sfax\map.pcx", ;			// logo
		0, ;								// delete
		"This is the tag field", ;	// tag
		.T., ;							// cover flag
		cCover, ;							// cover text
		0, ;								// textsize 0 = normal
		0, ;								// page length 0  = 8.5 inches
 	}

	LOCAL aFiles := { "c:\autoexec.bat", "d:\projects\fpclip\fpclip.doc" }

	IF .NOT. FPINIT()
		? "Sorry no fax board found!"
		QUIT
	ENDIF

	nEvent = FPSUBMIT(aArr, aFiles)
	IF nEvent < 0
		? "Uh-oh! An error happened: ", nEvent
		QUIT
	ELSE
		? "Fax was submitted. Event ID is", nEvent
	ENDIF
	?
	? "Now I'm sittin' here waiting for the fax to be sent so I can"
	? "get the status of it. Press a key when you think it is done..."

	DO WHILE( INKEY() == 0)	
	ENDDO
	?
	nResult = FPSTATUS(nEvent, aData)
	DO CASE
	CASE nResult == 0
		? "Sorry event not found. Perhaps it is still being sent!"
	CASE nResult < 0
		? "Sorry got an error code back:", nResult
	CASE nResult == 1
		?
		? "Okay! Here's what I know"
		? "Event Type              :", aData[1]
		? "Trans type              :", aData[2]
		? "Status                  :", aData[3]
		? "Send time               :", aData[4]
		? "Send date               :", aData[5]
		? "Length of transmission  :", aData[6]
		? "# of transmission errors:", aData[7]
		? "Remote CSID             :", aData[8]
		? "Tag field               :", aData[9]
	ENDCASE
RETURN

