*************************************************************************
*                                                                       *
*                            Arrays.prg                                 *
*                                                                       *
*           A series of FoxBASE/FoxPro clones of Clipper                *
*                functions for manipulating arrays.                     *
*                                                                       *
*                       Comments are INVITED!                           *
*            ==========================================                 *
*                                                                       *
*                                                                       *
*  Date    : April/May 89                                               *
*  Revised : July/August 90                                             *
*  Author  : Steve Freides, Friday's Computer, NYC                      *
*            CompuServe User ID#: 76070,231                             *
*                                                                       *
*  Contains 9 UDF's:                                                    *
*                                                                       *
*      1.  achoice()                                                    *
*      2.  acopy()                                                      *
*      3.  adel()                                                       *
*      4.  adir()                                                       *
*      5.  afields()                                                    *
*      6.  afill()                                                      *
*      7.  ains()                                                       *
*      8.  ascan()                                                      *
*      9.  asort()     && Thanks to Tamar E. Granor!!!                  *
*                                                                       *
*  Also contains a demo programs for                                    *
*      adir(), achoice(), ascan() and optionally asort().               *
*                                                                       *
*  Notes:  All these UDF's make extensive use of macros.                *
*          If you use them on arrays of any size, be sure               *
*          to replace the macros with hard-coded variable               *
*          names in your finished applications.                         *
*                                                                       *
*          Next paragraphs only make sense if                           *
*          you've read the actual code!:                                *
*                                                                       *
*          All these functions assume that the                          *
*          passed parameter 'a_len' is the number                       *
*          of array elements to be searched.                            *
*          Normally, this will be the number of                         *
*          elements in the array, but it <may> be less.                 *
*          Additionally, another parameter <could> be                   *
*          passed to specify at which element to start.                 *
*          As written, the functions always start with                  *
*          the first element.                                           *
*                                                                       *
*          All these functions require arrays names be                  *
*          passed as string literals, i.e., Clipper                     *
*          would use AFILL(my_array), Fox requires                      *
*          AFILL("my_array").  There are other differences              *
*          in syntax necessitated by the differences in the             *
*          languages themselves, but these are minor.                   *
*                                                                       *
*          Possible future enhancements include variable                *
*          numbers of passed parameters, allowable in FoxPro            *
*          and, of course, Clipper, but verboten in FoxBASE.            *
*                                                                       *
*************************************************************************

  *  The usual housekeeping *
  SET ECHO OFF
  sys_talk = SYS(2001,"talk")
  SET TALK OFF
  sys_stat = SYS(2001,"status")
  SET STATUS OFF

  sys_colo = SYS(2001,"color")
  * Color of GETs
  get_colo = RIGHT(sys_colo,LEN(sys_colo)- AT(",",sys_colo))
  get_colo = LEFT(get_colo,AT(",",get_colo)-1)
  
  * Parse the main color/background
  front_colo = LEFT(sys_colo,AT("/",sys_colo)-1)
  back_colo  = SUBSTR(sys_colo,AT("/",sys_colo)+1, ;
   AT(",",sys_colo)-(LEN(front_colo)+2))
  box_colo   = back_colo+"/"+front_colo

  SET ESCAPE OFF
  SET MESSAGE TO 9

  PUBLIC foxpro
  IF ! foxpro
    proc_name = SYS(16)
    SET PROC TO &proc_name
    RELEASE proc_name
  ENDIF

  * Code to choose which of two demos to run *
  menuvar = 1
  DO WHILE menuvar <> 0
    menuvar = 1
    @ 0, 0 CLEAR
    SET COLO TO &get_colo
    @ 2,10 SAY "  A R R A Y - H A N D L I N G    D E M O N S T R A T I O N  "
    SET COLO TO &sys_colo
    @ 4,32 SAY "<Esc> to Exit"
    @ 5,28 TO  8,51 DOUBLE
    @ 6,30 PROMPT " Directory Services " MESSAGE SPACE(20) + "adir(), achoice() and optionally asort()"
    @ 7,30 PROMPT " Array Searching    " MESSAGE SPACE(36) + "ascan()"
    MENU TO menuvar
    DO CASE
    CASE menuvar = 1
      DO demo1
    CASE menuvar = 2
      DO demo2
    ENDCASE        
  ENDDO
  * End of code to choose which of two demos to run *

  *  The usual housekeeping *
  SET MESSAGE TO 24
  SET PROC TO
  SET TALK ON
  SET ESCAPE ON
  SET STAT ON          && I still use it
  RETURN
********
PROCEDURE achoice
  *
  * #1 in a series of FoxBASE+ 2.1 clones of Clipper
  * functions for manipulating arrays.
  *
  * Date    : 22 April 89
  * Author  : Steve Freides
  *
  * Purpose : Displays a pop-up menu, allowing selection
  *           of one element of an array.  Very useful, with
  *           adir(), in allowing selection from a menu of
  *           files on disk.
  *
  * Returns : <exp_N>, the number of the array element chosen.
  *
  PARAMETERS row, col, a_name, a_len, num_selects, title
  *
  *   row         = <exp_N>, the starting display row
  *   col         = <exp_N>, the starting display column
  *   a_name      = <exp_C>, the name of the array
  *   a_len       = <exp_N>, the array's length
  *   num_selects = <exp_N>, the number on-screen at one time
  *   title       = <exp_C>, the heading for the menu
  *
  PRIVATE ret_val
  ret_val = 1

  * This stuff is new to FoxBASE+ Version 2.1.  Very handy, eh?
  @ row, col MENU &a_name, a_len, num_selects TITLE title

  READ MENU TO ret_val

  RETURN ret_val
********
PROCEDURE acopy
  *
  * #2 in a series of FoxBASE+ 2.1 clones of Clipper
  * functions for manipulating arrays.
  *
  * Date    : 6 May 89
  * Author  : Steve Freides
  * Purpose : To copy the contents of one array to another, up to
  *           the length of the shortest of the two arrays.
  *
  PARAMETERS a_name_1, a_name_2, a_len_1, a_len_2
  *
  *  a_name_1   = <exp_C>, name of the source array
  *  a_name_2   = <exp_C>, name of the target array
  *  a_len_1    = <exp_N>, length (number of elememts) in source array
  *  a_len_2    = <exp_N>, length (number of elememts) in target array

  SET TALK OFF
  PRIVATE num, a_len_min
  num       = 0
  a_len_min = MIN(a_len_1,a_len_2)

  DO WHILE num < a_len_min
    num = num + 1
    &a_name_2(num) = &a_name_1(num)
  ENDDO

  RETURN ""
********
PROCEDURE adel
  *
  * #3 in a series of FoxBASE+ 2.1 clones of Clipper
  * functions for manipulating arrays.
  *
  * Date    : 6 May 89
  * Author  : Steve Freides
  * Purpose : To delete a specified element from an array, moving
  *           the remaining elements down one place and making
  *           the last element .F. (the FoxBASE+ default).
  *
  PARAMETERS a_name, a_len, element_no
  *
  *  a_name     = <exp_C>, name of the array
  *  a_len      = <exp_N>, length (number of elememts) in array
  *  element_no = <exp_N>, the element to delete.
  *

  SET TALK OFF

  DO WHILE (element_no <= a_len) 
    * Move each element back one place, and make the last elememt .F.
    IF element_no < a_len
      &a_name(element_no) = &a_name(element_no+1)
    ELSE
      &a_name(element_no) = .F.
    ENDIF
    element_no = element_no + 1
  ENDDO

  RETURN ""
********
PROCEDURE adir
  *
  * #4 in a series of FoxBASE+ 2.1 clones of Clipper
  * functions for manipulating arrays.
  *
  * Date    : 22 April 89
  * Author  : Steve Freides
  *
  * Purpose : Find the number of files that match
  *           a specific directory skeleton.
  *
  * Returns : <exp_N>, the number of matching files
  *
  *   Notes : Useful, with achoice(), for allowing selection
  *           of files from disk.
  *
  PARAMETERS skeleton, a_name
  *
  *  skeleton = <exp_C>, expression to match
  *    a_name = <exp_C>, the name of a Public array to create.
  *                      If "" is passed, no array will be created.
  *
  PRIVATE num, a_len
  num      = 0 
  a_len    = 0

  IF LEN(SYS(2000,skeleton)) > 0
    a_len = 1
  ENDIF
  DO WHILE LEN(SYS(2000,skeleton,1)) > 0
    a_len = a_len + 1
  ENDDO

  IF a_len > 0 .AND. LEN(a_name) > 0
    RELEASE &a_name
    PUBLIC &a_name(a_len)
    num = 1
    &a_name(num) = SYS(2000,skeleton)
    DO WHILE num < a_len
      num = num + 1
      &a_name(num) = SYS(2000,skeleton,1)
    ENDDO
  ENDIF    

  RETURN a_len
********        
PROCEDURE afields
  *
  * #5 in a series of FoxBASE+ 2.1 clones of Clipper
  * functions for manipulating arrays.
  *
  *    Date : 6 April 89
  *  Author : Steve Freides
  *
  * Purpose : To fill two arrays with the names of .dbf
  *           fields and their data types.
  *
  *   Notes : The implementation of the optional parameters
  *           in the Clipper version is quite difficult and
  *           slow, so I've chosen to leave them out.
  * 
  PARAMETERS f_name, f_type
  *
  *  f_name  = <exp_C>, name of the array to hold field names
  *  f_type  = <exp_C>, name of the array to hold field types
  *
  SET TALK OFF

  PRIVATE num, a_len
  num   = 0
  a_len = FCOUNT()

  DO WHILE num < a_len
    num = num + 1
    &f_name(num) = FIELDS(num)
    &f_type(num) = TYPE(FIELDS(num))
  ENDDO

  RETURN a_len
********
PROCEDURE afill
  *
  * #6 in a series of FoxBASE+ 2.1 clones of Clipper
  * functions for manipulating arrays.
  *
  * Date    : 6 May 89
  * Author  : Steve Freides
  * Purpose : To initialize all elements of an array with a single value
  *
  PARAMETERS a_name, value
  *
  *  a_name     = <exp_C>, name of the array
  *  value      = <exp_?>, any valid data type with which to fill

  SET TALK OFF

  * This is how FoxBASE+ initializes arrays
  &a_name = value

  RETURN ""
********
  PROCEDURE ains
  *
  * #7 in a series of FoxBASE+ 2.1 clones of Clipper
  * functions for manipulating arrays.
  *
  * Date    : 6 May 89
  * Author  : Steve Freides
  * Purpose : To insert a new value at a specified element
  *           within an array, bumping the remaining elements
  *           up one place and losing the last element.
  *
  PARAMETERS a_name, a_len, element_no, replace_val
  *
  *  a_name     = <exp_C>, name of the array
  *  a_len      = <exp_N>, length (number of elememts) in array
  *  element_no = <exp_N>, location at which to insert
  *  replace_val= <exp_?>, any valid data type for the new element

  SET TALK OFF

  DO WHILE (a_len >= element_no)
    * Trash last element, insert new one at element_no
    IF a_len > element_no
      &a_name(a_len) = &a_name(a_len-1)
    ELSE
      &a_name(element_no) = replace_val
    ENDIF
    a_len = a_len - 1
  ENDDO

  RETURN ""
********
PROCEDURE ascan
  *
  * #8 in a series of FoxBASE+ 2.1 clones of Clipper
  * functions for manipulating arrays.
  *
  * Date    : 11 April 89
  * Author  : Steve Freides
  *
  * Purpose : To check all elements of an array
  *           for a specific value.
  *
  * Returns : <exp_N>, the number of the matching 
  *           element within the array.
  *
  PARAMETERS a_name, a_len, search_val, checktype
  *
  *  a_name     = <exp_C>, name of the array
  *  a_len      = <exp_N>, length (number of elememts) in array
  *  search_val = Any valid data type representing value sought.
  *  checktype  = <exp_L>. If .F., ascan() assumes all array
  *               elements AND search_val to be of the same
  *               data-type.  IF .T., ascan() will check data-types
  *               before making comparisons, allowing arrays containing
  *               more than one data-type.  Second way is slower.
  *
  SET TALK OFF
  PRIVATE num, Error
  num      = 1 
  Error    = 0

  IF ! checktype
    * If all one type, this is all we need - it's FASTER!
    DO WHILE (num <= a_len) .AND. (&a_name(num) <> search_val)
      num = num + 1
    ENDDO
    RETURN IIF(num <= a_len, num, Error)
  ENDIF

  * ELSE: We're here, so we're checking data types
  PRIVATE ascanvar
  ascanvar = ""

  DO WHILE num <= a_len
    DO WHILE (TYPE('&a_name(num)') <> TYPE('search_val')) .AND. (num <= a_len)
      num = num + 1
    ENDDO
     
    IF ! (num <= a_len)
      EXIT
    ENDIF

    IF TYPE('search_val') = "L"    && Logical type
      ascanvar = &a_name(num)    && Save a few macro expansions
      * For either type of logical mis-match, increment and try again
      IF (search_val .AND. !ascanvar) .OR. (!search_val .AND. ascanvar)
        num = num + 1
      ELSE
        EXIT
      ENDIF
    ELSE      && Character-, Numeric-, or Date-type
      * Now we've got matching types, so compare
      IF (&a_name(num) <> search_val)
        num = num + 1
      ELSE
        EXIT
      ENDIF
    ENDIF
  ENDDO
        
  RETURN IIF(num <= a_len, num, Error)
********
PROCEDURE asort
  *
  * #9 in a series of FoxBASE+ 2.1 clones of Clipper
  * functions for manipulating arrays.
	*
  * Date   : 4 July 90
  * Author : Tamar E. Granor, modified by Steve Freides
  *
  * Purpose: To sort the contents of an array.
  *          All elements must be of the same data type.
	*
	* Returns: ""
	*
  * Notes  : Thanks to Tamar, the collection of Clipper work-arounds
  *          is now complete.  Her article containing this code appeared
  *          in FoxTalk, June, 1990.  I've modified it to work with
  *          FoxBASE+ as well as FoxPro, and to follow the conventions
  *          of the other UDF's in the set.
  *          
  *          All of the individual procedure calls have been hard-coded
  *          into this module to ease procedure file hassles for FB+ users.
  *
  *          Tamar's code was more modular, but this could cause problems
  *          for FB+ users.  Many of the commented-out "DO" lines are
  *          her original procedure calls that have been replaced here
  *          by 'in-line' code.
  *
  PARAMETERS a_name, a_len
  *
  *  a_name     = <exp_C>, name of the array
  *  a_len      = <exp_N>, length (number of elememts) in array
  *
  PRIVATE startpos,curconvpos,curupdtpos,hold,workpos,workchild
  * startpos   = position to start conversion
  * curconvpos = position currently being converted
  * curupdtpos = position currently being updated
  * hold       = value for swapping
  * workpos    = used by shuffling code
  * workchild  = used by shuffling code
  
  PRIVATE sortscreen
  SAVE SCREEN TO sortscreen
  SET COLO TO W+*
  @24,0
  @24,0 SAY SPACE(35)+"Sorting..."
  SET COLO TO W+
  
  startpos = INT(a_len/2)
  curconvpos = startpos
  curupdtpos = a_len

  @24,77-LEN(LTRIM(STR(a_len))) SAY " / " + LTRIM(STR(a_len))

  * DO toheap WITH size
  DO WHILE curconvpos >= 1
    @24,72-LEN(LTRIM(STR(a_len))) SAY TRAN(curconvpos,"9,999")
    * DO shuffle WITH curconvpos,a_len
    hold = &a_name(curconvpos)
    workpos = curconvpos

    workchild = 2*workpos
    DO WHILE workchild <= a_len
      IF (workchild < a_len) .AND. (&a_name(workchild+1) > &a_name(workchild))
        * pick larger of children
        workchild = workchild + 1
      ENDIF

      * compare to value at workchild
      IF hold < &a_name(workchild)
        &a_name(workpos) = &a_name(workchild)
        workpos = workchild
        workchild = 2 * workpos
      ELSE
        * get out of loop
        EXIT
      ENDIF
    ENDDO

    &a_name(workpos) = hold
    * End of Tamar's 'shuffle' procedure

    curconvpos = curconvpos - 1
  ENDDO
  * End of Tamar's 'toheap' procedure

  * DO sortheap WITH size
  DO WHILE curupdtpos >= 2
    @24,72-LEN(LTRIM(STR(a_len))) SAY TRAN(curupdtpos,"9,999")
    hold = &a_name(1)
    &a_name(1) = &a_name(curupdtpos)
    &a_name(curupdtpos) = hold
    IF curupdtpos > 1
      curupdtpos = curupdtpos -1

      * DO shuffle WITH 1,curupdtpos
		  hold = &a_name(1)
		  workpos = 1
		  
		  workchild = 2*workpos
		  DO WHILE workchild <= curupdtpos
		    IF (workchild < curupdtpos) .AND. (&a_name(workchild+1) > &a_name(workchild))
    		  * pick larger of children
		      workchild = workchild + 1
		    ENDIF

		    * compare to value at workchild
		    IF hold < &a_name(workchild)
    		  &a_name(workpos) = &a_name(workchild)
		      workpos = workchild
    		  workchild = 2 * workpos
		    ELSE
    		  * get out of loop
		      EXIT
    		ENDIF
		  ENDDO

		  &a_name(workpos) = hold
  	  * End of Tamar's 'shuffle' procedure

    ENDIF
  ENDDO
  * End of Tamar's 'sortheap' procedure

  SET COLO TO &sys_colo

  RESTORE SCREEN FROM sortscreen  
  RETURN ""
********
PROCEDURE demo1
  *
  *  Shows adir(), achoice() and, optionally, asort().
  *  The display can be sorted by un-commenting the
  *  line:
  * 
  *    ??asort("test",memvar)
  *
  *  It just takes longer to run that way.
  *  As with all of these, if you use them, I strongly
  *  suggest replacing the macro with a hard-coded variable name.
  *
  PRIVATE row, col, skeleton, memvar
  row = 10
  col = 15

  DO WHILE .T.
    skeleton = "*.*" + SPACE(251)
    memvar = 0
    @ row,col CLEAR TO 24,79
    @ 24,32 SAY "<Esc> to Exit"
    @ row,col TO row+11, col+49 DOUBLE
    @ row+2, col+2 SAY "Enter a directory skeleton in the blank below."
    @ row+3, col+2 SAY "Possibilities include:"
    @ row+5, col+2 SAY "    *.dbf"
    @ row+6, col+2 SAY "    *.*"
    @ row+7, col+2 SAY "    testfile.dbf"
    @ row+9, col+2 SAY "Your choice:" GET skeleton PICTURE "@S30"

    READ
    IF MOD(READKEY(),256) = 12   && Escape Key
      RETURN
    ENDIF

    ?? SYS(2002)
    @24,0
    SET COLO TO W*
    @24,0 SAY SPACE(33) + "Working..."+SPACE(37)
    SET COLO TO &sys_colo
    skeleton = LTRIM(TRIM(skeleton))
    memvar = adir(skeleton,"test")          && The neat stuff
    @24,0
    ?? SYS(2002,1)
    IF memvar > 0
      IF "FOXBASE" $ UPPER(VERS(1)) .AND. memvar >= 128
        @24,0
        @23,0 SAY ""
        WAIT "FoxBASE cannot accept more than 128 elements at a time.  Press any key..."
        @24,0
        LOOP
      ENDIF

      @24,0
      yn=.F.
      @24,0 SAY SPACE(19)+LTRIM(STR(memvar))+ " files found.  Sort the array (Y/N)?" GET yn PICTURE "Y"

      READ
      @24,0
      IF MOD(READKEY(),256) = 12   && Escape Key
        LOOP
      ENDIF
      IF yn
        ??asort("test",memvar)
      ENDIF
      where = achoice(3,34,"test",memvar,MIN(memvar,20)," "+LTRIM(STR(memvar))+" Files ")
      @24,0
      @23,0 SAY ""
      IF where > 0
        FileToUse = test(where)
        WAIT SPACE(15) + "You have chosen " + FileToUSe + ".  Press any key..."
        * In a real application, this would be: USE &FileToUse, etc...
      ELSE
        WAIT SPACE(7) + "You pressed <Escape> - no file has been selected.  Press any key..."
      ENDIF
      @24,0
    ELSE
      @24,0
      @23,0 SAY ""
      WAIT "      Nothing matches the directory skeleton you gave.  Press any key..."
      @24,0
    ENDIF
  ENDDO    
  RETURN
********        
PROCEDURE demo2
  *
  * Demo for ascan()
  *
  SET CONFIRM    ON
  ??SYS(2002)

  RELEASE test
  DIMENSION test(5)
  test(1) = "abcde"
  test(2) = 317
  test(3) = DATE()
  test(4) = .F.
  test(5) = .T.

  * Make trial vars to run test with
  PRIVATE char, num, date, logical, seek_var, memvar, row
  char    = SPACE(LEN(test(1)))
  num     = 0
  date    = CTOD('  /  /  ')
  logical = .F.
  memvar = 0
  row    = 22

  DO WHILE .T.
    @0,0 CLEAR

    TEXT

        This is a demonstration program for ascan(), a FB+/FP work-
        around to duplicate Clipper's native function of the same name.  

        The array 'test' has been created and initialized as follows:

                        DIMENSION test(5)
                        test(1) = "abcde"  (Character-type)
                        test(2) = 317      (Numeric-type)
                        test(3) = DATE()   (Date-type)
                        test(4) = .F.      (Logical-type)
                        test(5) = .T.      (Logical-type)

        Enter any value you like into ONE of the 'get's below, and 
        ascan() will return the number within the array that matches
        your request, 0 if it is not found.  Just like Clipper.
    
        Only the first non-empty (or non-zero, etc.) value you enter 
        will be searched for in this demo.
    ENDTEXT
    @1,5 TO 21,73 DOUBLE       && Box around Text we just drew
    @row,      7 SAY "CHARACTER:" GET char
    @row,COL()+2 SAY "NUMBER:" GET num
    @row,COL()+2 SAY "DATE:" GET date
    @row,COL()+2 SAY "LOGICAL:" GET logical
    SET COLO TO &get_colo
    @24,32 SAY " <Esc> to exit "
    SET COLO TO &sys_colo
    ??SYS(2002,1)
    CLEAR TYPEAHEAD
    READ
    ??SYS(2002)
    IF MOD(READKEY(),256) = 12  && <Esc>
      EXIT
    ENDIF

    DO CASE
    CASE LEN(TRIM(char)) > 0
      seek_var = char
    CASE num # 0
      seek_var = num
    CASE date # CTOD('  /  /  ')
      seek_var = date
    OTHERWISE
      seek_var = logical
    ENDCASE

    memvar = ascan("test",5,seek_var,.T.)  && Must use type-checking here
    @24,0                                  && because of different data-types
    SET COLO TO W+                         && in demo array.
    @24,0 SAY "Position in array: " + LTRIM(STR(memvar))
    SET COLO TO W+*
    ??IIF(memvar=0," NOT FOUND",SPACE(10))
    SET COLO TO &get_colo
    ?? " <Esc> to exit, any other key to run demo again "
    SET COLO TO &sys_colo
    CLEAR TYPEAHEAD
    key = INKEY(0)
    IF key = 27   && Escape Key
      EXIT
    ENDIF
  ENDDO

  SET CONFIRM    OFF
  ??SYS(2002,1)
  RETURN
********
