/*
  Program: formlett.prg 4/4/91
  Author:  Wayne Byerly  (compuserve id 76557,1052)
           ThomComp, Inc.
           325 Chesnut Street, 10th Floor
           Philadelphia, PA 19106

  An example of how you might possibly implement form letters
  with clipper 5.0 from a stock "form letter" stored in a memo field
  and be able to use printer control characters and fieldname
  substitutions.

  This is NOT an elegant solution. You will note that the formatting of
  the memo field (by substituting symbols in the memo field  with the
  actual printer control codes required by the printer) will include the
  printer control characters, so that when the memo field is printed,
  lines with control codes in them will be shorter than lines that don't
  contain these control codes as a result of having the printer codes
  themselves counted as characters.

  Note that there is only about three hours worth of work represented
  here.
  
  See the memo field "text" in forms.dbf for examples on how field
  data, printer codes and "standard" functions are represented
  
*/

//
// control codes for HP Laser IIID
//
static cBoldOn     := "(s7B"  && bold on
static cBoldOff    := "(s0B"  && bold off
static cItalOn     := "(s1S"  && italics on
static cItalOff    := "(s0S"  && italics off
static cUndrOn     := "&d3D"  && underline on
static cUndrOff    := "&d@"   && underline off
static cSetup      := "&a5L"  && left margin of 5
static cReset      := "E"     && hard reset



function main()
  local cString
  local cForm
  //
  // open the files, store the contents of a memo field in the forms file
  // to a variable, translate the symbols in the character string
  // to the printer control characters above and then print it for each
  // record in the customer file
  //
  use FORMS new
  cForm := FORMS->Text
  use CUST new
  do while ! eof()
    cString := Encode( cForm)
    PrintForm( cString)
    skip
  enddo
return
//
// end main


static function Encode( cStringIn)
  local nBegPosition := 0
  local nEndPOsition := 0
  local cResult      := cStringIn
  //
  // translate printer control symbols to printer control characters
  // strtran function shows how printer control symbols are formatted
  //
  cResult := strtran( cResult, "~~B", cBoldOn)  && bold print
  cResult := strtran( cResult, "~~b", cBoldOff)
  cResult := strtran( cResult, "~~I", cItalOn)  && italics
  cResult := strtran( cResult, "~~i", cItalOff)
  cResult := strtran( cResult, "~~U", cUndrOn ) && underline
  cResult := strtran( cResult, "~~u", cUndrOff)
  //
  // translate soft carriage returns to hard carriage returns
  //
  cResult := hardcr( cResult)
  //
  // translate standard functions (only date right now)
  // 04/04/91 would translate to - "Thursday 4 April 1991"
  cResult := strtran( cResult, "..date..", ;
  cdow(date())+ ", "+ ;
  ltrim(str(day(date())))+ " "+ ;
  cmonth(date())+ " "+ ;
  ltrim(str(year(date()))) ;
  )
  //
  // translate field symbols to field contents
  //
  do while .t.
    nBegPosition := at( "//", cResult)
    if nBegPosition == 0     && no more field symbols to translate
      exit
    endif
    //
    // build field name and object to search for.
    //
    nEndPosition := at( "\\", cResult)
    cFieldName   := ;
    substr( cResult, nBegPosition+ 2, (nEndPosition- nBegPosition- 2))
    cObject      := ;
    substr( cResult, nBegPosition, (nEndPosition- nBegPosition+ 2))
    //
    // determine the field type and translate field symbols as is
    // appropriate for numeric, character and date fields. ignore if
    // logical or memo.
    //
    cFieldType   := valtype(&( cFieldName))
    do case
    case (cFieldType == "N")
      cResult    := strtran( cResult, cObject, alltrim(str(&( cFieldName))))
    case (cFieldType == "C")
      cResult    := strtran( cResult, cObject, trim(&( cFieldName)))
    case (cFieldType == "D")
      cResult    := strtran( cResult, cObject, trim(dtoc(&( cFieldName))))
    case cFieldType == "L" .or. cFieldType == "M"  && do nothing
    endcase
  enddo
return cResult
//
// end encode



static function PrintForm( cStringIn)
  //
  // setup printer with setup string
  //
  SetPrinter( cSetup)
  set console off
  set print on
  ?? cStringIn
  set print off
  set console on
  eject
  //
  // reset the printer
  SetPrinter( cReset)
  //
return nil
//
// end printform



static function SetPrinter( cControlCode)
  set console off
  set print on
  ?? cControlCode
  set print off
  set console on
return nil
//
// eof test.prg
