* Program: Form.prg
* Author:  Timothy Wong
* Version: Clipper Summer '87
* Note(s): This procedure enables a user to copy a database
*          into a data file in ASCII format delimited by
*          any character.
*
*          Syntax: FormCopy(<expC1>,<array1>,<expC2>)
*          where: <expC1> is the name of the ASCII file
*                 <array1> is the array of field names
*                 <expC2> is the delimiter to seperate fields
*
* Copyright (c) 1989 Nantucket Corp.  All Rights Reserved.

* Function: FormCopy()
FUNCTION FormCopy
PARAMETERS FileName, FldArr, DLim
CrLf = CHR(13) + CHR(10)          && Carriage return/line feed.
NumFlds = LEN(FldArr)             && Get number of fields.
handle = FCREATE("&FileName.")    && Open the ASCII file.
IF FERROR <> 0
   RetVal = .F.
ELSE
   DO CASE
      CASE NumFlds = 1            && Special case of 1 field.
         DO WHILE !EOF()
            MemVar = SPACE(0)     && Initialize dummy variables.
            MemVar2 = SPACE(0)
            MemVar2 = FldArr[1]
            * Convert the field to character type.
            MemVar = ConvertType(MemVar2) + CrLf
            * Write it out to disk.
            FWRITE(handle, MemVar, LEN(MemVar))
            SKIP                  && Next record.
         ENDDO
      OTHERWISE
         DO WHILE !EOF()          && For multiple fields.
            MemVar = SPACE(0)
            MemVar2 = SPACE(0)
            FOR I = 1 TO (NumFlds-1)  && Go through each field.
               MemVar2 = FldArr[I]
               * Build string and tag in delimiter.
               MemVar = MemVar + ConvertType(MemVar2) + DLim
            NEXT
            MemVar2 = FldArr[NumFlds]
            MemVar = MemVar + ConvertType(MemVar2) + CrLf
            FWRITE(handle, MemVar, LEN(MemVar))
            SKIP
         ENDDO
   ENDCASE
   FCLOSE(handle)
   RetVal = .T.
ENDIF
RETURN RetVal

* Function: ConvertType()
* Converts any memory variable to a character type.
* Converts logicals to "True" and "False."
* Syntax: OutStr = ConvertType(<anyType>)
*         where <anyType> can be a memory variable of any type.
*
FUNCTION ConvertType
PARAMETERS InField
PRIVATE mType, RetVal, Temp
Temp = &InField.           && Get value of InField.
mType = TYPE("Temp")       && Get the type.
DO CASE
   CASE mType = "C"        && Do not do anything if character.
      RetVal = Temp
   CASE mType = "N"        && Numeric type.
      RetVal = LTRIM(STR(Temp))
   CASE mType = "L"        && Logical type.
      IF Temp
         RetVal = "TRUE"
      ELSE
         RetVal = "FALSE"
      ENDIF
   CASE mType = "D"        && Date type.
      RetVal = DTOS(Temp)
   OTHERWISE               && Unknown type.
      RetVal = ""
ENDCASE
RETURN RetVal
