*******************************************************************************
*
*  Function:  Test.PRG
*  Author:    Dave Peckam
*
*  Date:      February 12, 1988
*  Version:   1.0
*
*  Purpose:   Demonstrate use of FloppyTst()
*
*******************************************************************************

clear

Drive = "A"

do while upper(Drive) <> "Z"

  @ 1,1 say "Which drive should I test ?  A or B  (Z to quit)"
  @ 3,1 get Drive
  read
  @ 5,1 say space(80)

  DriveStatus = FloppyTst(Drive)
    
  do case
    case DriveStatus = 0
      @ 5,1 say "Drive and diskette are ready"
    case DriveStatus = 1
      @ 5,1 say "Drive door open or diskette inserted upside-down"
    case DriveStatus = 2
      @ 5,1 say "Diskette is unformatted"
    case DriveStatus = 3
      @ 5,1 say "Diskette has a write protect tab installed"
    case DriveStatus = 4
      @ 5,1 say "Diskette is of incorrect media type"
    case DriveStatus = 8
      @ 5,1 say "Diskette has been damaged or has not been formatted"
    case DriveStatus = 15
      @ 5,1 say "Please enter a valid drive specifier"
    otherwise
      @ 5,1 say "Diskette/Drive not ready, but problem cannot be determined"
  endcase    
  @ 6,1 say "DOS Critical Error Code: " + str(DriveStatus,4)
  
enddo

clear