****************************************************************************
* Program..: FUNCLIST.prg  -  THE FUNCTION LISTER!
* Author...: Paul H. Mannes
* Date.....: January 19,1988, January 20, 1988
* Notice...: copyright (c) 1988, by dConsultant Systems, all rights reserved
* Contact: Phone: (703) 620-6615
* Address: 10858 Parcel Ct.
*          Oakton,  VA  22124
* Load File produced: FLIST.EXE
* Shareware - if you like it - Send $25.00 to dConsultant Systems at the
* above address.  Thanks. (Make shareware work for all of us.)
****************************************************************************
* Revision History: Code started on Jan 19 as a way to become familiar
* with some of the new features of the Summer 1987 release of Clipper.
* Jan 29, 1988
* First revision: Added stored lines in a temp.dbf for view on screen.
* Version history maintained by PVCS (Polytron: Personal)
* $Header:   D:/clutils/funclist.prv   1.0   02 Feb 1988  0:23:20  $
* Purpose Statement: Program was written to allow presentation, on screen
* or in a printed form, of all FUNCTIONs within a program's source code.
* FUNCTIONs, for the present purpose, are here defined as any word
* which is immediately followed by a '()', with or without arguments.
* A space between the word and the parenthesis is acceptable though it may
* turn out not to be a function at all. (example: x = (x + y) / 2 )
* The result of the presentation is usefulness:
*        1. to simply (and quickly) determine the functions used in an
*           application
*        2. thru Function Identification, determine necessary .OBJ or
*           .LIB files to include at link time.
*        3. to catch slips in incomplete code sequences
*           (example: Let's say you use The Breeze as a window function
*                     library - and it is a good one at that -.  You have
*                      WSELECTEd and WUSEd a window.   Somewhere down the
*                      line you will need to enter a WCLOSE and/or a
*                      WRELEASE function.  The FUNCLIST presentation will
*                      clearly show you if something is missing. (Though it
*                      makes no judgements about what must follow what.)
*
* Syntax: The following message appear when the program is called and as a
* part of the Help screen.  It clearly shows the possible callup methods.
*
*   Syntax Options:  1) FLIST < nothing else >   | *.prg loaded
*                    2) FLIST < filename/no ext> | assumes .prg
*                    3) FLIST < wildcard > | ex: GL_*
*                    4) FLIST < file1 file2 file3 ...file6>
*        FLIST does not search other directories for files though
*         it can be called from any directory on the path line.
***************************************************************************
* System Configuration Remarks:
* When dealing with utilities which call source code files for Analysis,
* certain limitations are inherent.  The primary limitation is memory
* available.  The current version of FUNCLIST requires 256k of your memory.
* The new Clipper will handle files up to 64k, and so will FLIST.
* With a long preserved emphasis on modularity in programming, it is hoped
* that any and all of your code files are much shorter than that, and
* therefore, within the handling ability of FUNCLIST.
***************************************************************************
* Production notes:
* Editor: Brief 2.0 (with dBrief and QFlight)
* Compiler: Clipper Summer '87
* Linker: TLink (1.2)
* Libraries: Clipper.LIB (summer '87)
*            Extend.LIB (summer '87)
* UDF's: various, included in FLIST.prg at end to keep .OBJ header
* information to a minimum during linking.
* Code length w/o comments: 747 lines
* Exe size: 186804
**************************************************************************
* Source Code: with comments
* && NEW COMMAND will follow any command/function which is new to S'87
* parameter line allows up to 6 files to be entered at one time.
* though a file skeleton using the wildcards (? or *) is also permitted.
* You can see the Syntax commands above for more information.
**************************************************************************
para do_file1,do_file2,do_file3,do_file4,do_file5,do_file6

* set up environment

set scoreboard off
set cursor off        && NEW COMMAND
set safety off
clear

* variables

public do_files       && will become main Array for files to be processed
do_files = ""
nosize = ""           && null for the size variable returned by ADIR()
morefiles = .t.       && for use in major loop - you'll see
subquit = .f.         && use for quiting from withing nested DO.. WHILEs

* simple block to allow Color or Mono displays

if iscolor()
   normal = "gr/n,+gr/n,n"
   reverse= "n+/gr+,+gr/n,n"
   bright = "gr+/n,+gr/n,n"
else
   normal = "w/n,+w/n,n"
   reverse= "n/w,+w/n,n"
   bright = "w+/n,+w/n,n"
endi

* how about an informational status line a la A-T, @ line 23

setcolor(reverse)     && NEW COMMAND
status_line = space(10)+chr(186)+space(27)+chr(186)+space(27)+chr(186)+space(12)
@ 23,0 say status_line

* UDF called statline() for updating status line
*    also staterr(), and statmsg()

statline(2,"dConsultant Systems")   && 2 = status line location
statline(3,"Copyright (c) 1988")
statline(1,"LOADING")
setcolor(normal)

@ 14,7,21,71 box boxstring(1)     && boxstring() is from REFCLIP()

@ 15,9 say "Syntax Options:  1) FLIST < nothing else >   | *.prg loaded "
@ 16,9 say "                 2) FLIST < filename/no ext> | assumes .prg "
@ 17,9 say "                 3) FLIST < wildcard > | ex: GL_*           "
@ 18,9 say "                 4) FLIST < file1 file2 file3 ...file6>     "
@ 19,9 say "     FLIST does not search other directories for files though "
@ 20,9 say "      it can be called from any directory on the path line.  "

statmsg("Press F1 for Help")     && statmsg appears on line 24 and stays.

* Now we need to parse out parameters passed, to an array if more than one.

if pcount() > 1
   *       do_files is for names
   *       f_dates is for the DOS date stamp
   
   declare do_files[pcount()],f_dates[pcount()]
   
   declare dum_f[1],dum_d[1]  && to ensure that each file in the parameter
   *                             list exists, I load them one at a time and
   *                             do a simple ADIR() check.
   
   for x = 1 to pcount()
      
      * next sequence checks for the .prg extension and the files existence
      * before loading it into the do_files[].
      
      get_file = "do_file"+lstr(x)

      if at(".",&get_file) = 0
        
         * .prg was not included  - a few simple lines here can save you
         * a lot of keystrokes from DOS.  A small price.
         
         got_it = adir(&get_file+".prg",dum_f,nosize,dum_d)  && count and load

      else
         
         * .prg was included - someone likes to type.
         
         got_it = adir(&get_file,dum_f,nosize,dum_d)   && not NEW but Enhanced

      endi
      
      * evaluate the result of ADIR()
      
      if got_it = 1
          
         acopy(dum_f,do_files,1,1,x)    && NEW COMMAND
         acopy(dum_d,f_dates,1,1,x)     && copy from dummy to work ARRAY
         
         adel(dum_f,1)                  && NEW COMMAND, get rid of dummies
         adel(dum_d,1)

      else
         do_files[x] = "NOFIND"
      endi

      * get the next parameter or continue processing
   next
   
   nofind = ascan(do_files,"NOFIND")        && check to see if all parameters were
   if nofind > 0

      cnt_nofind = 0
      for x = 1 to pcount()

         cnt_nofind = if(do_Files[x] = "NOFIND",cnt_nofind + 1,cnt_nofind + 0)

      next

      if cnt_nofind < pcount()

         staterr("Not all files were found. ")

         delarray = 0
         x = 1
         do while delarray <= cnt_nofind

             if do_files[x] = "NOFIND"
                delarray = incr(delarray)
                adel(do_files,x)
                adel(f_dates,x)
             else
                x = incr(x)
             endi

          endd

      elseif cnt_nofind = pcount()

         staterr("No file listed was found. ")
         do_file1 = ""

      endi

   endi
   
   * so concluded the loading of up to 6 files from DOS
   
elseif pcount() = 1      && NEW COMMAND   with a condition arg.
    
   * determine if the pcount() is 1 and we need to request file(s) name(s),
   * or if the parameter passed is a true file name.
  
   * Code section here is for loading arrays with files from directory
   * indicated which have *.prg extension
   
   * first we set up arrays with proper lengths
   
   if at(".",do_file1) = 0
      
      * once again, check for exclusion of extension . . .
      do_file1 = do_file1+".PRG"

   endi
      
   declare do_files[adir(do_file1)],f_dates[adir(do_file1)]
   got_it = adir(do_file1,do_files,nosize,f_dates)   && load file names into array
   
   if got_it = 0    && check this way too!
      
      staterr("No file(s) found matching description. ")
      do_file1 = ""
      
   endi
    
endi

inkey(2)   && brief wait for "Press F1 for Help"  message

* if no files were found in either entry method above allow a third.
* This will allow a single file to be processed at a time from a listing
* available with the NEW COMMAND - ACHOICE() - a real beaut!

do while morefiles    && maybe forever!

   morefiles = .f.
   
   * morefiles is .t. coming into the loop the first time.  It is
   * immediately set to .f.. If either of the first two parameters
   * conditions are true it is set back to .t. to allow multilple
   * presentations.  This allows a repetitious processing of files
   * from the list.
   
   if (len(do_files) = 0 .or. pcount() = 0) .or. morefiles
      
      morefiles = .t.
            
      * Give operator the ability to enter a single file manually or choose from
      * a 'pop-up' list of *.prg files from the current directory.
      * Pop-up list will respond to press the F3 key.
      
      declare do_files[1],f_dates[1]
      do_file1 = space(8)                 && variable for manual entry.
      set key -2 to prglist               && 'pop-up' *.prg list
      
      set cursor on             && NEW COMMAND
      
      statline(1,"WAITING")
      statmsg("Waiting for a single filename to be entered. . .(F3 for Dir. List)")
      
      * User entry line with VALID UDF to check for entered files existence
      
      @ 22,1 say "Enter a .PRG file name (no ext.)...." get do_file1 ;
      valid isfile(lastkey(),do_file1)         && see below for UDF
      read
      @ 24,0
      set cursor off        && NEW COMMAND
      set key -2 to         && shut off hot key to Directory listing
      
      * if still no file entered or user presses the ESC key
      
      if empty(do_file1) .or. lastkey() = 27
         @ 22,0
         exit
      endi

      * otherwise load do_file1 to the array for processing

      if at("*",do_file1) > 0
         staterr("No DOS skeleton from here. ")
         do_file1 = space(8)    
         loop
      endi

      do_file1 = uppe(trim(do_file1))+".PRG"    && add extension
      adir(do_file1,do_files,nosize,f_dates)
      
   endi
   setcolor(normal)
   
   scroll(14,0,22,72,0)    && Enhanced from DBU days - used for clearing
   *                          section of screen.
   
   * The next section is preparation and presentation of two processing
   * directives.  1:  Direction for presentation
   *                   - Screen    - Printer
   *              2:  Uninterrupted presentation or pause between each
   *                  file for re-evaluation of direction or to repeat
   *                  the previous presentation to the device, etc.
   
   * Opertion are loaded to two arrays.

   declare prc_cmds[2]
   prc_cmds[1] = "All without interruption.             "
   prc_cmds[2] = "One at a time / pause for new command."

   declare out_cmds[2]
   out_cmds[1] = "Screen Presentation       "
   out_cmds[2] = "Printer Output            "
   
   * if there is only one file - no Interrupt/Uninterrupt option is given.
   
   if len(do_files) > 1
      statmsg("Do all files without changing output options, or stop at each?")
      setcolor(reverse)
      @ 1,1,4,55 box boxstring(4)
      @ 1,2 say "[ Process: ]"
      @ 4,2 say "[ , ,RET ,ESC ]"
      do_p_cmd = achoice(2,3,3,50,prc_cmds)  && NEW COMMAND
      setcolor(normal)
      @ 1,1 clear to 4,55
      if do_p_cmd = 0        && exit from each option window with no
         *                      selection made.
         setcolor(normal)
         exit

      elseif do_p_cmd = 1    && Process w/o interruption

         statline(2,"NON STOP OUTPUT")   && message about action taken.

      elseif do_p_cmd = 2    && Process and pause between each file

         statline(2,"PAUSE AFTER EACH FILE")
         declare steps[6]                 && load array for menu of options
         *                                 if interruption is allowed.
         
         steps[1] = "Continue with next file.     "
         steps[2] = "Repeat last file to printer. "
         steps[3] = "Repeat last file to screen.  "
         steps[4] = "Skip over next file.         "
         steps[5] = "Change output direction.     "
         steps[6] = "Cancel Pause after each file."

      endi

   else

      do_p_cmd = 1    && default for only one file to process

   endi
   
   * next menu of options
   
   statmsg("Send the Function list to the Screen or the Printer?")
   setcolor(reverse)
   @ 1,1,4,35 box boxstring(4)
   @ 1,2 say "[ OutPut Direction: ]"
   @ 4,2 say "[ , ,RET ,ESC ]"
   do_o_cmd = achoice(2,3,3,32,out_cmds)
   setcolor(normal)
   @ 24,0
   @ 1,1 clear to 4,35

   if do_o_cmd = 0        && ESC to exit option

      setcolor(normal)
      exit

   elseif do_o_cmd = 1    && Screen output

      statline(3,"OUTPUT TO SCREEN")

   elseif do_o_cmd = 2    && Printer output

      statline(3,"OUTPUT TO PRINTER")

   endi

   statline(1,"PROCESS")
   
   * here is the first step in the main processing of the load file(s).
   * The f_num is the increment counter for multiple files.
   
   f_num = 1
   do while f_num <= len(do_files)

      if empty(do_files[f_num]) .or. do_Files[f_num] = "NOFIND"    && test for empty array element
         f_num = incr(f_num)
         loop
      endi

      * First we get the file name and date stamp as loaded into the Array
      
      get_prg = trim(do_files[f_num])
      get_date = f_dates[f_num]
      
      wn1 = savescreen(10,20,14,60)    && NEW COMMAND  saves memory by
      *                                not needing to save the entire screen
      * next section is a message window to tell the user what is happening

      setcolor(reverse)
      @ 10,20,14,60 box boxstring(4)
      setcolor("*"+reverse)
      @ 12,30 say "Loading "+get_prg      && flashing message on screen
      setcolor(normal)
      
      * display current file information to screen areas.
      
      statline(2,"Dated: "+dtoc(get_date))
      statline(4,get_prg)
      
      * Next, we load the source code file to a memory variable using
      * the MEMO functions.
       
      load_file = memoread(get_prg)
      load_file = memotran(load_file)    && the search process works
      *                                      better without chr(13),chr(10)
      *                                      chr(141), etc.
       
      * for readiblity and modularity, the entire search for '()' function
      * identifiers in the code has been made into a Function.
      * parameters are, 1. the name of the file (by reference). 2. and the
      * direction it is to go - do_output_command = 1 for screen, 2 for print
      * the variable returned termins how the processing went.
      *    If all went well:   prc_ret  =  0
      *    If printer failure: prc_ret  =  1
      *    If no function:     prc_ret  =  2

      prc_ret = dfuncs(if(do_o_cmd = 2,.t.,.f.))
      
      * when one file is finished.  check for another and start again.

      if prc_ret = 1

         do_o_cmd = 1   && change presentation to screen

      endi

      if do_o_cmd = 2 .and. f_num = len(do_files)
         
         * direction related message
         
         @ 22,rcenter("Printout is Completed.") say "Printout is Completed."

      endi
      
      * no more files to process
      
      if f_num = len(do_files)

         exit

      else
         
         f_num = incr(f_num)

      endi
      
      * if there are more files and the user has asked to interrupt -
      * the menu created by the array STEPS[] does the trick.
      
      if do_p_cmd = 2
         
         wn2 = savescreen(1,1,9,36)         && once again - a powerful
         next_cmd = 4
         do while next_cmd = 4
            setcolor(reverse)                   && block of code.
            @ 1,1,8,36 box boxstring(4)
            @ 1,2 say "[ Optons: ]"
            @ 8,2 say "[ , ,RET ,ESC ]"
            @ 9,1 say space(36)
            @ 9,1 say "Next File: "+do_files[f_num]
            next_cmd = achoice(2,3,7,35,steps)
            setcolor(normal)
            
            do case
               case next_cmd = 0      && allows complete exit on interrupt
               
                  subquit = .t.
                  exit
            
               case next_cmd = 2  && Reprocess previous file to the printer

                  f_num = decr(f_num)
                  do_o_cmd = 2
      
               case next_cmd = 3      && Reprocess previous file to the screen
            
                  f_num = decr(f_num)
                  do_o_cmd = 1
               
               case next_cmd = 4      && continue with next file
         
                  if f_num + 1 < len(do_files)

                     f_num = incr(f_num)
                     
                  else
   
                     staterr("No more files to process. ")

                  endi

               case next_cmd = 5      && Change presentation mode

                  do_o_cmd = if(do_o_cmd = 1,2,1)
         
               case next_cmd = 6      && continue processing w/o interruption

                  do_p_cmd = 1

            endc

         endd

         restscreen(1,1,9,36,wn2)     && NEW COMMAND

         if subquit
            exit
         endi

      endi
          
   endd

   if subquit
     
      exit

   endi
   @ 22,0
endd

* when exiting - clean up nicely - but leave some PR!
@ 22,0
statline(2,"dConsultant Systems")
statline(3,"Copyright (c) 1988")
statline(1,"FINISHED")
statmsg("Thanks for using the FUNCTION LISTER!")
x = 24
do while x > 2          && this loop nicely moves things out of the
   scroll(0,0,x,79,1)   && users way.
   x = decr(x)          && I created this as the opposite to INCR()
endd
setcolor(normal)
set cursor on
release all
@ 3,0 clear
quit
************* End of main code section.
        
*** Procedure Code ***
proc prglist      && pop-up list of files.
   set key -2 to
   setcolor(normal)
   scroll(14,0,22,78,0)
   statline(1,"FUNC LIST")
   wn2 = savescreen(1,0,21,79)
   setcolor(reverse)
    
   * much of this should be clear by now.  The next line is very
   * powerful.  It is the REF(CLIP) (vol 2, no. 2) function for
   * using the ACHOICE() function.  I have modified it just a bit.
   
   do_file1 = getafile("prg",1,60,12,3)   && GETAFILE is from REFCLIP()
   setcolor(normal)
   restscreen(1,0,21,79,wn2)
   @ 24,0
   set key -2 to prg_list

   if .not. empty(do_file1)

      keyboard chr(13)         && used to move passed READ for user input
      *                           if file has been retreaved.
   endi

return

*** UDFs ***

func dfuncs
   para toprint

   mrow = 1
   setcolor(reverse)
   @ 1,0 say " Function Names: "+space(62)
   @ 1,55 say "File Date: "+dtoc(get_date)
   setcolor(normal)

   * first block is for presentation of FUNCLIST to the printer.

   if toprint

      do while .not. isprinter()    && simple and sweet control.

         staterr("Printer is not ON/ON-Line. ")

      endd

      if lastkey() = 27    && user decides to exit

         return(1)

      endi
      setcolor(reverse)
      mrow = 3
      setcolor("*"+reverse)
      @ 12,30 say "Printing "+get_prg
      setcolor(normal)
      statmsg("Press ESC to Interrupt Printing ....")
      set device to print
      mtoc = "-= THE FUNCTION LISTER! =-"
      @ mrow,rcenter(mtoc) say mtoc
      mrow = mrow + 2
      @ mrow,0 say " Function Names: (2 across listing) for "+get_prg+"  ("+dtoc(get_date)+")"
      @ mrow+1,0 say repl("-",70)
      mrow = mrow + 1
   else                            && presentation to the screen
      declare showline[60]
      restscreen(10,20,14,60,wn1)
      setcolor(reverse)
      * create a temporary dbf for lines from which functions on
      * screen have come.
      if .not. file("cy_843x.dbf")
         create cy_843x
         appe blank
         replace FIELD_NAME with "LINENUM"
         replace FIELD_TYPE with "N"
         replace FIELD_LEN with 7
         replace FIELD_DEC with 0
         appe blank
         replace FIELD_NAME with "LINETXT"
         replace FIELD_TYPE with "C"
         replace FIELD_LEN with 200
         replace FIELD_DEC with 0
         use
      endi
      if .not. file("txt_temp.dbf")
         create txt_temp from cy_843x
      endi
      use txt_temp
      erase cy_843x.dbf
      zap
   endi
   setcolor(bright)
      
   * various needed variables
      
   mcol = 0
   mrow = incr(mrow)
   mexit = .f.
   subexit = .f.
   p_interupt = 0
   got2 = 0
   fc_line = ""
   mpage = 1
   line_num = 1
   bol = 1
   eol = 1
   * here is where the Analysis for FUNCTIONS takes place.
      
   do while len(load_file) > 0
      eol = at(";",load_file)
   
      if eol >= len(load_file) .or. eol = 0
         exit
      endi
   
      ex_line = subs(load_file,1,eol -1)   && first line
      load_file = subs(load_file,eol + 1)
      paren1 = at("(",ex_line)              && find first location of a '('
   
      if .not. toprint
         statline(2,"Line:"+lstr(line_num))
      endi
   
      if paren1 = 0                         && if none in line - get next line
         line_num = incr(line_num)
         loop
      else
   
         if .not. toprint
            appe blank
            replace LINETXT with ex_line   && load line in an record
            replace LINENUM with line_num
            *                               for later viewing
         endi
         do while at("(",ex_line) > 0        && to find multiple func in a line
   
            paren1 = at("(",ex_line)      && find first location of a '('
            begin_func = paren1 - 1    && otherwise. . . begin
                  
            * looking at the previous characters to find the Function name.
            * The parsing is a backwards walk - until one of several control
            * characters is found.
                  
            character = subs(ex_line,begin_func,1)
                  
            * control characters listing
            * checking for any of the follwoing  ! / \ . = " ( + - ) , ' ] [ or tab
            * if you can think of anything else, let me know.
                            
            do while .not. character$[!\/ .="(+-),']+"]["+chr(9) .and. begin_func > 0
               begin_func = decr(begin_func)
               character = subs(ex_line,begin_func,1)
            endd
                  
            * isolate the functions name with a substr()
                  
            fc_name = subs(ex_line,begin_func+1,((paren1 - 1)-begin_func))
                  
            * anamoly test to make sure that no leftover ( is there.
               
            if subs(fc_name,len(trim(fc_name)),1) = "("
               fc_name = subs(trim(fc_name),1,len(trim(fc_name))-1)
            endi
                  
            * add a clean () to the end of the word.
                  
            fc_arg  = "()"
            fc_data = trans(line_num,"9,999")+": "+fc_name + fc_arg
                 
            * shorten text to search for next function.
                  
            ex_line = subs(ex_line,paren1+1)
                  
            * if the ( was not really for a function.. . .
                 
            if empty(fc_name)
               fc_data = ""
               loop
            endi
            if toprint
                 
               * Printer interupt checker
               p_interupt = inkey()
               if p_interupt = 27
                  p_interupt = ppause()
                  if p_interupt = 27
                     subexit = .t.
                     exit
                  else
                     set device to print
                  endi
               endi
               * Presentation on paper is two columns
                 
               fc_line = fc_line + fc_data + space(25-len(fc_data))
               got2 = incr(got2)
               if got2 = 2      && Print the two and reset variables for next two.
        
                  @ mrow,2 say trim(fc_line)
                  fc_line = ""
                  fc_data = ""
                  fc_name = ""
                  got2 = 0
                  mrow = incr(mrow)
               else
                  loop
               endi
            else
                     
               @ mrow,mcol say fc_data    && screen presentation
               mrow = incr(mrow)
               scr_stop = inkey()
               if scr_stop = 27
                  mrow = 21
                  mcol = 50
               endi
   
            endi
   
            * how many times have you written the next block -
            * part for the printer - change of page routine
            * and part for the screen presentation
               
            if .not. toprint .and. mrow = 21
               mrow = 2
               if mcol = 50
                  do while .t.
                     subexit = .f.
                     statmsg("ESC - Exit. (V)iew - code line. Any key to continue.")
                     see = 0
                     do while see = 0
                        see = inkey()
                     endd
                     @ 24,0
                     do case
                        case see = 27
                           subexit = .t.
                           exit
                        case uppe(chr(see)) = "V"
                           seeline = 0
                           set cursor on
                           @ 24,0
                           @ 24,10 say "Enter the line number next to the function: " get seeline ;
                           pict "999999"
                           read
                           set cursor off
                           if seeline > 0
                              go top
                              locate for LINENUM = seeline
                              if eof()
                                 staterr("Line Number not on display . . .")
                              else
                                 line_show = alltrim(LINETXT)
                                 *                                    line of text containing the
                                 *                                    record.
             
                                 * create a window for the text to be displayed.
             
                                 lmarg = 70
                                 onrow = 13
                                 noflines = mlcount(line_show,lmarg)     && NEW COMMAND
                                 wn4 = savescreen(11,0,14+noflines,79)
                                 setcolor(reverse)
                                 @ 11,0,14+noflines,79 box boxstring(1)
                                 setcolor(bright)
                                 @ 12,1 clear to 13+noflines,78
                                 @ 14+noflines,3 say "[ word wrapped for clarity ]"
                                 statmsg("Press any key to finish viewing line.")
                                 for l = 1 to noflines
                                    show1 = memoline(line_show,lmarg,l)    && NEW COMMAND
                                    @ onrow + l - 1,3 say show1
                                 next
                                 inkey(0)
                                 restscreen(11,0,14+noflines,79,wn4)
                              endi
                           else
                              exit
                           endi
                        otherwise
                           exit
                     endc
                     if subexit
                        exit
                     endi
                  endd
                  scroll(2,0,21,79,0)
                  mcol = 0
                  zap
                  for x = 1 to len(showline)
                     showline[x] = ""
                  next
               else
                  mcol = mcol + 25    && increment screen columns
               endi
            else
               if mrow = 55
                  eject
                  mrow = 3
                  mtoc = "-= THE FUNCTION LISTER! =-"
                  @ mrow,rcenter(mtoc) say mtoc
                  mrow = mrow + 2
                  @ mrow,0 say " Function Names: (2 across listing) for "+get_prg+"  ("+dtoc(get_date)+")"
                  @ mrow+1,0 say repl("-",60)+"[Page:"+lstr(mpage+1)+"]"
                  mrow = incr(mrow,2)
                  mpage = incr(mpage)
               endi
            endi
         endd
         line_num = incr(line_num)
         if subexit
            exit
         endi
      endi
   endd
   if .not. toprint
      if .not. subexit .and. reccount() > 0
         do while .t.
            statmsg("(V)iew - code line. Any key to continue.")
            see = 0
            do while see = 0
               see = inkey()
            endd
            @ 24,0
            do case
               case uppe(chr(see)) = "V"
                  seeline = 0
                  set cursor on
                  @ 24,0
                  @ 24,10 say "Enter the line number next to the function: " get seeline ;
                  pict "999999"
                  read
                  set cursor off
                  if seeline > 0
                     go top
                     locate for LINENUM = seeline
                     if eof()
                        staterr("Line Number not on display . . .")
                     else
                        line_show = alltrim(LINETXT)
                        *                                    line of text containing the
                        *                                    record.
    
                        * create a window for the text to be displayed.
    
                        lmarg = 70
                        onrow = 13
                        noflines = mlcount(line_show,lmarg)
                        wn4 = savescreen(11,0,14+noflines,79)
                        setcolor(reverse)
                        @ 11,0,14+noflines,79 box boxstring(1)
                        setcolor(bright)
                        @ 12,1 clear to 13+noflines,78
                        @ 14+noflines,3 say "[ word wrapped for clarity ]"
                        statmsg("Press any key to finish viewing line.")
                        for l = 1 to noflines
                           show1 = memoline(line_show,lmarg,l)
                           @ onrow + l - 1,3 say show1
                        next
                        inkey(0)
                        restscreen(11,0,14+noflines,79,wn4)
                     endi
                  else
                     exit
                  endi
               otherwise
                  exit
            endc
         endd
         staterr("No further Functions. ")
      endi
      scroll(2,0,21,79,0)
      erase txt_temp.dbf
   else
      if .not. empty(fc_line) .and. p_interupt <> 27
         @ mrow,2 say trim(fc_line)
      endi
      eject
      set device to screen
      set console on
      restscreen(10,20,14,60,wn1)
   endi
   tone(130.80,2)    && NEW COMMAND  - hey tunes - and thanks for the
   tone(174.60,2)    && musical note equivalents in the EXTEND.DOC file.
   tone(196.00,2)
   setcolor(normal)
   tone(246.90,5)
   return(0)
*************************************************************************
* I will leave you to look over the following batch of
* UDFs.  Nothing super special about them. They are
* practical and wonderful.  Some are identified by REFERENCE(CLIPPER)
* which refers to the Journal from Pinnacle Publishing, Inc., of
* Tacoma, Washington.
* Much credit goes to them.  Thanks.
**************************************************************************
func isfile      && use as function with VALID to check existence of a 
   *                file at entry time.
   para key_pressed,this_file
   if key_pressed = 27 .or. key_pressed = 13 .or. empty(this_file)
   return(.t.)
endi
if !file(this_file+".prg")
   staterr("File name not found.")
   return(.f.)
endi

func ppause
   set device to screen
   wn3 = savescreen(10,20,14,60)
   tone(300,1)
   tone(499,3)
   tone(700,2)
   declare p_pause[2]
   p_pause[1] = "Abandon Printing      "
   p_pause[2] = "Re-Start Printing     "
   setcolor(bright)
   @ 11,29 to 14,52 doub
   @ 11,30 say " [ PRINTER INTERUPT! ] "
   p_ = achoice(12,30,13,51,p_pause)
   restscreen(10,20,14,60,wn3)
   if p_ = 0 .or. p_ = 1
   return(27)
else
   return(p_)
endi

func statmsg
   para msg_txt
   tone(246.90,5)
   tone(329.60,2)
   setcolor(bright)
   @ 24,0
   @ 24,rcenter(msg_txt) say msg_txt
   setcolor(normal)
return("")

func staterr
   para err_txt
   tone(300,1)
   tone(499,5)
   tone(700,5)
   err_txt = err_txt +" Press any key to continue."
   setcolor(bright)
   @ 24,0
   @ 24,rcenter(err_txt) say err_txt
   inkey(0)
   setcolor(normal)
   @ 24,0
return("")

func statline
   para section,stat_txt
   setcolor(reverse)
   do case
      case section = 1
         @ 23,0 say space(10)
         @ 23,0 say stat_txt
      case section = 2
         @ 23,11 say space(24)
         @ 23,11 say stat_txt
      case section = 3
         @ 23,39 say space(25)
         @ 23,39 say stat_txt
      case section = 4
         @ 23,67 say space(12)
         @ 23,67 say stat_txt
   endc
   setcolor(normal)
return("")
***
FUNC rcenter
   para str_to_ctr
   if len(str_to_ctr) < 80
      ctr_col = int(80 - len(str_to_ctr))/2
   else
      ctr_col = 0
   endi
return(ctr_col)
***
func lstr    && REFCLIP()  UDF - I use this alot.
   para l_str_num
   return(ltri(str(l_str_num)))
***
func incr
   para incr_var,incr_step
   if pcou()=1
      incr_var = incr_var + 1
   else
      incr_var = incr_var + incr_step
   endi
   retu(incr_var)
***
func decr
   para decr_var,decr_step
   if pcou()=1
      decr_var = decr_var - 1
   else
      decr_var = decr_var - decr_step
   endi
   retu(decr_var)
***
func BoxString        && REFCLIP()
   para b_s_type
   if pcou() = 0
      return(chr(201)+chr(205)+chr(187)+chr(186)+chr(188)+chr(205)+chr(200)+chr(186)+" ")
   endi
   do case
      case b_s_type = 1
         return(chr(201)+chr(205)+chr(187)+chr(186)+chr(188)+chr(205)+chr(200)+chr(186)+" ")
      case b_s_type = 2
         return(chr(218)+chr(196)+chr(191)+chr(179)+chr(217)+chr(196)+chr(192)+chr(179)+" ")
      case b_s_type = 3
         return(chr(213)+chr(205)+chr(184)+chr(179)+chr(190)+chr(205)+chr(212)+chr(179)+" ")
      case b_s_type = 4
         return(chr(214)+chr(196)+chr(183)+chr(186)+chr(189)+chr(196)+chr(211)+chr(186)+" ")
      otherwise
         return(chr(201)+chr(205)+chr(187)+chr(186)+chr(188)+chr(205)+chr(200)+chr(186)+" ")
   endc
***
* GetAFile     REFCLIP()
***
func getafile
   para extn,row,col,height,boxchar
   priv number,files,ctr,picked
   number = adir("*."+extn)
   if number = 0
      return("")
   endi
   declare files[number]
   adir("*."+extn,files)
   for ctr = 1 to number
      files[ctr] = subs(files[ctr],1,at(".",files[ctr])-1)
   next
   if number < height - 2
      height = number + 1
   endi
   @ row,col,row + height,col+15 box boxstring(boxchar)
   @ row,col + 1 say "[ Files ]"
   @ row + height,col+1 say "[,,RET,ESC]"
   picked = achoice(row+1,col+2,(row+1)+(height -2),col + 14,files)
   if picked = 0
      return("")
   endi
   return(files[picked])

*** HELP PROC *** No comments necessary here.
Proc help
para prg,lnum,ivar
if prg = "HELP"
   return
endi
save screen
setcolor(normal)
scroll(1,1,24,79,0)
setcolor(bright)
@ 1,2,13,78 box boxstring(1)
setcolor(normal)
@ 1,23 SAY "[ -= The FUNCTION LISTER! =- ]"
@ 3,4 say "The objective of this utility program is simple.  It will list either"
@ 4,4 say "to screen or to the printer, the names of all functions it finds in any"
@ 5,4 say "*.prg file you indicate.  It will even run through all the *.prg files"
@ 6,4 say "in a directory and list them by name.  If you list them to the screen,"
@ 7,4 say "you can view the full line of code in which a function is found."
@ 8,4 say "    The reasons for this utility are also quite simple."
@ 9,4 say "1. It will help identify the many functions which make up your programs"
@10,4 say "and therefore help you link together the correct .LIB and/or .OBJ files."
@11,4 say "2. You can check the full code line and functions for proper arguments."
@12,4 say "3. It is also interesting visually to watch what functions are at work."
setcolor(bright)
@ 14,2,21,78 box boxstring(1)
setcolor(normal)
@ 15,4 say "The FUNCTION LISTER! was written by Paul H. Mannes, of dConsultant "
@ 16,4 say "Systems.  Paul specializes (like many of us) in the dBase family of "
@ 17,4 say "languages, doing system development for small and mid-size companies." 
@ 19,4 say "FLIST was written using the SUMMER '87 release of The Clipper"
@ 20,4 say "Compiler by Nantucket Corp.    "
setcolor(bright)
@ 21,23 say "[ More HELP -> PgDn, or ESC ]"
@ 23,0 say " dConsultant Systems                                      Paul H. Mannes"
@ 24,0 say " 10858 Parcel Ct., Oakton,  Virginia   22124               (703)620-6615"
setcolor(normal)
i = 0
do while .t.
   i = inke()
   if i = 3 .or. i = 27
      exit
   endi
endd
if i = 27
   restore screen
   return
endi
declare syn_tax[6]
syn_tax[1] = "Syntax Options:  1) FLIST < nothing else >   | *.prg loaded      "
syn_tax[2] = "                 2) FLIST < filename/no ext> | assumes .prg      "
syn_tax[3] = "                 3) FLIST < wildcard > | ex: GL_*                "
syn_tax[4] = "                 4) FLIST < file1 file2 file3 ...file6>          "
syn_tax[5] = "     FLIST does not search other directories for files though    "
syn_tax[6] =  "     it can be called from any directory on the path line.       "
scrl_line = 15
s_num = 1
do while scrl_line <= 20
   scroll(scrl_line,4,20,75,-1)
   @ scrl_line,4 say "     "+syn_tax[s_num]
   s_num = incr(s_num)
   scrl_line = incr(scrl_line)
endd
setcolor(bright)
@ 21,23 say "[  You can Press ESC to Exit  ]"
setcolor(normal)
inkey(0)
clear typeahead
restore screen
return
***************************** EOF - FUNCLIST.PRG *** FLIST.EXE *************************

     


      


