/****
*   Program Name: FIX.PRG    
*
*   Date Created: 03/23/93          
*   Time Created: 09:59:15
*   Author      : Michael Abadjiev  CIS: 71563,3312
*   Language    : Clipper 5.20    
*   Compile     : clipper FIX.PRG /n /w
*
*   -=- NOTE: Suggestions greatly appreciated - Mike
*/

#include "inkey.ch"
#include "fileio.ch"

#define B_SOLID_SPACE                  ' '

FUNCTION Fix(cFileIn,cFileOut)

    LOCAL nFileSize := 0,               ;
          nOccure := 0,                 ;
          getlist := {},                ;
          nHandle,                      ;
          nMaxLen := 64,                ;
          cBuffer,                      ;
          nPtrPos := 0,                 ;
          cTemp := "",                  ;
          nSearch,                      ;
          nReadBytes := 0,              ;
          lRename := .f.,               ;
          lEdit := .f.

    set confirm on
    set scoreboard off

    BEGIN SEQUENCE
        // Dealing with parameters....
        IF pcount() == 0          
            cFileIn := space(13)
            cFileOut := space(13)
            lEdit := .t.
        ELSEIF pcount() == 1
            IF !file(cFileIn)
                alert("ERROR: File " + upper(cFileIn) + " is not a valid name!")
                BREAK
            ENDIF
            cFileOut := "_TEMP_"
            lRename := .t.
        ELSEIF pcount() == 2
            IF !file(cFileIn)
                alert("ERROR: File " + upper(cFileIn) + " not found!")
                cFileIn := pad(cFileIn,13)
                cFileOut := pad(cFileOut,13)
                lEdit := .t.    
            ENDIF
        ENDIF

        // Some drawing....
        dispbegin()
        scroll()
        dispbox( 02,01,07,maxcol()-1,B_SOLID_SPACE,"BG+/B")
        @ 03,02 say padc("Program to replace all occurrences",76) color "GR+/B"
        @ 04,02 say padc("of....:  CLIPPER501", 76) color "W+/B"
        @ 05,02 say padc("with..:  CLIPPER520", 76) color "W+/B"
        @ 06,02 say padc("Written by: Michael Abadjiev CIS: 71563,3312",76)  ;
                color "B+/B"
        dispend()

        // Shall we have GETs.....
        IF lEdit
            @ maxrow(),0 say padc("Press <Esc> to Exit",maxcol()+1) color "W/B"
            devpos(maxrow()-5,00)
            @ row(),00  say "Input Library file name......:"   ;
                        get cFileIn                            ;
                        picture "@!"                           ;
                        valid file(cFileIn)

            @ row()+1,00 say "Output Library file name.....:"  ;
                         get cFileOut                          ;
                         picture "@!"                          ;
                         valid !file(cFileOut)
            read
            @ maxrow(),0

            // Exit...
            IF lastkey() == K_ESC
                scroll()
                BREAK
            ENDIF   
        ENDIF

        // Make a second copy of the library and work with this copy...
        __copyfile(cFileIn,cFileOut)
        // Low level file stuff...
        nHandle := fopen(cFileOut,FO_READWRITE)
        IF ferror() <> 0
            alert("ERROR: Opening file!")
            BREAK
        END             

        // Get the file size....
        nFileSize := FileSize(nHandle)
        @ maxrow(),0 say "File Size...: " + alltrim(transform(nFileSize,"99,999,999"))

        WHILE .t.
            // Display the search - progress...
            nPtrPos := FilePos( nHandle )
            @ maxrow(),maxcol()-30 say "Searching........:" + str(nPtrPos,10)

            cTemp := ""
            cBuffer := space(64)
            // Read 64 bytes....
            nReadBytes := fread(nHandle,@cBuffer,nMaxLen)
            // Look how many we have red...
            // in case less then 64 bytes we are very close to EOF...
            // actually this is the last shot...
            IF nReadBytest <> nMaxLen      
                fseek(nHandle,-nReadBytes, FS_RELATIVE)
                cBuffer := left(cBuffer,nReadBytes)
                nSearch := at("CLIPPER501",cBuffer)
                // If found...
                IF nSearch > 0              
                    cTemp := strtran(cBuffer,"CLIPPER501","CLIPPER520")
                    fwrite(nHandle,cTemp,nReadBytes)
                    nOccure++
                    @ maxrow()-2, 00 say                                ;  
                    padc(" Replace CLIPPER501->CLIPPER520 Times: "+     ;
                    alltrim(transform(nOccure,"99,999")) ,maxcol()+1)   ;
                    color "GR+/N"
                ENDIF
                EXIT
            ENDIF

            // Otherwise we are somewhere in the file...
            nSearch := at("CLIPPER501",cBuffer)         
            // If found...
            IF nSearch <> 0
                // go back
                fseek(nHandle,-nMaxLen,FS_RELATIVE)
                // change the buffer..
                cTemp := strtran(cBuffer,"CLIPPER501","CLIPPER520")
                // write the new contents...
                fwrite(nHandle,cTemp,nMaxLen)
                cTemp := ""           
                // reasign the buffer just for sure...
                cBuffer := space(64)                  
                // increment the counter...
                nOccure++                  
                // some screen output...
                @ maxrow()-2, 00 say                                ;
                padc(" Replace CLIPPER501->CLIPPER520 Times: "+     ;
                alltrim(transform(nOccure,"99,999")) ,maxcol()+1)   ;
                color "GR+/N"
            ENDIF           
            // tricky go back lenght of 'CLIPPER501' + something
            // just to be sure that we don't missed something...
            fseek(nHandle,-12,FS_RELATIVE)
            // do the same thing again....
       END

       fclose(nHandle)
       IF lRename
           ferase(cFileIn)
           frename(cFileOut,cFileIn)
       ENDIF
       @ maxrow(),0 say "Occurences.....: " + str(nOccure,10)
       // Beep... That's it!
       tone(7000,10)

   END SEQUENCE

RETURN nil


STATIC FUNCTION FileSize( nHandle )
   
   LOCAL nCurrent
   LOCAL nLength

   // Get file position
   nCurrent := FilePos( nHandle )

   // Get file length
   nLength := fseek( nHandle, 0, FS_END )

   // Reset file position
   fseek( nHandle, nCurrent )

RETURN nLength


STATIC FUNCTION FilePos( nHandle )

RETURN fseek( nHandle, 0, FS_RELATIVE ) 


// **** EOF: fix.prg
