/*
 * File......: SAVEARR.PRG
 * Author....: David Barrett
 * CIS ID....: 72037,105
 * Date......: $Date:   28 Sep 1992 22:04:18  $
 * Revision..: $Revision:   1.3  $
 * Log file..: $Logfile:   C:/nanfor/src/savearr.prv  $
 *
 * This is an original work by David Barrett and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log:   C:/nanfor/src/savearr.prv  $
 *    Rev 1.4   17 Dec 1993 12:51:21   CHRISTOPHER OLSON 71212,72
 * Revised FT_SAVEARR() to properly handle multi-dimensional arrays and 
 * Nil array elements.  This function now gives the programmer the option 
 * of failing when encountering a compiled code block in the array or 
 * replacing the compiled code block with a default value.  Also revised 
 * test code for the additions.
 * 
 *    Rev 1.3   28 Sep 1992 22:04:18   GLENN
 * A few users have reported that these functions do not support
 * multi-dimensional arrays.  Until the bugs are verified and
 * workarounds or re-writes devised, a warning has been placed in the
 * documentation.
 * 
 *    Rev 1.2   15 Aug 1991 23:06:06   GLENN
 * Forest Belt proofread/edited/cleaned up doc
 * 
 *    Rev 1.1   14 Jun 1991 19:52:54   GLENN
 * Minor edit to file header
 * 
 *    Rev 1.0   07 Jun 1991 23:39:38   GLENN
 * Initial revision.
 *
 *
 */



MEMVAR lRet

#ifdef FT_TEST              // test program to demonstrate functions
 LOCAL bBlock := {|x| str(x,3)}
 LOCAL aArray := { {'Invoice 1', CTOD('04/15/91'), 1234.32, .T., Nil, bBlock},;
                {'Invoice 2', DATE(), 234.98, .F., Nil, bBlock},;
                {'Invoice 3', DATE() + 1, 0, .T., Nil, bBlock}  }, aSave
 LOCAL nErrorCode := 0
 ?
 ? 'Should fail on first code block'
 IF FT_SAVEARR(aArray,'INVOICE.DAT',@nErrorCode) .and. ;
          nErrorCode = 0
   DispArray(aArray)
   aSave := FT_RESTARR('INVOICE.DAT',@nErrorCode)
   IF nErrorCode = 0
     DispArray(aSave)
   ELSE
      ? 'Error restoring array'
   ENDIF
 ELSE
   ? 'Error writing array'
 ENDIF
 ?
 ? 'Should not fail on code blocks'
 IF FT_SAVEARR(aArray,'INVOICE.DAT',@nErrorCode,.F.,"WAS BLOCK") .and. ;
          nErrorCode = 0
   DispArray(aArray)
   aSave := FT_RESTARR('INVOICE.DAT',@nErrorCode)
   IF nErrorCode = 0
     DispArray(aSave)
   ELSE
      ? 'Error restoring array'
   ENDIF
 ELSE
   ? 'Error writing array'
 ENDIF
 RETURN

 FUNCTION DispArray(aTest)
   LOCAL nk
   FOR nk := 1 TO LEN(aTest)
     ? aTest[nk, 1]
     ?? '  '
     ?? DTOC(aTest[nk, 2])
     ?? '  '
     ?? STR(aTest[nk, 3])
     ?? '  '
     ?? IF(aTest[nk, 4], 'true', 'false')
     ?? '  '
     ?? IF(aTest[nk, 5]=Nil, 'Nil', '   ')
     ?? '  '
     ?? if(ValType(aTest[nk, 6])='B', eval(aTest[nk, 6], nk), aTest[nk, 6])
   NEXT
 RETURN Nil
#endif




/*  $DOC$
 *  $FUNCNAME$
 *     FT_SAVEARR()
 *  $CATEGORY$
 *     Array
 *  $ONELINER$
 *     Save Clipper array to a disc file.
 *  $SYNTAX$
 *     FT_SAVEARR( <aArray>, <cFileName>, <nErrorCode>,;
 *                 [<lBlockFail>], [<xBlockDef>]) -> lRet
 *  $ARGUMENTS$
 *     <aArray> is any Clipper array except those containing
 *     compiled code blocks.
 *
 *     <cFileName> is a DOS file name.
 *
 *     <nErrorCode> will return any DOS file error.
 *
 *     <lBlockFail> is an optional logical, .T. if a code block in 
 *     the array should fail the save, .F. if xBlockDef should be 
 *     saved in its place.  The default is .T.
 *
 *     <xBlockDef> is any Clipper value other than a code block to be 
 *     saved in place of a code block if one is found in the array 
 *     being saved and lBlockFail is .F.  The default is Nil.
 *
 *     All arguments are required.
 *
 *  $RETURNS$
 *     .F. if there was a DOS file error or the array contained
 *     code blocks, otherwise returns .T.
 *  $DESCRIPTION$
 *     FT_SAVEARR() saves any Clipper array to a disc file.  Compiled 
 *     code blocks are not saved, but either return an error or save 
 *     a specified data value in their place.  The array can be 
 *     restored from the disc file using FT_RESTARR().
 *
 *     [10/1/92 Librarian note:
 *
 *     This function does not appear to work with multi-dimensional
 *     arrays.  If you'd care to modify it to support this feature,
 *     please do and send it to Glenn Scott 71620,1521.]
 *
 *     [12/17/93 Revision note:
 *
 *     I have revised this function to work with multi-dimensional 
 *     arrays as well as to better handle code blocks.  It turns out 
 *     the multi-dimensions failed because of the way Nil values were
 *     saved.  This function now gives the option of failing when
 *     encountering a code block or replacing the block with a default
 *     value.  Christopher Olson 71212,72.]
 *
 *     
 *  $EXAMPLES$
 *    aArray := { {'Invoice 1',CTOD('04/15/91'),1234.32,.T.},;
 *                {'Invoice 2',DATE(),234.98,.F.},;
 *                {'Invoice 3',DATE() + 1,0,.T.}  }
 *    nErrorCode := 0
 *    FT_SAVEARR(aArray,'INVOICE.DAT',@nErrorCode)
 *    IF nErrorCode = 0
 *      aSave := FT_RESTARR('INVOICE.DAT',@nErrorCode)
 *      IF nErrorCode # 0
 *         ? 'Error restoring array'
 *      ENDIF
 *    ELSE
 *      ? 'Error writing array'
 *    ENDIF
 *
 *  $SEEALSO$
 *     FT_RESTARR()
 *  $END$
 */


FUNCTION FT_SAVEARR(aArray, cFileName, nErrorCode, lBlockFail, xBlockDef)
 LOCAL nHandle, lRet
 nHandle = FCREATE(cFileName)
 nErrorCode = FError()
 IF lBlockFail = Nil
   lBlockFail = .T.
 ENDIF
 IF nErrorCode = 0
   lRet := _ftsavesub(aArray, nHandle, @nErrorCode, lBlockFail, xBlockDef)
   FCLOSE(nHandle)
   IF (lRet) .AND. (FERROR() # 0)
      nErrorCode = FERROR()
      lRet = .F.
    ENDIF
 ELSE
   lRet = .F.
 ENDIF
 RETURN lRet

STATIC FUNCTION _ftsavesub(xMemVar, nHandle, nErrorCode, lBlockFail, xBlockDef)
 LOCAL cValType, nLen, cString
 PRIVATE lRet       // accessed in code block
 lRet := .T.
 cValType := ValType(xMemVar)
 IF cValType = "B" .AND. .NOT. lBlockFail
   xMemVar := xBlockDef
   cValType := ValType(xMemVar)
 ENDIF
 FWrite(nHandle, cValType, 1)
 IF FError() = 0
   DO CASE
     CASE cValType = "A"
       nLen := Len(xMemVar)
       FWrite(nHandle, L2Bin(nLen), 4)
       IF FError() = 0
         AEVAL(xMemVar, {|xMemVar1| lRet := lRet .and.  _ftsavesub(xMemVar1, nHandle,, lBlockFail, xBlockDef) } )
       ELSE
         lRet = .F.
       ENDIF
     CASE cValType = "B"
       lRet := .F.
     CASE cValType = "C"
       nLen := Len(xMemVar)
       FWrite(nHandle, L2Bin(nLen), 4)
       FWrite(nHandle, xMemVar)
     CASE cValType = "D"
       nLen := 8
       FWrite(nHandle, L2Bin(nLen), 4)
       FWrite(nHandle, DTOC(xMemVar))
     CASE cValType = "L"
       nLen := 1
       FWrite(nHandle, L2Bin(nLen), 4)
       FWrite(nHandle, IF(xMemVar, "T", "F") )
     CASE cValType = "N"
       cString := STR(xMemVar)
       nLen := LEN(cString)
       FWrite(nHandle, L2Bin(nLen), 4)
       FWrite(nHandle, cString)
     CASE cValType = "U"
       nLen:=0
       FWrite(nHandle, L2Bin(nLen), 4)
   ENDCASE
 ELSE
   lRet = .F.
 ENDIF
 nErrorCode = FError()
 RETURN lRet


/*  $DOC$
 *  $FUNCNAME$
 *     FT_RESTARR()
 *  $CATEGORY$
 *     Array
 *  $ONELINER$
 *     Restore a Clipper array from a disc file
 *  $SYNTAX$
 *     FT_RESTARR( <cFileName>, <nErrorCode> ) -> aArray
 *  $ARGUMENTS$
 *     <cFileName> is a DOS file name.
 *
 *     <nErrorCode> will return any DOS file error.
 *
 *     All arguments are required.
 *  $RETURNS$
 *     Return an array variable.
 *  $DESCRIPTION$
 *     FT_RESTARR() restores an array which was saved to
 *     a disc file using FT_SAVEARR().
 *
 *     [10/1/92 Librarian note:
 *
 *     This function does not appear to work with multi-dimensional
 *     arrays.  If you'd care to modify it to support this feature,
 *     please do and send it to Glenn Scott 71620,1521.]
 *
 *     [12/17/93 Revision note:
 *
 *     No revisions were made to this function, however, I have 
 *     revised the FT_SAVEARR() function to work with multi-dimensional 
 *     arrays as well as to better handle code blocks.  It turns out 
 *     the multi-dimensions failed because of the way Nil values were
 *     saved.  Christopher Olson 71212,72.]
 *
 *  $EXAMPLES$
 *    aArray := { {'Invoice 1',CTOD('04/15/91'),1234.32,.T.},;
 *                {'Invoice 2',DATE(),234.98,.F.},;
 *                {'Invoice 3',DATE() + 1,0,.T.}  }
 *    nErrorCode := 0
 *    FT_SAVEARR(aArray,'INVOICE.DAT',@nErrorCode)
 *    IF nErrorCode = 0
 *      aSave := FT_RESTARR('INVOICE.DAT',@nErrorCode)
 *      IF nErrorCode # 0
 *         ? 'Error restoring array'
 *      ENDIF
 *    ELSE
 *      ? 'Error writing array'
 *    ENDIF
 *
 *  $SEEALSO$
 *     FT_SAVEARR()
 *  $END$
 */

FUNCTION FT_RESTARR(cFileName, nErrorCode)
 LOCAL nHandle, aArray
 nHandle := FOPEN(cFileName)
 nErrorCode := FError()
 IF nErrorCode = 0
  aArray := _ftrestsub(nHandle, @nErrorCode)
  FCLOSE(nHandle)
 ELSE
   aArray := {}
 ENDIF
 RETURN aArray

STATIC FUNCTION _ftrestsub(nHandle, nErrorCode)
  LOCAL cValType, nLen, cLenStr, xMemVar, cMemVar, nk
  cValType := ' '
  FREAD(nHandle, @cValType, 1)
  cLenStr := SPACE(4)
  FREAD(nHandle, @cLenStr, 4)
  nLen = Bin2L(cLenStr)
  nErrorCode = FError()
  IF nErrorCode = 0
    DO CASE
      CASE cValType = "A"
        xMemVar := {}
        FOR nk := 1 TO nLen
          AADD(xMemVar, _ftrestsub(nHandle))      // Recursive call
        NEXT
      CASE cValType = "C"
        xMemVar := SPACE(nLen)
        FREAD(nHandle, @xMemVar, nLen)
      CASE cValType = "D"
        cMemVar = SPACE(8)
        FREAD(nHandle, @cMemVar,8)
        xMemVar := CTOD(cMemVar)
      CASE cValType = "L"
        cMemVar := ' '
        FREAD(nHandle, @cMemVar, 1)
        xMemVar := (cMemVar =  "T")
      CASE cValType = "N"
        cMemVar := SPACE(nLen)
        FREAD(nHandle, @cMemVar, nLen)
        xMemVar = VAL(cMemVar)
    ENDCASE
    nErrorCode := FERROR()
  ENDIF
  RETURN xMemVar

