/* This program is released into the public domain with the condition
   that this notice is not removed.

    Dean Keith
    Keith Consulting
    521 Annandale Rd.
    Knoxville, TN  37922
    (615) 966-1570 Voice
    (615) 675-4035 Fax
    73163,1035 CompuServe ID

    This program provides the ability to search disks and directories for
    certain file types.

    This program is written for Provision:Windows and requires the use of
    Clipper Tools.  Successful implementation will be obtained using
    Exospace.  Due to the DOS25 package required for these routines Blinker
    version 3.0 or 3.1 cannot be used at this time.  However with the release
    of the appropriate library from Blink Inc. this may change in the future.

    This program is similar to the window shown in windows when requesting
    to open a file.  You may select different disks, directories and file
    extensions.

    To use this function, write a state similar to the following:
    result := Findfile({'DBF ', 'DBT '})
    This result of this routine will return a 2-dimensional array with the
    following characteristics:
    1) element one will contain the path of the chosen file;
    2) element two will contain the name of the chosen file.
    In the event that cancel is chosen both elements will be blank.

    The parameter must be passed and is an array that defines the file
    extensions.

    This routine as I use it is to locate a particular file to copy into
    a directory of my choice.  After this routine has executed, I check
    to make sure the target directory is not the same as the source
    directory; result[1].  This would result in my copying the file onto itself
    and that is not allowed.

    I then check to make sure the file does not exist.  If it does exist,
    I ask the user if we want to overwrite the existing file.

    One point of notice, If you enter a file name into the file slot, it must
    be present in the current directory.  If not, the file slot is blanked out.

    Any problems associated with this routine should be passed back to me
    and I will definitely fix them.  I haven't found any problems, but you
    know how easy it is for the author to miss them.

    If you make changes that improve it, let me know and I'll re-post the
    program.
*/

/*
 Program Ŀ
  Application:                                                            
  Description: Window to locate files on any disk and directory.          
    File Name: FINDFILE.PRG                                               
       Author: M. Dean Keith                                              
 Date created: 06-11-94              Date updated: 06-11-94              
 Time created: 03:19:38pm            Time updated: 03:19:38pm            
    Make File:                                                            
    Exec File:                       Docs By: M. Dean Keith               
    Copyright: (c) 1994 by M. Dean Keith, ALL RIGHTS RESERVED             

*/
#include 'set.ch'
#include 'inkey.ch'
#include 'pw.ch'

#define TRUE    .T.
#define FALSE   .F.



STATIC oFindfile
STATIC afiles := {}
STATIC amatch := {}
STATIC mfilelist
STATIC oFilelist
STATIC oFilename
STATIC oFiletype
STATIC oDrives
STATIC oCurdir
STATIC acurdirs := {}
STATIC mcurdir
STATIC mfilename
STATIC mdrives
STATIC adrives := {}
STATIC mfiletype
STATIC nCurmouse
STATIC curdir
STATIC curdisk
STATIC lexactset
STATIC aResult := {}


/*
 Function Ŀ
         Name: Findfile()            Docs: M. Dean Keith                  
  Description: entry point of function                                    
       Author: M. Dean Keith                                              
 Date created: 06-11-94              Date updated: 06-11-94              
 Time created: 03:29:28pm            Time updated: 03:29:28pm            
    Copyright: M. Dean Keith, ALL RIGHTS RESERVED                         
Ĵ
    Arguments: matchary - array of files to match, i.e. {'DBF','DBT'}     
 Return Value: aResult - return value, 2 dimensional, {directory, file}   
     See Also:                                                            

*/
FUNCTION Findfile( matchary )

LOCAL atemp
LOCAL getlist := {}

IF matchary == NIL                               // search for these file types
	amatch := {'*.*'}
ELSE
	amatch := matchary
ENDIF

curdir := DIRNAME()                              // need to save current location
curdisk := DISKNAME()

lexactset := SET(_SET_EXACT, TRUE)               // must match exactly

aResult := ARRAY(2)                              // return variable

nCurmouse := pw():mousecursor(PMCURSOR_HOUR)     // save mouse shape

adrives := Disktest()                            // get list of active drives

// need list of drive letters only
mdrives := ASCAN(adrives, {|x| DISKNAME() == SUBSTR(x,7,1)})

// create list of available directories
acurdirs := {}
atemp := DIRECTORY('*.*','D')
AEVAL(atemp, {|x| IIF(x[5] == 'D'.AND. ALLTRIM(x[1]) != '.', AADD(acurdirs, x[1]),)})
acurdirs := IIF(LEN(acurdirs) == 0, {' '}, ASORT(acurdirs) )

// create list of available files
afiles := {}
atemp := DIRECTORY('*.' + LEFT(amatch[1],3))
AEVAL(atemp, {|x| AADD(afiles, x[1])})
afiles := IIF(LEN(afiles) == 0, {' '}, ASORT(afiles))

// create window
CREATE WINDOW oFindfile ;
    AT 4, 14 ;
    SIZE 18, 57 ;
    VIRTUAL SIZE 17, 61 ;
    VIRTUAL OFFSET 0, 0 ;
    STYLE 3075 ;
    TITLE 'Open File' ;
    SHADOW ;
    BORDERS 15 ;
    WINDOW HANDLER {|idmsg| IIF(idmsg == PWMSG_CLOSE, Endbox(), ), .T.}

// paint inside of window
@ 1, 4 say 'Path: ' + DISKNAME() + ':' + DIRNAME() + SPACE(30)

@ 3, 4 GET mdrives AS COMBOBOX oDrives ;
    USING adrives ;
    INITIAL mdrives  ;
    PROMPT  ABOVE 'Drives:' ;
    ACTION {|| Adrives( mdrives ) }

@ 3, 26 GET mfiletype AS COMBOBOX oFiletype ;
    USING amatch ;
    INITIAL 1 ;
    PROMPT  ABOVE 'File Types:' ;
    ACTION {|| Afilematch( mfiletype )}

@ 7, 4 GET mcurdir AS LISTBOX oCurdir ;
    USING acurdirs ;
    SIZE 9, 20  ;
    INITIAL 1  ;
    PROMPT 'Directories:' ;
    FILTER {|idmsg| Acurdir( idmsg, mcurdir, oFilename, oFiletype, oFileList )}

@ 6, 26 GET mfilename AS TEXTFIELD oFilename ;
    INITIAL '            ' ;
    PROMPT ABOVE 'Filename:' ;
    PICTURE 'XXXXXXXXXXXX' ;
    VALID {|| Vfilename( @mfilename, oFilename )}

@ 8, 25 GET mfilelist AS LISTBOX oFilelist ;
    USING afiles ;
    SIZE 8, 16  ;
    INITIAL 1 ;
    FILTER {|idmsg| Afilelist( idmsg, mfilelist, oFilename )}

@ 5, 43 GET AS PUSHBUTTON ;
    SIZE 3, 10 ;
    PROMPT ' Select ' ;
    ACTION {|| oFindfile:close() }


// we can tell we cancelled because the result array will be blank
@ 8, 43 GET AS PUSHBUTTON ;
    SIZE 3, 10 ;
    PROMPT ' Cancel ' ;
    ACTION {|| oFindfile:close(), AFILL(aResult, '') }

ATTACH CONTROLS TO oFindfile

// window will be modal
OPEN WINDOW oFindfile MODAL

IF pw():curfocus() == oFindfile
    pw():mousecursor(PMCURSOR_ARROW)
    pw():beginmodal()
ENDIF

RETURN( aResult )




/*
 Function Ŀ
         Name: Afilematch()          Docs: M. Dean Keith                  
  Description: update file control with new list of files                 
       Author: M. Dean Keith                                              
 Date created: 06-11-94              Date updated: 06-11-94              
 Time created: 03:26:14pm            Time updated: 03:26:14pm            
    Copyright: M. Dean Keith, ALL RIGHTS RESERVED                         
Ĵ
    Arguments: code - array list to match files against                   
 Return Value: NIL                                                        
     See Also:                                                            

*/
STATIC FUNCTION Afilematch( code )

LOCAL atemp
LOCAL getlist := {}

// update file list
atemp := DIRECTORY('*.' + LEFT(amatch[code],3))
afiles := {}
AEVAL(atemp, {|x| AADD(afiles, x[1])})
afiles := IIF(LEN(afiles) == 0, {' '}, ASORT(afiles))

// delete current control
oFindfile:delcontrol(5,1)

// create new control in same position with new file list
@ 8, 25 GET mfilelist AS LISTBOX oFilelist ;
    USING afiles ;
    SIZE 8, 16  ;
    INITIAL 1 ;
    FILTER {|idmsg| Afilelist( idmsg, mfilelist, oFilename )}

// add the new control to the control list
oFindfile:addcontrols(getlist,5)

RETURN( NIL )




/*
 Function Ŀ
         Name: Vfilename()           Docs: M. Dean Keith                  
  Description: Make sure the file entered into control matches the list   
       Author: M. Dean Keith                                              
 Date created: 06-11-94              Date updated: 06-11-94              
 Time created: 03:28:57pm            Time updated: 03:28:57pm            
    Copyright: M. Dean Keith, ALL RIGHTS RESERVED                         
Ĵ
    Arguments: code - file entered into control.                          
             : oCntl - control object of the entry box.                   
 Return Value: TRUE - always true                                         
     See Also:                                                            

*/
STATIC FUNCTION Vfilename( code, oCntl )

LOCAL ch

// check file list if it exists
IF LEN(afiles) > 0
	 // scan list
    ch := ASCAN(afiles, {|x| ALLTRIM(x) == ALLTRIM(code)})
	 // if not found, blank out the control, otherwise okay
    IF ch == 0
        code := SPACE(12)
        oCntl:setvalue(code)
    ENDIF
ELSE
	 // no files in list, blank out the control
    code := SPACE(12)
    oCntl:setvalue(code)
ENDIF

RETURN( TRUE )




/*
 Function Ŀ
         Name: Afilelist()           Docs: M. Dean Keith                  
  Description: Update file control if double click or enter is pressed.   
       Author: M. Dean Keith                                              
 Date created: 06-11-94              Date updated: 06-11-94              
 Time created: 03:34:02pm            Time updated: 03:34:02pm            
    Copyright: M. Dean Keith, ALL RIGHTS RESERVED                         
Ĵ
    Arguments: idmsg - message occurring in control                       
             : code - entry into control                                  
             : oCntl - control object                                     
 Return Value: NIL                                                        
     See Also:                                                            

*/
STATIC FUNCTION Afilelist( idmsg, code, oCntl )

// if mouse double click or enter was pressed
IF (idMsg == PWMSG_KEYPRESS .AND. LASTKEY() == K_ENTER) .OR. (idMsg == PWMSG_MOUSEDOUBLE)
	 // update file control
    oCntl:setvalue(afiles[code] + SPACE(12 - LEN(afiles[code])))
ENDIF

RETURN( NIL )




/*
 Function Ŀ
         Name: Acurdir()             Docs: M. Dean Keith                  
  Description: Change to selected directory and update control            
       Author: M. Dean Keith                                              
 Date created: 06-11-94              Date updated: 06-11-94              
 Time created: 03:36:07pm            Time updated: 03:36:07pm            
    Copyright: M. Dean Keith, ALL RIGHTS RESERVED                         
Ĵ
    Arguments: idmsg - message sent to function from control              
             : mcurdir - index to directory array                         
 Return Value: NIL                                                        
     See Also:                                                            

*/
STATIC FUNCTION Acurdir( idmsg, mcurdir )

LOCAL oOutput
LOCAL atemp
LOCAL getlist := {}

// update if mouse double click or enter was pressed
IF (idMsg == PWMSG_KEYPRESS .AND. LASTKEY() == K_ENTER) .OR. (idMsg == PWMSG_MOUSEDOUBLE)
*IF idMsg == PWMSG_MOUSEDOUBLE
	 // change to the new directory
    DIRCHANGE(acurdirs[mcurdir])

	 // direct output to window and save current direction
    oOutput := pw():setoutput(oFindfile)

    // repaint the current directory path
    @ 1, 4 say 'Path: ' + DISKNAME() + ':' + DIRNAME() + SPACE(30)

    // redirect output back to original window
    pw():setoutput(oOutput)

    // blank out the filename field
    oFilename:setvalue(SPACE(12))

	 // delete directory control
    oFindfile:delcontrol(5,1)

    // update the files list
    atemp := DIRECTORY('*.' + LEFT(amatch[mfiletype],3))
    afiles := {}
    AEVAL(atemp, {|x| AADD(afiles, x[1])})
	 afiles := IIF(LEN(afiles) == 0, {' '}, ASORT(afiles))

	 // create new control with updated file list
    @ 8, 25 GET mfilelist AS LISTBOX oFilelist ;
        USING afiles ;
        SIZE 8, 16  ;
        INITIAL 1 ;
        FILTER {|idmsg| Afilelist( idmsg, mfilelist, oFilename )}

	 // add the control into the original position
	 oFindfile:addcontrols(getlist,5)

    //  update the directory list
    atemp := DIRECTORY('*.*','D')
    acurdirs := {}
    AEVAL(atemp, {|x| IIF(x[5] == 'D'.AND. ALLTRIM(x[1]) != '.', AADD(acurdirs, x[1]),)})
	 acurdirs := IIF(LEN(acurdirs) == 0, {' '}, ASORT(acurdirs))

	 // new getlist array
    getlist := {}

	 // delete the directory control
    oFindfile:delcontrol(3,1)

	 // create new control with update directory list
    @ 7, 4 GET mcurdir AS LISTBOX oCurdir ;
        USING acurdirs ;
        SIZE 9, 20  ;
        INITIAL 1  ;
        PROMPT 'Directories:' ;
        FILTER {|idmsg| Acurdir( idmsg, mcurdir, oFilename, oFiletype, oFileList )}

	 // add new control into original position
    oFindfile:addcontrols(getlist,3)

ENDIF

RETURN( NIL )




/*
 Function Ŀ
         Name: Adrives()             Docs: M. Dean Keith                  
  Description: Update controls with different drive is selected           
       Author: M. Dean Keith                                              
 Date created: 06-11-94              Date updated: 06-11-94              
 Time created: 05:06:33pm            Time updated: 05:06:33pm            
    Copyright: M. Dean Keith, ALL RIGHTS RESERVED                         
Ĵ
    Arguments: code - index to array of drives                            
 Return Value: NIL                                                        
     See Also:                                                            

*/
STATIC FUNCTION Adrives( code )

LOCAL atemp
LOCAL oOutput := pw():setoutput(oFindfile)
LOCAL getlist := {}

// change to selected drive
DISKCHANGE(SUBSTR(adrives[code], 7, 1))

// repaint the current directory path
@ 1, 4 say 'Path: ' + DISKNAME() + ':' + DIRNAME() + SPACE(30)

// redirect output back to orignal window
pw():setoutput(oOutput)

// blank out the filename field
oFilename:setvalue(SPACE(12))

// delete the file list control
oFindfile:delcontrol(5,1)

// update the files list
atemp := DIRECTORY('*.' + LEFT(amatch[mfiletype],3))
afiles := {}
AEVAL(atemp, {|x| AADD(afiles, x[1])})
afiles := IIF(LEN(afiles) == 0, {' '}, ASORT(afiles))

// create the new file list control with update file list
@ 8, 25 GET mfilelist AS LISTBOX oFilelist ;
    USING afiles ;
    SIZE 8, 16  ;
    INITIAL 1 ;
    FILTER {|idmsg| Afilelist( idmsg, mfilelist, oFilename )}

// add the control into the original position
oFindfile:addcontrols(getlist,5)

//  update the directory list
atemp := DIRECTORY('*.*','D')
acurdirs := {}
AEVAL(atemp, {|x| IIF(x[5] == 'D'.AND. ALLTRIM(x[1]) != '.', AADD(acurdirs, x[1]),)})
acurdirs := IIF(LEN(acurdirs) == 0, {' '}, ASORT(acurdirs))

// wipe out getlist array so we can add a new control
getlist := {}

// delete the original control
oFindfile:delcontrol(3,1)

// create the new control with the update directory list
@ 7, 4 GET mcurdir AS LISTBOX oCurdir ;
    USING acurdirs ;
    SIZE 9, 20  ;
    INITIAL 1  ;
    PROMPT 'Directories:' ;
    FILTER {|idmsg| Acurdir( idmsg, mcurdir, oFilename, oFiletype, oFileList )}

// add the new control into the original position
oFindfile:addcontrols(getlist,3)

RETURN( NIL )




/*
 Function Ŀ
         Name: Disktest              Docs: M. Dean Keith                  
  Description: Test to see which drives are available.                    
       Author: M. Dean Keith                                              
 Date created: 06-11-94              Date updated: 06-11-94              
 Time created: 05:10:31pm            Time updated: 05:10:31pm            
    Copyright: M. Dean Keith, ALL RIGHTS RESERVED                         
Ĵ
    Arguments: None                                                       
 Return Value: adrives - formatted list of available disk drives          
     See Also:                                                            

*/
STATIC FUNCTION Disktest

LOCAL i
LOCAL adrives := {}

// determine number of floppy drives
IF NUMDISKF() == 2
    AADD(adrives, 'Drive A:')
    AADD(adrives, 'Drive B:')
ELSE
	 // if less than two drives, check to see which are available
    IF DISKREADY('A')
        AADD(adrives, 'Drive A:')
    ENDIF
    IF DISKREADY('B')
        AADD(adrives, 'Drive B:')
    ENDIF
ENDIF

// check all remaining disk drives to see if they are available
FOR i := 3 TO 26
    IF DISKREADY(CHR(64+i))
        AADD(adrives, 'Drive ' + CHR(64+i) + ':')
    ENDIF
NEXT i

// return a formatted list of disk drives
RETURN( adrives )




/*
 Procedure Ŀ
         Name: Endbox()                                                   
  Description: End procedure to main window                               
       Author: M. Dean Keith                                              
 Date created: 06-11-94              Date updated: 06-11-94              
 Time created: 05:12:33pm            Time updated: 05:12:33pm            
    Copyright: M. Dean Keith, ALL RIGHTS RESERVED                         
Ĵ
   Parameters: None                                                       
     See Also:                                                            

*/
STATIC PROCEDURE Endbox()

// end modal
pw():endmodal()

// set mouse cursor back to original value
pw():mousecursor(nCurmouse)

// into a 2-dimensional array place the directory and selected file
aResult[1] := DISKNAME() + ':' + DIRNAME() + '\'
aResult[2] := ALLTRIM(mfilename)

// change back to original disk and directory, very important!
DISKCHANGE(curdisk)
DIRCHANGE(curdir)

// set the exact setting back to whatever it was
SET(_SET_EXACT, lexactset)

RETURN
