/*
   Financial Functions for Clipper      Stephen L. Woolstenhulme
                                        3805 Indigo Drive
   Solve for principal, payment,        Plano, Texas 75075
   loan term, or interest rate.         ( 214 ) 867-5094  

   Currently in *RAW* form.  No checking for negative amortizations, etc.
*/
   
#include 'inkey.ch'


//  Example of how to call each function...

function finfuncs                               // This tests it out ...
   ? GetPrin( 877.57, .10/12, 360 )
   ? GetPmt( 100000, .10/12, 360 )
   ? GetTerm( 100000, .10/12, 877.57 )
   ? GetRate( 100000, 877.57, 360 ) * 1200
return nil

Function GetPrin( nPmt, nRate, nTerm )          // Principal loan amount ...
   return nPmt / nRate * ;
          ( 1 - ( 1 + nRate )^( nTerm * -1 ) )

Function GetPmt( nPrin, nRate, nTerm )          // Loan Payment ...
   return ( nPrin * nRate ) / ;
          ( 1 - ( 1 + nRate )^( nTerm * -1 ) )

Function GetTerm( nPrin, nRate, nPmt )          // Term (# of Payments) ...
   return log( -( nRate * nPrin / nPmt ) + 1 ) / ;
          -log( nRate + 1 )

Function GetRate( nPrin, nPmt, nTerm )          // Interest Rate ...
   local nInt := .10, nGuess := 0

   do while lastkey() != K_ESC
       nGuess := GetPmt( nPrin, nInt, nTerm )

       if round( nGuess, 4 ) != round( nPmt, 4 )
          nInt := nInt * ( nPmt / nGuess )
       else
          exit
       endif

   enddo

return nInt


