; filesize.asm
;
; written by Gary Gruber
; Data Base Designs
; 619-568-4338
;
; This program uses code from several sources. The hex to ascii conversion
; is from R. Russell Freeland's FSIZE.ASM, an excellent program, but
; limited by the fact that it uses FCB's for file manipulation. This routine
; employs DOS FUNCTION CALL 43H to get and manipulate the file attribute
; byte. DOS sets the 5th bit in this byte (archive bit) to 1 when a file
; is written to (changed). By checking this byte before retreiving the file
; size, we can pass back to dbase a parameter indicating whether or not the 
; file has been altered since the last back up procedure. 
;
; This eliminates unneccessary file copying. If the file has been altered
; we reset the archive bit to 0 to prepare for the NEXT back up procedure.
; The rest of the routine retreives the filesize by using DOS FUNCTION CALL
; 42H to move the record pointer to the end of the file.
;
; The filesize routine comes by way of Robert Jourdain's excellent book:
; "Programmer's Problem Solver"; 
;
; This routine passes back one of several different parameters:
; ERROR: first char of parameter = "*" --- Usually  'file not found'
; UNCHANGED: first char of parameter = "#"
; CHANGED: first char either "B" or "K", followed by filesize
; If first char = "B", filesize that follows is in BYTES
; If first char = "K", filesize that follows is in KBYTES and must be
; multiplied by 1024 to obtain bytes.
;
; SYNTAX:
;        LOAD FILESIZE
;        CALL FILESIZE WITH <PARM>
;        where PARM is a 12 character filename, padded with trailing blanks
;        if needed. EXAMPLE: i = "filesize.asm"  && 12 char, no blanks needed
;                            i = "dummy.prg   "  && 9 char, 3 blanks needed
;                            CALL FILESIZE WITH i
;
; See the accompanying BACKUP.PRG for full application.
;
; History: 10-10-86  Modified to work with Clipper
;
public          filesize
codeseg         segment byte
;
filesize        proc    far
                org     0h
assume          cs:codeseg,ds:codeseg
;
        push    ds
        push    es
;       mov     ds,dx                ;UNCOMMENT THIS LINE FOR CLIPPER
        push    bx                   ;save our parameter   
        xor     dx,dx                ;clear dx
        mov     dx,bx                ;put filename here
get_handle:
        mov     al,0                 ;get ready to read file
        mov     ah,3dh               ;get handle from dos 
        int     21h
        jc      error                ;error?
        mov     handle,ax            ;save the handle
check_archive_bit:
        mov     ah,43h
        mov     al,0                 ;get attribute byte
        int     21h
        jc      error
        cmp     cl,20h               ;has the file been modified?
        jz      bit_set 
bit_not_set:
        pop     bx                   ;file hasn't been changed
        mov     byte ptr [bx],"#"    ;return value to dbase
        jmp     finish
bit_set:                             ;file has been changed since last backup
        xor     cx,cx                ;normal file has archive set to 0
        mov     ah,43h
        mov     al,1                 ;reset the archive bit
        int     21h
;
get_size:                            ;get the filesize so we can back it up
        mov     bx,handle            ;put the file name here
        xor     cx,cx                ;store the results here
        xor     dx,dx                ;and here 
        mov     ah,42h               ;move pointer function          
        mov     al,2                 ;go to end of file
        int     21h
        jc      error
        mov     h_size,dx            ;store high byte here 
        mov     l_size,ax            ;store low byte here
        jmp     check_size
error:
        pop     bx                   ;something went wrong
        mov     byte ptr [bx],"*"    ;usually 'file not found'
        jmp     finish
;
check_size:
        mov     dx,h_size            ;get back the values we saved
        mov     ax,l_size
        cmp     dx,0                 ;is the highword empty?
        pop     bx                   ;get back our parameter
        jg      Kbytes               ;calculate in Kbytes, it's big enough
        mov     byte ptr [bx],'B'    ;signify bytes inst. of Kbytes
        jmp     Bytes

Kbytes:
        mov     byte ptr [bx],'K'
        mov     si,1024d             ;let's get it in "K"
        div     si
        xor     dx,dx                ;clear the remainder

Bytes:
        mov     cx,bx                ;convert number to an ASCII string
        add     bx,7                 ;we'll do it backwards
        mov     si,10                ;prepare to divide by 10
        inc     cx
nexdgt: div     si                   ;divide dx:ax by si
        or      dx,30H               ;convert remainder to ASCII digit
        dec     bx                   ;backup in string
        mov     [bx],dl              ;store character
        xor     dx,dx                ;clear remainder
        or      ax,ax                ;all done?
        jnz     nexdgt   
spaces:
        cmp     cx,bx                ;digits left?
        je      finish               ;no, finished
        dec     bx                   ;backup
        mov     byte ptr [bx],' '    ;put in a space
        jmp     spaces               ;check again
finish:
        push    bx
        mov     bx,handle            ;get our handle
        mov     ah,3eh               ;close the file
        int     21h
        pop     bx
        pop     es
        pop     ds
        ret
;
handle          dw      ?
h_size          dw      0
l_size          dw      0
;
filesize        endp
codeseg         ends
                end     

