;       FILEPATH utilities
;       
;       Author: Mark Richards
;               Nashua, NH
;               (603) 882-8052
;
;       These routines were thrown together in a hurry and do not
;       represent the finest in assembly programming!  However, they
;       work.
;
;       To use these utilities, assemble them with MASM and then
;       link the resulting OBJECT file into your application.
;


.model large
include extasm.inc      ; Clipper requirement

PUBLIC  log_drive       ; returns drive letter from PSP->Envblk
PUBLIC  log_dir         ; returns directory path from PSP->Envblk
PUBLIC  beedoop         ; tone. A little extra goody that emulates
                        ;  the two-tone "beedoop" that is used by
                        ;  Mutual Broadcasting for remote control
                        ;  purposes.  These two happened to be used
                        ;  at one time for signaling a commercial
                        ;  spot break.


.code

_MASTER   SEGMENT 'CODE'
        
        ASSUME  cs:_MASTER, ds:DGROUP

;
;       Function log_drive
;       Call with ()
;       Returns drive letter ("X:") where current exe process resides
;

log_drive  PROC    FAR

        push    bp
        mov     bp,sp
        push    si
        push    di
        push    ss
        push    ds      

        mov     ah,62h
        int     21h
        mov     ds,bx
        mov     di,2ch
        mov     ax,[di]
        mov     ds,ax
        mov     di,0            ; start at beginning
                
log_drive3:
        mov     ax,[di]         ; next character value for testing to ax
        push    ax              ; save value for test
        add     di,1
        pop     ax              ; restore value for test
        
        add     ah,al
        cmp     ah,01           ; is this our index point?
        jne     log_drive3         ; loop and test again
        

log_drive2:
        add     di,2
        
        mov     dx,ds
        mov     ax,di

        pop     ds              ; before the extend function call
        pop     ss

        mov     bx,2
        push    bx
        
        push    dx                 ; segment of string on stack
        push    ax                 ; offset of string on stack

        call    __retclen          ; return the drive letter and colon

        pop     ax      
        pop     dx
        pop     bx
        
        push    ss              ; restore after the extend call
        push    ds

        pop     ds      
        pop     ss
        pop     di
        pop     si
        pop     bp
        cld
        
        RET
log_drive  ENDP



;
;       Function log_dir
;       Call with ()
;       Returns path as \path\path... where current exe process resides
;       *excludes* the trailing backslash
;

log_dir PROC    FAR
        push    bp
        mov     bp,sp
        push    si
        push    di
        push    ax
        push    cx
        push    bx
        push    dx
        push    ss
        push    ds     

        mov     ah,62h
        int     21h
        mov     ds,bx
        mov     di,2ch
        mov     ax,[di]
        mov     ds,ax
        mov     di,0            ; start at beginning!
                
log_dir3:
        mov     ax,[di]         ; next character value for testing to ax
        push    ax              ; save value for test
        add     di,1
        pop     ax              ; restore value for test
        
        add     ah,al
        cmp     ah,01           ; is this our index point?
        jne     log_dir3        ; loop and test again
        

log_dir2:
        add     di,4            ; move past "X:" to the "\"
        
        ; get the length of this string by proceeding to the null at the end
        ; and working back to the "\" character.  This trims off the
        ; filename and leaves us with the directory path

        mov     cx,di           ; for later reference
        mov     bx,di
        
log_dir5:       ; loop to find the period
        
        mov     ax,[di]
        cmp     al,'.'
        je      log_dir4
        cmp     ah,'.'
        je      log_dir4
        add     di,1
        jmp     log_dir5

log_dir4:       ; end null found. Loop to work back to the last "\"
        mov     ax,[di]
        cmp     al,"\"
        je      log_dir6
        cmp     ah,"\"
        je      log_dir6
        sub     di,1
        jmp     log_dir4
        
log_dir6:       ; found backslash

        push    di      ; current location offset
        pop     ax      ; place it in ax
        sub     ax,bx   ; subtract previous offset to get length of string

        push    ax
        pop     bx      ; place length of string in bx

        mov     dx,ds           ; ds
        mov     ax,cx           ; di stored from above

        pop     ds              ; before the extend function call
        pop     ss

        push    bx              ; length of string to return
        
        push    dx              ; segment of string on stack
        push    ax              ; offset of string on stack

        call    __retclen          ; return the character

        add     sp,6
        
        push    ss              ; restore after the extend call
        push    ds

        pop     ds
        pop     ss
        pop     dx
        pop     bx
        pop     cx
        pop     ax
        pop     di
        pop     si
        pop     bp
        
        cld

        RET

log_dir ENDP

;------------------------------------------------------------------------------
;  BEEDOOP
;  Syntax: CALL BEEDOOP WITH <expL>
;  Effect: if <expL> is .F., nothing
;          if <expL> is .T., sound

beedoop proc    far
        mov     cx,1
        push    cx
        call    __parl
        pop     cx
        cmp     ax,0            ; tone off?
        jz      bdrtn           ; YES.

        call    set_mode
        mov     ax,4A6h         ;1336 hz
        call    outdiv
        mov     cx,3000h
        call    delays
        call    shutoff
        call    set_mode
        mov     ax,0A54h        ;941 hz (dial "0" for operator!)
        call    outdiv
        mov     cx,5000h
        call    delays
        call    shutoff
bdrtn:  
        call    __ret
        ret
beedoop endp


;
;       Near procedures for calls within the segment
;
;------------------------------------------------------------------------------
;  set_mode/outdiv/delays/shutoff
;  Direct speaker addressing.  Not called externally.

set_mode proc    near
        mov     al,0B6h
        out     43h,al
        ret
set_mode endp

outdiv  proc    near            ; outputs the divisor to the timer in AX
        out     42h,al
        mov     al,ah
        out     42h,al
        in      al,61h          ; read port 61h
        mov     ah,al           ; store to ah
        or      al,3
        out     61h,al
        ret
outdiv  endp

delays  proc    near            ;short delay (tone duration)
        nop                     ;inter-tone delay
        nop
        loop    delays          ; adjust for machine speed!
        ret
delays  endp

shutoff proc    near
        mov     al,ah           ;Restore port 61H
        out     61h,al          ;return to called program ok
        ret
shutoff endp


_MASTER ENDS
        END
        
