/***
*
*  This is a demo of the FileEval function.
*  (with a few other functions thrown in for good measure)
*
*  Note: this program will erase files in the current directory
*        if you choose them for erasure.
*
*
*  To create the demo program
*  1) clipper demo.prg /a/m/n/w
*  2) clipper fileeval.prg /a/m/n/w
*  3) rtlink fi demo, fileeval
*
*
*
*  Programed by:
*  Mike Rahilly
*
*  106 - 1750 Lawrence Ave. W.
*  North York, Ontario
*  Canada M6L 3C4
*  CompuServ ID 72427,2123
*
*  I don't guarantee that this program is good for anything
*  and don't blame me if it causes you grief.
*/


#include 'setcurs.ch'
#include 'inkey.ch'
#include 'box.ch'

PROCEDURE main
   local cOldScreen := savescreen()

   setblink(.f.)

   setkey(K_F1, {|| popmsg('Use the arrow keys to;'+;
                           'highlite the file you wish to delete;'+;
                           'and press the space bar to mark the file.;'+;
                           'the file will be deleted when you press the;'+;
                           'ENTER or ESC key.','w+/n*',space(8),10)})

   // set up fancy screen
   DBox(0,0,maxrow(),maxcol())
   DBox(2,2,15,21,,1)
   DBox(18,2,23,77,,1)
   dbox(2,33,12,76)
   dbox(3,35,11,74,,1)
   @ 6, 46 say 'F i l e   E v a l' color 'gr+/bg'
   @ 7, 45 say '' color 'n/bg'
   @ 1, maxcol()-12 say ' F1=Help ' color 'w+/n'
   @ 20, 24 say 'use the arrow keys and space bar' color 'w+/bg'
   @ 21, 24 say '    mark files for deletion' color 'w+/bg'


   // this is the function that does the work!
   FileEval({|file| ferase(file)},,3,3,12,'n/bg+,w+/b,,,n+/w')

   restscreen(,,,,cOldScreen)

/***
*
*  DBox(t, l, b, r, [cString], [in_out])
*
*  Draws a 3D box of color specified in cString
*  if in_out is 1 shading goes the opposite direction
*
*/
FUNCTION DBox(t,l,b,r,cString,in_out)
   local I, J
   local cOldColour
   local ltc := if(in_out <> 1,"W+","N")
   local brc := if(in_out <> 1, "N","W+")

   if t==nil.or.l==nil.or.b==nil.or.r==nil
      return .f.
   endif

   if cString==nil
      cString := 'bg+'
   endif

   dispbegin()
   cOldColour := setcolor(cString+'/'+cString)
   scroll(t,l,b,r)

   // do top and bottom

   for I = l+1 to r-1
      @ t, I say "" colour ltc+"/"+cString
      @ b, I say "" color brc+"/"+cString
   next I

   // do sides
   for I = t+1 to b-1
      @ I, l say "" colour ltc+"/"+cString
      @ I, r say "" colour brc+"/"+cString
   next I

   // do corners
   @ t, l say "" colour ltc+"/"+cString
   @ t, r say "" colour brc+"/"+cString
   @ b, l say "" colour ltc+"/"+cString
   @ b, r say "" colour brc+"/"+cString

   setcolor(cOldColour)
   dispend()
   return .t.


/***
*
*       Function: POPMSG()
*
*
*
*  function to put a message on the screen in a colour and wait for
*  a keypress.  Split message with ";".
*
*  popmsg("first line of text;Second line of text;etc.","w+/r" B_SINGLE )
*/
FUNCTION popmsg( cText, cColour, cBox, nInkey)
   local aMessage := {}
   local cOldColour := setcolor(if(cColour==NIL,"GR+/R",cColour))
   local cOldScreen := savescreen(0,0,maxrow(),maxcol())
   local cOldCursor := setcursor(SC_NONE)
   local I
   local nWidth := 0
   local nTop, nBottom, nLeft, nRight

   nInkey:=iif(nInkey == nil, 0, nInkey)
   cBox := if(cBox == NIL, B_DOUBLE, cBox)

   aMessage := parse(';',cText)
   aadd(aMessage,"")
   iif(nInkey == 0, aadd(aMessage, "Press any key to continue . . ."),)

   // find the longest line of the message
   for I = 1 to len(aMessage)
      nWidth := max( nWidth, len( aMessage[I] ) )
   next I

   // if too wide or tall change message to error message
   if nWidth + 4 > maxcol()+1 .or. len(aMessage)+4 > maxrow() + 1
      aMessage := { "message too big to fit" }
      nWidth := 25
   endif

   nTop := ( maxrow() /2) - ( len(aMessage) + 4) /2 + 1
   nLeft := (( maxcol() + 1) /2 ) - (nWidth / 2) -1
   nBottom := nTop + len(aMessage) + 3
   nRight := nLeft + nWidth + 3

   dispbox( nTop, nLeft, nBottom, nRight, cBox + space(1))

   for I = 1 to len(aMessage)
      @ nTop+1+I, nLeft + 2 say PADC( aMessage[I], nWidth )
   next I

   iif(nInkey == 0,beep(2),)
   inkey(nInkey)

   setcursor(cOldCursor)
   setcolor(cOldColour)
   restscreen(0,0,maxrow(),maxcol(),cOldScreen)

   return .t.

/***
*
*       Function: PARSE()
*
*
*
*  a function to parse a line into an array based on a delimeter
*
*  parse (";", "This is a;delimeter")
*/
FUNCTION parse(cDelimeter, cText)
   local aReturn := {}

   do while at(cDelimeter,cText) <> 0
      aadd(aReturn, substr(cText,1,at(cDelimeter,cText)-1))
      cText := substr(cText,at(cDelimeter,cText)+len(cDelimeter),;
         len(cText)-at(cDelimeter,cText)-len(cDelimeter)+1)
   enddo
   // add last remaining string or only string if there was no "cDelimeter"
   if len(cText) > 0
      aadd(aReturn,cText)
   endif

   return aReturn

/***
*
*       Function: BEEP()
*
*
*/
function beep(nChoice)

if(nChoice == NIL, nChoice := 1, nChoice)

   do case
   case nChoice == 2
      Tone(100, 3)

   case nChoice == 3
      Tone(300, 1)
      Tone(100, 1)
      Tone(300, 1)
      Tone(100, 1)

   otherwise
      Tone(300, 1)

   endcase

   return ( NIL )

