;-------------------------------------------------------------------------
; runfunc.asm -- quick functions to run other functions, just from
;	their pointers.
;-------------------------------------------------------------------------
; RCSid = "$Header: G\RCS\runfunc.asm 0.10 1992/04/07 04:47:43 holmesda Exp $";
;-------------------------------------------------------------------------
PARAM1_SEG		equ	12
PARAM1_OFF		equ	10
PARAM2_SEG		equ	16
PARAM2_OFF		equ	14
;-------------------------------------------------------------------------
$happy_segment		segment public
			assume cs:$happy_segment

			public	_runfunc1
			public	_runfunc2
;-------------------------------------------------------------------------
; function: runfunc1()
;
; description: runfun1() takes two double word pointers, the first is
;    a pointer to the function to run, and the second is the pointer
;    to pass to it.
;
; FORCE calling convention:
;
; FUNCTION LOGICAL runfunc1 PROTOTYPE
;    PARAMETERS VALUE LONG apply_function, VALUE LONG data_ptr
; ....
;    if .not. runfunc1( apply_function, data_ptr )
;       go_on = &FALSE
;    endif
; ....
;-------------------------------------------------------------------------
_runfunc1		proc	far
			push	bp
			mov	bp,sp
			push	es
			push	di

	; Grab the first parameter, and push it on the stack where it
	; should be when the function is called.
			mov	ax,ss:[bp + PARAM1_SEG]
			push	ax
			mov	ax,ss:[bp + PARAM1_OFF]
			push	ax

	; Load up ES:DI with the pointer the function.
			mov	ax,ss
			mov	es,ax
			mov	di,bp

	; Now call the function.  Whatever it returns will be returned
	; in DX:AX or just AX
			call	dword ptr es:[di + 6]
			add	sp,4

			pop	di
			pop	es
			pop	bp
			ret
_runfunc1		endp
;-------------------------------------------------------------------------
; function: runfunc2()
;
; description: runfunc2() is just like runfunc1() except that this time,
;    the function that it calls takes two pointers (such as a comparison
;    function).
;
; FORCE calling convention:
;
; FUNCTION INT runfunc2 PROTOTYPE
;   PARAMETERS VALUE LONG compare_function_ptr, ;
;              VALUE LONG data_ptr1, ;
;              VALUE LONG data_ptr2
;
; ...
;    if runfunc2( compare_function, data_ptr1, data_ptr2 ) > 0
;       go_on = &FALSE
;    endif
; ...
;-------------------------------------------------------------------------
_runfunc2		proc	far
			push	bp
			mov	bp,sp
			push	es
			push	di

	; Grab the data parameters, and then shove them back on the
	; stack where they should be when the function is called.
			mov	ax,ss:[bp + PARAM2_SEG]
			push	ax
			mov	ax,ss:[bp + PARAM2_OFF]
			push	ax
			mov	ax,ss:[bp + PARAM1_SEG]
			push	ax
			mov	ax,ss:[bp + PARAM1_OFF]
			push	ax

	; Load up ES:DI with the pointer to the function and then
	; call it.  It's return value will be in DX:AX or just
	; AX, so leave them alone when we get out.
			mov	ax,ss
			mov	es,ax
			mov	di,bp

			call	dword ptr es:[di + 6]
			add	sp,8

	runfunc2_out:	pop	di
			pop	es
			pop	bp
			ret
_runfunc2		endp
;-------------------------------------------------------------------------
$happy_segment		ends
;-------------------------------------------------------------------------
			end






