;-------------------------------------------------------------------------
; memcpy.asm -- memory copying functions for FORCE
;-------------------------------------------------------------------------
; RCSid = "$Header: G\RCS\memcpy.asm 0.10 1992/04/07 04:46:47 holmesda Exp $";
;-------------------------------------------------------------------------
$joy_seg		segment public
			assume cs:$joy_seg
;-------------------------------------------------------------------------
; function: charcpy()
;
; description: charcpy() is akin to C's strcpy().  It takes two addresses.
;    It assumes the first buffer is at least as long as the second, and
;    assumes the second is a NULL terminated character string.  charcpy()
;    returns its first argument.
;
; FORCE prototype:
;     FUNCTION LONG charcpy PROTOTYPE
;        PARAMETERS CHAR destination, CHAR source
;-------------------------------------------------------------------------
			public _charcpy
			public _memncpy
_charcpy		proc	far
			push	bp
			mov	bp,sp
			push	ds
			push	si
			push	es
			push	di

			mov	ax,ss:[bp + 8]	; dest segment
			mov	es,ax
			mov	ax,ss:[bp + 6]	; dest offset
			mov	di,ax

			mov	ax,ss:[bp + 12]	; source segment
			mov	ds,ax
			mov	ax,ss:[bp + 10]	; source offset
			mov	si,ax

			mov	cx,255

	cp_loop:	lodsb
			stosb
			and	al,al
			jz	found_null
			loop	cp_loop

	found_null:	pop	di
			pop	es
			pop	si
			pop	ds
			pop	bp
			ret
_charcpy		endp
;-------------------------------------------------------------------------
; function: memncpy()
;
; description: memncpy() takes two pointers, and copies the contents of
;   the second into the first for the given length.  memncpy() returns
;   its first argument.
;
; FORCE prototype:
;     FUNCTION LONG memncpy PROTOTYPE
;        VALUE LONG dest, VALUE LONG source, VALUE INT length
;-------------------------------------------------------------------------
_memncpy		proc	far
			push	bp
			mov	bp,sp
			push	es
			push	di
			push	ds
			push	si

	; Store the length in CX
			mov	cx,ss:[bp + 14]

	; Store the source string in DS:SI
			mov	ax,ss:[bp + 12]
			mov	ds,ax

			mov	ax,ss:[bp + 10]
			mov	si,ax

	; Store the destination string in ES:DI
			mov	ax,ss:[bp + 8]
			mov	es,ax
			mov	ax,ss:[bp + 6]
			mov	di,ax

	; Copy the source into the destination
			rep	movsb

	; Return the destination string

			mov	dx,ss:[bp + 8]
			mov	ax,ss:[bp + 6]

			pop	si
			pop	ds
			pop	di
			pop	es
			pop	bp
			ret
_memncpy		endp
;-------------------------------------------------------------------------
$joy_seg		ends
			end
;-------------------------------------------------------------------------
