*-------------------------------------------------------------------------
* i_pf.prg -- Quick little function to figure out filename paths....
*   It certainly could be better....
*-------------------------------------------------------------------------
#include database.hdr
#include string.hdr
#include fileio.hdr
#include system.hdr

#include i_pf.hdr
*-------------------------------------------------------------------------
DBFDEF file_info
   char(128)               filename
   char(128)               outname
   ulong(10)               filesize
ENDDEF
*-------------------------------------------------------------------------
VARDEF PRIVATE
   CHAR                 RCSid = "$Header: C:\TECH\FAQ\ALLOC\RCS\i_pf.prg 0.10 1992/04/07 04:13:07 holmesda Exp $"
   CHAR(128)            file_info_name
ENDDEF
*-------------------------------------------------------------------------
* function: process_filenames
*
* description: Boy, here's some boring code.  This function figures out
*    the input and output filenames for all the files on the command line,
*    and builds a database out of them.  If anyone knows of an easier way
*    to do this, let me know....
*
* The database is created according to the TEMP and TMP variables, in
*    that order.  This is nice if you have a RAMDRIVE...
*-------------------------------------------------------------------------
PROCEDURE process_filenames
   PARAMETERS CHAR(128)    cmd_line

   VARDEF
      CHAR(128)            temp
      CHAR(128)            inspec
      CHAR(128)            outspec
      INT                  i,j
      LOGICAL              go_on, append_slash
   ENDDEF

   *---
   * Figure out where the database of filenames & such should go, and
   * if it exists, erase it so it can be built anew.
   *--
   file_info_name = trim(getenv("TEMP"))
   if len( file_info_name ) = 0
      file_info_name = trim(getenv("TMP"))
   endif

   if len( file_info_name ) > 0
      if (substr(file_info_name,len(file_info_name),1) = "\")
         file_info_name = file_info_name + &DB_NAME
      else
         file_info_name = file_info_name + "\" + &DB_NAME
      endif
   else
      file_info_name = &DB_NAME
   endif

   if exist( file_info_name )
      erase file_info_name
   endif

   *---
   * Build the database from the stuff on the command line...
   *---
   build file_info_name from alias file_info
   open file_info_name alias file_info

   cmd_line = trim( lower(cmd_line) )

   i = 1
   do while substr( cmd_line, i, 1) <> " " .and. substr( cmd_line, i, 1) <> ""
      i = i + 1
   enddo
   inspec = substr( cmd_line, 1, i)
   outspec = substr( cmd_line, i+1, len( cmd_line) - len( inspec ) + 1)

   if len(outspec) = 0
      outspec = "."
   endif

   if .not. find_first( inspec, &FIND_ARCHIVE + &FIND_READONLY)
      ? "No files that match " + inspec
      quit
   endif
   *---
   * Now we have to find the length of the path...
   *---
   i = rat("\",inspec)
   if i = 0
      i = rat(":",inspec)
      if i = 0
         j = 2
         inspec = ".\"
         append_slash = .F.
      else
         j = i
      endif
      append_slash = .F.
   else
      j = i-1
      append_slash = .T.
   endif

   go_on = .T.
   do while go_on
      !file_info append blank
      if append_slash
         temp = substr( inspec, 1, j ) + "\" + find_fstr()
      else
         temp = substr( inspec, 1, j ) + find_fstr()
      endif

      !file_info replace file_info->filename with lower(temp)
      !file_info replace file_info->filesize with find_fsize()
      if len(outspec) = 2 .and. substr(outspec,2,1) = ":"
         temp = outspec + find_fstr()
      else
         temp = outspec + "\" + find_fstr()
      endif
      !file_info replace file_info->outname with lower(temp)
      go_on = find_next()
   enddo

   !file_info goto top

ENDPRO
*-------------------------------------------------------------------------
* The following functions make this module a "black box", oh, I mean
* an "encapsulating engine"....
*-------------------------------------------------------------------------
FUNCTION LOGICAL file_skip

   !file_info skip+1

   return .not. a_eof( file_info )

ENDPRO
*-------------------------------------------------------------------------
PROCEDURE file_close

   close file_info
   erase file_info_name

ENDPRO
*-------------------------------------------------------------------------
FUNCTION CHAR file_in_name

   return file_info->filename

ENDPRO
*-------------------------------------------------------------------------
FUNCTION CHAR file_out_name

   return file_info->outname

ENDPRO
*-------------------------------------------------------------------------
FUNCTION ULONG file_in_size

   return file_info->filesize

ENDPRO
*-- EOF: i_pf.prg --------------------------------------------------------



