*-------------------------------------------------------------------------
* htools.prg -- FORCE FAQ Heap toolkit
*
* The functions in this module and in htools2.prg are set up as
* "pointer dereferencers."  That means that their prototypes do
* not match their definitions (so don't include heap.hdr).
*
* To deference a pointer, you pass a VALUE LONG to some function, and
* then receive it as a LONG or a CHAR or something like that.
*-------------------------------------------------------------------------
#define HEAP_TOOLS
#include heap.hdr
*-------------------------------------------------------------------------
VARDEF PRIVATE
   CHAR                 RCSid = "$Header: G\RCS\htools.prg 0.10 1992/04/07 05:23:44 holmesda Exp $"
ENDDEF
*-------------------------------------------------------------------------
PROCEDURE set3_ptr PROTOTYPE
   PARAMETERS LONG dest_address, VALUE LONG ptr2ptr

PROCEDURE heap_set_long PROTOTYPE
   PARAMETERS VALUE LONG offset, VALUE LONG ptr

PROCEDURE heap_set_int PROTOTYPE
   PARAMETERS VALUE LONG offset, VALUE UINT ptr

FUNCTION LONG heap_get_long PROTOTYPE
   PARAMETERS VALUE LONG offset

FUNCTION UINT heap_get_int PROTOTYPE
   PARAMETERS VALUE LONG offset
*-------------------------------------------------------------------------
PROCEDURE heap_set_heap
   PARAMETERS VALUE LONG heap_header, VALUE LONG new_heap

   heap_set_long( heap_header + &HEAP_HEAP_OFFSET, new_heap )

ENDPRO
*-------------------------------------------------------------------------
PROCEDURE heap_set_size
   PARAMETERS VALUE LONG heap_header, VALUE UINT new_size

   heap_set_int( heap_header + &HEAP_SIZE_OFFSET, new_size )

ENDPRO
*-------------------------------------------------------------------------
PROCEDURE heap_set_nodes
   PARAMETERS VALUE LONG heap_header, VALUE UINT new_size

   heap_set_int( heap_header + &HEAP_NODES_OFFSET, new_size )

ENDPRO
*-------------------------------------------------------------------------
PROCEDURE heap_set_cmp
   PARAMETERS VALUE LONG heap_header, VALUE LONG cmp_ptr

   heap_set_long( heap_header + &HEAP_CMP_OFFSET, cmp_ptr )

ENDPRO
*-------------------------------------------------------------------------
FUNCTION LONG heap_get_heap
   PARAMETERS VALUE LONG heap_header

   return( heap_get_long( heap_header + &HEAP_HEAP_OFFSET ) )

ENDPRO
*-------------------------------------------------------------------------
FUNCTION INT heap_get_size
   PARAMETERS VALUE LONG heap_header

   return( heap_get_int( heap_header + &HEAP_SIZE_OFFSET ) )

ENDPRO
*-------------------------------------------------------------------------
FUNCTION INT heap_get_nodes
   PARAMETERS VALUE LONG heap_header

   return( heap_get_int( heap_header + &HEAP_NODES_OFFSET ) )

ENDPRO
*-------------------------------------------------------------------------
FUNCTION LONG heap_get_cmp
   PARAMETERS VALUE LONG heap_header

   return( heap_get_long( heap_header + &HEAP_CMP_OFFSET ) )

ENDPRO
*-------------------------------------------------------------------------
PROCEDURE swap_ptrs
   PARAMETERS LONG ptr1, LONG ptr2

   VARDEF
      LONG           temp
   ENDDEF

   temp = ptr2
   ptr2 = ptr1
   ptr1 = temp

ENDPRO
*-------------------------------------------------------------------------
PROCEDURE set2_ptr
   PARAMETERS LONG dest_address, LONG pointer2pointer

   set3_ptr( dest_address, pointer2pointer )

ENDPRO
*-------------------------------------------------------------------------
FUNCTION LONG heap_index
   PARAMETERS LONG address

   return address

ENDPRO
*-- EOF: htools.prg ------------------------------------------------------








