*-------------------------------------------------------------------------
* hinsert.prg -- FORCE FAQ Heap toolkit functions
*-------------------------------------------------------------------------
#include heap.hdr
*-------------------------------------------------------------------------
VARDEF PRIVATE
   CHAR                 RCSid = "$Header: G:\HEAP\RCS\hinsert.prg 0.10 1992/04/07 05:12:46 holmesda Exp holmesda $"
ENDDEF
*-------------------------------------------------------------------------
* function: heap_insert()
*
* description: heap_insert() adds a new pointer to the array.  If the
*   array is already full, it calls calloc() to get more memory.
*   If it can't get more memory, it returns FALSE, otherwise TRUE.
*-------------------------------------------------------------------------
FUNCTION LOGICAL heap_insert
   PARAMETERS LONG heap_header, VALUE LONG pointer

   VARDEF
      LONG              heap
      LONG              new_heap
      UINT              new_heap_size
      UINT              n_nodes
      UINT              heap_size
      INT               i
   ENDDEF

   if heap_header = 0
      return &FALSE
   endif

   n_nodes   = heap_get_nodes( heap_header )
   heap_size = heap_get_size( heap_header )
   *---
   * First, check to see if the array is full
   *---
   if n_nodes = heap_size
      heap = heap_get_heap( heap_header )
      new_heap_size = heap_size + &HEAP_INCREM
      heap_size = new_heap_size
      new_heap = kalloc( new_heap_size, &POINTER_SIZE )
      if new_heap = 0
         return &FALSE
      endif
      for i = 0 to n_nodes
         set2_ptr( new_heap + i * &POINTER_SIZE, heap + i * &POINTER_SIZE)
      next
      free( heap )
      heap = new_heap
      heap_set_heap( heap_header, heap )
      heap_set_size( heap_header, heap_size )
   endif

   heap_set_data( heap_header, n_nodes, pointer )
   n_nodes = n_nodes + 1
   heap_set_nodes( heap_header, n_nodes )

   return &TRUE
ENDPRO
*-- EOF: hinsert.prg -----------------------------------------------------

