*-------------------------------------------------------------------------
* heapdata.prg -- FORCE FAQ Heap toolkit functions
*-------------------------------------------------------------------------
#include heap.hdr
*-------------------------------------------------------------------------
VARDEF PRIVATE
   CHAR                 RCSid = "$Header: G\RCS\heapdata.prg 0.10 1992/04/07 05:03:11 holmesda Exp holmesda $"
ENDDEF
*-------------------------------------------------------------------------
PROCEDURE set3_ptr PROTOTYPE
   PARAMETERS VALUE LONG address, VALUE LONG ptr
*-------------------------------------------------------------------------
* function: heap_set_data()
*
* description: heap_set_data() sets up the values for set3_ptr.  We could
*    have let the user call set3_ptr() directly, but this way we can give
*    him a break and figure out the offset addresses for him.
*-------------------------------------------------------------------------
PROCEDURE heap_set_data
   PARAMETERS VALUE LONG heap_header, VALUE UINT _index, VALUE LONG data_ptr

   VARDEF
      LONG           heap
   ENDDEF

   heap = heap_get_heap( heap_header )
   set3_ptr( heap + _index * &POINTER_SIZE, data_ptr )

ENDPRO
*-------------------------------------------------------------------------
* function: heap_get_data()
*
* description: heap_get_data() is like heap_set_data() in that it doesn't
*    do much in itself, it just sets things up for heap_index().  However,
*    like heap_set_data(), it makes your code a little cleaner by figuring
*    out the offset addresses for you.
*-------------------------------------------------------------------------
FUNCTION LONG heap_get_data
   PARAMETERS VALUE LONG heap_header, VALUE UINT _index

   VARDEF
      LONG           heap
   ENDDEF

   heap = heap_get_heap( heap_header )
   return heap_index( heap + _index * &POINTER_SIZE )

ENDPRO
*-- EOF: heapdata.prg  ---------------------------------------------------






