*-------------------------------------------------------------------------
* heap_destroy.prg -- FORCE FAQ HEAP toolkit function
*-------------------------------------------------------------------------
#include heap.hdr
*-------------------------------------------------------------------------
VARDEF PRIVATE
   CHAR                 RCSid = "$Header: G\RCS\hdestroy.prg 0.10 1992/04/07 04:57:19 holmesda Exp $"
ENDDEF
*-------------------------------------------------------------------------
* function: heap_destroy()
*
* description: heap_destroy() free()'s all the memory associated with
*    the heap, including the data if the Kill_Data boolean is TRUE.
*-------------------------------------------------------------------------
PROCEDURE heap_destroy
   PARAMETERS VALUE LONG heap_header, VALUE LOGICAL kill_data

   VARDEF
      INT               i
      INT               n_nodes
      LONG              heap
      LONG              data_ptr
   ENDDEF

   n_nodes = heap_get_nodes( heap_header + &HEAP_NODES_OFFSET )
   heap    = heap_get_heap( heap_header + &HEAP_NODES_OFFSET )

   if kill_data
      for i = 0 to n_nodes
         data_ptr = heap_get_data( heap_header, i )
         if (data_ptr > 1024)    && check pointer to be sure it's not NULL
            free( data_ptr )
         endif
      next
   endif

ENDPRO
*-- EOF: hdestroy.prg ----------------------------------------------------
