*-------------------------------------------------------------------------
* heap_apply.prg -- applies a function to the heap
*-------------------------------------------------------------------------
#define HEAP_APPLY_PRG
#include heap.hdr
*-------------------------------------------------------------------------
VARDEF PRIVATE
   CHAR                 RCSid = "$Header: G\RCS\happly.prg 0.10 1992/04/07 04:49:28 holmesda Exp $"
ENDDEF
*-------------------------------------------------------------------------
* function: heap_apply()
*
* description: heap_apply() applies a given function to each node of the
*    heap.  The function should be of a LOGICAL return type, because as
*    soon as the function returns something other than &TRUE, heap_apply()
*    will terminate.  If this never happens, heap_apply() will apply the
*    function to all the nodes and return TRUE itself.
*-------------------------------------------------------------------------
FUNCTION LOGICAL heap_apply
   PARAMETERS VALUE LONG heap_header, VALUE LONG funcptr

   VARDEF
      LOGICAL           success
      INT               n_nodes
      INT               i
      LONG              data_ptr

   ENDDEF

   n_nodes = heap_get_nodes( heap_header )

   success = &TRUE
   for i = 0 to n_nodes-1
      data_ptr = heap_get_data( heap_header, i )
      if .not. runfunc1( funcptr, data_ptr )
         success = &FALSE
         exit
      endif
   next

   return success

ENDPRO
*-- EOF: -----------------------------------------------------------------

