*-------------------------------------------------------------------------
* fsort.prg -- FORCE FAQ example code for ALLOC.HDR
*
* This utility is a string sorter which takes filesnames as arguments,
* or if there are no filenames, it reads from stdin.
*
* Usage:
*
*    Fsort filespec        -- where filespec may contain wildcards
*     or
*    command | Fsort
*     or
*    Fsort < filespec      -- where filespec may not contain wildcards
*-------------------------------------------------------------------------
#include io.hdr
#include fileio.hdr
#include i_pf.hdr
#include string.hdr
#include system.hdr
#include alloc.hdr
*-------------------------------------------------------------------------
#define TRUE         .t.
#define FALSE        .f.
#define FTEMP_NAME    "_fsort.tmp"
*-------------------------------------------------------------------------
PROCEDURE strsort PROTOTYPE
   PARAMETERS CONST CHAR filename

PROCEDURE append_files PROTOTYPE
   PARAMETERS VALUE UINT in_handle, VALUE UINT out_handle, VALUE LONG buffer
*-------------------------------------------------------------------------
VARDEF PRIVATE
   CHAR                 RCSid = "$Header: C:\TECH\FAQ\ALLOC\RCS\fsort.prg 0.10 1992/04/07 04:11:08 holmesda Exp $"
ENDDEF

VARDEF
   LONG                 buffer         && here's our memory buffer pointer
   UINT                 buf_size       &&    and it's size
   UINT                 fb_in
   UINT                 fb_out
   ULONG                fb_in_size
   CHAR(25)             infilename
   CHAR(25)             outfilename
ENDDEF
*-------------------------------------------------------------------------
PROCEDURE force_main
   PARAMETERS CHAR(128) command_line

   VARDEF
      INT               f_handle          && intput file handle
      INT               fo_handle         && output file handle
      CHAR(128)         temp_name
      LOGICAL           go_on
      UINT              mem_avail,i
   ENDDEF

   *---
   * First, we allocate some memory for a file read buffer
   *---

   mem_avail = mavail()
   i = mem_avail / ( &PAGESIZE * 2 )
   buf_size = i * &PAGESIZE
   buffer = kalloc( i, &PAGESIZE )
   do while buffer = 0 .and. i > 0
      i = i / 2
      buf_size = i * &PAGESIZE
      buffer = kalloc( i, &PAGESIZE )
   enddo
   if i = 0
      ? "Error: Cannot allocate memory for a read buffer."
      quit
   endif

   scrn_dos()
   *---
   * Now we figure out if we should read from files or from standard input
   *---
   if len( command_line ) > 1
      if trim( command_line ) = "/?"
         ? "Fsort by holmesda: revision " + substr(RCSid,at("fsort.prg",RCSid),at("1992",RCSid)-at("fsort.prg",RCSid))
         ?
         ? "    Fsort filespec        -- where filespec may contain wildcards"
         ? "     or"
         ? "    command | Fsort"
         ? "     or"
         ? "    Fsort < filespec      -- where filespec may not contain wildcards"
         ?
         ? "Example:"
         ?
         ? " type c:\autoexec.bat | fsort | more "
         quit
      endif
      process_filenames( command_line )
      f_handle = -1              && Just for the moment...
   else
      f_handle = &STD_IN
   endif

   *---
   * Here's the first loop, where we iterate by file name, or just
   * once if we're reading from STD_IN.  We read in all the files,
   * saving them in one file, which we'll use later to sort.  Of
   * course, we could start saving the strings now, but I don't feel
   * like doing the string parsing over read buffers.
   *---
   * First, we open the temporary file according to the TEMP and
   * TMP environment variables (nice if you have a ramdrive)
   *---
   temp_name = trim(getenv("TEMP"))
   if len( temp_name ) = 0
      temp_name = trim(getenv("TMP"))
   endif

   if len( temp_name ) > 0
      if (substr(temp_name,len(temp_name),1) = "\")
         temp_name = temp_name + &FTEMP_NAME
      else
         temp_name = temp_name + "\" + &FTEMP_NAME
      endif
   else
      temp_name = &FTEMP_NAME
   endif

   if exist( temp_name )
      erase temp_name
   endif

   if .not. fb_open( fo_handle, temp_name, &B_CREAD_WRITE )
      ? "fsort: Cannot open temp file: " + temp_name
      quit
   endif

   *---
   * Here's where we read all the files and then write them into
   * one big file.
   *---

   go_on = .T.
   do while go_on
      if f_handle = &STD_IN
         go_on = &FALSE
      else
         if .not. fb_open( f_handle, file_in_name(), &B_READ )
            clear
            ? "fsort: Cannot open" + file_in_name()
            quit
         endif
      endif

      append_files( f_handle, fo_handle, buffer )

      if f_handle <> &STD_IN
         go_on = file_skip()        && skip to the next filename
      endif
   enddo

   if f_handle <> &STD_IN
      file_close()
   endif

   fb_close( fo_handle )
   free( buffer )
   *---
   * Okay, now we have one big file called &FTEMP_NAME that has
   * all the files in it.  Pass the name to strsort, and let him
   * deal with it.
   *---

   strsort( temp_name )

ENDPRO
*-- EOF:  fsort.prg  -----------------------------------------------------

