;-------------------------------------------------------------------------
; alloc.asm -- Formalizing FORCE's allocation routines.
;-------------------------------------------------------------------------
; RCSid = "$Header: G\RCS\alloc.asm 0.12 1992/04/10 08:40:39 holmesda Exp holmesda $";
;-------------------------------------------------------------------------
			public		_mavail
			public		_alloc
			public		_kalloc

			extrn		_$allocate:far
;-------------------------------------------------------------------------
SAFETY_FACTOR		equ	320d	; Always leave this many paragraphs
;-------------------------------------------------------------------------
_ALLOC_SEGMENT		segment word public
			assume cs:_ALLOC_SEGMENT
;-------------------------------------------------------------------------
; function: mavail()
;
; description: mavail() returns the number of free memory bytes.
;-------------------------------------------------------------------------
_mavail			proc	far

			mov	ah,5
			call	far ptr _$allocate
			mov	ax,cx		; put cx in ax
			mov	cx,16		; convert to bytes
			mul	cx

			ret
_mavail			endp
;-------------------------------------------------------------------------
; function: allocate()
;
; description: This function is a replacement for FORCE's alloc
;    function.  It checks free memory first, and if there isn't enough
;    to supply to the user, returns NULL.
;-------------------------------------------------------------------------
mem_avail		equ	[bp - 4]	; Available memory in paras
req_mem_p		equ	[bp - 6]	; requested memory in paras
;-------------------------------------------------------------------------
_alloc			proc	far
			push	bp
			mov	bp,sp

	; Here's some of my code -- dwh
	;	Get the free memory, adjust it,
	;	and store it on the local stack
			mov	ah,5
			call	_$allocate
			sub	cx,SAFETY_FACTOR
			mov	mem_avail,cx

	; Now we move back to Dave's code

			xor	ax,ax
			mov	cx,[bp + 6]

			shr	cx,1		;convert bytes to paragraphs
			rcl	ax,1		;keep track of extra bytes
						; ( request % 16 > 0? )
			shr	cx,1
			rcl	ax,1
			shr	cx,1
			rcl	ax,1
			shr	cx,1
			rcl	ax,1

			or	ax,ax
			 jz	just_allo
	just_allo:	inc	cx		;need 16 bytes to store handle

	; Here starts my code -- dwh
	;	Then compare the requested memory with the
	;	adjusted available memory, and abort if there
	;	is not enough memory.
						; cx has the requested mem
			mov	ax,mem_avail	; ax has the available mem
			cmp	cx,ax
			ja	not_mem

	; Back to Dave's Code
			mov	ah,1		; Allocate static
			call	_$allocate	;returns memory in DX:AX

		;---return in DX:AX

			mov	ax,bx
			jmp	_alloc_out

	not_mem:	xor	ax,ax
			xor	dx,dx

	_alloc_out:
			pop	bp
			ret

_alloc			endp
;-------------------------------------------------------------------------
; function: kalloc()
;
; description: kalloc() is to calloc() what alloc() is to malloc().
;    It simply checks free memory before allocating an array of memory.
;
; FORCE prototype:
;
; FUNCTION LONG kalloc PROTOTYPE
;    PARAMETERS VALUE UINT n_elements, VALUE UINT sizeof_element
;
; For those of you who don't know what calloc() does, it returns a pointer
;    to a newly allocated and zero'd memory block large enough to hold
;    n_elements, each of size sizeof_element
;-------------------------------------------------------------------------
ptr_seg			equ	[bp -  8]	; Segment of allocated mem
ptr_off			equ	[bp - 10]	; Offset of allocated mem
;-------------------------------------------------------------------------
_kalloc			proc	far
			push	bp
			mov	bp,sp
			push	es
			push	di

	; First we figure out the size of the array, and then we call
	; alloc() and let it worry about the free memory, simple as that.

			mov	ax,[bp + 6]	; get the number of elems
			mov	bx,[bp + 8]	;    and their size
			xor	dx,dx
			mul	bx		; multiply 'em

			and	dx,dx		; make sure it's < 2^16
			jnz	_kalloc_no_mem

			push	ax
			call	far ptr _alloc
			pop	cx	; get back the requested bytes

			or	dx,dx	; if we got back a NULL, return
			jz	_kalloc_no_mem

	; Now we have to zero out all the memory, so hop to it.
			mov	ptr_seg, dx
			mov	ptr_off, ax

			mov	es,dx
			mov	di,ax
			xor	ax,ax
			shr	cx,1		; divide by 2 cause we'll zero words
			jnc	all_words
			stosb
	all_words:	rep	stosw		; zero the memory

			mov	dx,ptr_seg	; restore the return
			mov	ax,ptr_off	; ptr in DX:AX
			jmp	_kalloc_out

	_kalloc_no_mem:	xor	dx,dx
			xor	ax,ax

	_kalloc_out:	pop	di
			pop	es
			pop	bp
			ret
_kalloc			endp
;-------------------------------------------------------------------------
_ALLOC_SEGMENT		ends
			end
;-- EOF: alloc.asm -------------------------------------------------------



