*-------------------------------------------------------------------------
* strsort.prg -- FORCE FAQ example code for ALLOC.HDR
*
* This module shows how you can use the FAQ HEAP toolkit to maintain
* an array of pointers to character strings.  Notice the way that we
* allocate memory that is exactly the size of the string (plus one for
* the NULL terminus) so that no memory is wasted.
*-------------------------------------------------------------------------
#include io.hdr
#include fileio.hdr
#include string.hdr

#include heap.hdr

#pragma W_FUNC_PROC-
#pragma W_INDIRECT-
*-------------------------------------------------------------------------
VARDEF PRIVATE
   CHAR                 RCSid = "$Header: C:\TECH\FAQ\ALLOC\RCS\strsort.prg 0.10 1992/04/07 04:15:11 holmesda Exp $"
   INT                  rb_pos = 0
ENDDEF

VARDEF EXTERN
   LONG                 buffer            && the read buffer
   UINT                 buf_size          &&    and its size
ENDDEF
*-------------------------------------------------------------------------
* function: charcmp()
*
* description: The heap toolkit requires that we pass in a pointer to
*    a comparison function so that when heap_sort() is called, it may
*    use this function to order the heap.
*
* Note: All comparison functions passed to the heap toolkit must take
*    two pointers, and return -1 if the first evalutes to less than
*    the second, 1 if it is greater, or 0 if the two are equal.
*-------------------------------------------------------------------------
FUNCTION INT charcmp
   PARAMETERS CHAR str1, CHAR str2

   if str1 > str2
      return 1
   endif

   if str1 < str2
      return -1
   endif

   return 0

ENDPRO
*-------------------------------------------------------------------------
* function:  print_string()
*
* description:  This function will be called by the heap_apply() function,
*    and will print each node in the heap.
*
* Note: Any function passed to heap_apply() must take 1 and only 1 pointer
* as an argument, and must return a LOGICAL.  If the function returns a
* .F., heap_apply() will terminate at that node.
*-------------------------------------------------------------------------
FUNCTION LOGICAL print_string
   PARAMETERS CHAR string

   ? string
   return &TRUE

ENDPRO
*-------------------------------------------------------------------------
* function: str_sort()
*
* description: str_sort() uses a non-contrained heap to store an array
*    of pointers to strings.  For each string it reads from the temp file,
*    it makes a duplicate of it with malloc() and charcpy(), and stores
*    the copy in the heap with heap_insert().  When it has all the strings,
*    it calles heap_sort() to sort the strings, and finally heap_apply()
*    to print them.
*-------------------------------------------------------------------------
PROCEDURE strsort
   PARAMETERS CHAR filename

   VARDEF
      FILE           file_in
      LONG           heap_header
      UINT           bytes_read
      CHAR           line
      LONG           new_ptr
   ENDDEF

   if .not. f_open( file_in, filename, &F_READ )
      ? "fsort: Cannot open temp file " + filename
      quit
   endif

   *---
   * Get a pointer to a new heap header structure.
   *---
   heap_header = heap_create( charcmp )

   *---
   * Read in the entire file as a series of strings, and store
   * the pointers to each string in the heap.
   *---
   do while .not. f_eof( file_in )
      f_getln( file_in, line )
      if f_eof( file_in )
         loop
      endif
      if len( line ) + &SAFETY_FACTOR > mavail()
         ? "fsort: Out of memory"
         heap_destroy( heap_header, &TRUE )
         quit
      endif
  *---
  * Here's the tricky part.  We have to make a duplicate of the
  * string and then save that duplicate instead of the original.
  * We allocate just enough memory to hold the string, and then
  * call charcpy() to copy the string into the newly allocated
  * memory.  Then let heap_insert() take care of it.
  *---
      new_ptr = alloc( len(line) + 1 )      && + 1 for NULL terminus
      charcpy( new_ptr, line )
      if .not. heap_insert( heap_header, new_ptr )
         ? "fsort: Out of memory"
         heap_destroy( heap_header, &TRUE )
         quit
      endif
   enddo
   f_close( file_in )

   heap_sort( heap_header )
   heap_apply( heap_header, print_string )
   heap_destroy( heap_header, &TRUE )

   erase filename

ENDPRO
*-- EOF: -----------------------------------------------------------------





