*-------------------------------------------------------------------------
* iCopy.prg -- FORCE FAQ example code for ALLOC.HDR
*
* This utility is the beginning of a file copy utility that uses an
* indicator to show the progression of the copy.  It uses FORCE's
* calloc() function to allocate memory for a copy buffer.  It reads
* data from one file into the copy buffer, and then writes the copy
* buffer to the second file.
*
* Usage:
*
* icopy filespec [destination]   -- where filespec may contain wildcards,
*                                -- and [destination] must be a directory.
* if [destination] does not exist, "." is assumed.
*-------------------------------------------------------------------------
#include io.hdr
#include string.hdr
#include fileio.hdr
*-------------------------------------------------------------------------
#include i_pf.hdr
#include alloc.hdr
*-------------------------------------------------------------------------
VARDEF
   CHAR                 RCSid = "$Header: G:\SAMPLE\RCS\icopy.prg 0.11 1992/04/07 04:06:59 holmesda Exp holmesda $"
   LONG                 buffer
   UINT                 buf_size
   UINT                 fb_in
   UINT                 fb_out
   ULONG                fb_in_size
   CHAR(25)             infilename
   CHAR(25)             outfilename
ENDDEF
*-------------------------------------------------------------------------
PROCEDURE icopy_file PROTOTYPE
   PARAMETERS VALUE LONG
*-------------------------------------------------------------------------
PROCEDURE force_main
   PARAMETERS CHAR(128) command_line

   VARDEF
      LOGICAL              go_on
      LONG                 i
      LONG                 mem_avail
   ENDDEF

   scrn_dos()

   *---
   * Print out a nice header, and if there are no arguments, the usage.
   *---
   ? "iCopy by holmesda, revision: " + substr(RCSid,at("icopy.prg",RCSid),at("1992",RCSid)-at("icopy.prg",RCSid))
   if len( command_line ) = 0
      ?
      ? "iCopy usage:"
      ?
      ? "iCopy filespec [destination]"
      ?
      ? "    -filespec can include wildcards, but cannot simply be a directory"
      ? "         as in the DOS COPY."
      ? "    -If [destination] is omitted, the current directory is assumed."
      ? "    -[destination], if it exists, must be a directory."
      quit
   endif

   process_filenames( command_line )

   *---
   * Allocate the memory buffer using kalloc().  PAGESIZE should be the
   * size of a DISK PAGE (or allocation unit) for optimum performance
   *---
   mem_avail = mavail() - &SAFETY_FACTOR
   i = mem_avail / ( &PAGESIZE * 2 )
   buf_size = i * &PAGESIZE
   buffer = kalloc( i, &PAGESIZE )
   do while buffer = 0 .and. i > 0
      i = i / 2
      buf_size = i * &PAGESIZE
      buffer = kalloc( i, &PAGESIZE )
   enddo
   if i = 0
      ? "Cannot allocate memory for a read buffer.  Quitting."
      quit
   endif
   i = buf_size / 1000
   if i = 0
      i = 1
   endif
   ?? " Read buffer size: " + i_str(i) + "k"
   ?

   *---
   * Now we skip through the database of file specs provided by the
   * process_filenames() function.  For each file, we open it and it's
   * destination counterpart, and call iCopy_file() to handle the rest
   *---
   go_on = .T.
   do while go_on
      infilename  = file_in_name()
      outfilename = file_out_name()
      fb_in_size  = file_in_size()

      if .not. fb_open( fb_in, file_in_name(), &B_READ )
         ? "Cannot open " + file_in_name()
         free( buffer )
         quit
      endif
      if .not. fb_open( fb_out, file_out_name(), &B_CWRITE )
         ? "Cannot open " + file_out_name()
         free( buffer )
         quit
      endif

      icopy_file( buffer )

      fb_close( fb_in )
      fb_close( fb_out )
      go_on = file_skip()
   enddo

   file_close()
   free( buffer )

ENDPRO
*-- EOF: icopy.prg ---------------------------------------------------------











