*-------------------------------------------------------------------------
* heap_sort.prg -- Sort the heap by its compare function
*-------------------------------------------------------------------------
#include heap.hdr
*-------------------------------------------------------------------------
VARDEF PRIVATE
   CHAR                 RCSid = "$Header: G:\HEAP\RCS\hsort.prg 0.10 1992/04/07 05:17:57 holmesda Exp holmesda $"
   LONG                 compare
ENDDEF
*-------------------------------------------------------------------------
* function: qs_sort()
*
* description: performs a quick sort on an array of strings.  The only
*    problem with it is that we can't reference the array as an array,
*    so we'll have to deal with the offsets by hand.
*-------------------------------------------------------------------------
PROCEDURE qs_sort
   PARAMETERS VALUE LONG heap, VALUE UINT lo, VALUE UINT hi

   VARDEF
      UINT              i,j,xi
      LONG              ptr_x             && ptr_? are pointers
      LONG              ptr_y
      LONG              ptr_a
      LOGICAL           go_on
   ENDDEF

   i  = lo
   j  = hi
   xi = (lo + hi) / 2
   ptr_x = heap_index( heap + xi * &POINTER_SIZE )

   go_on = &TRUE
   do while go_on
      do while &TRUE
         ptr_a = heap_index( heap + i * &POINTER_SIZE )
         if runfunc2( compare, ptr_a, ptr_x ) < 0
            i = i + 1
         else
            exit
         endif
      enddo

      do while &TRUE
         ptr_a = heap_index( heap + j * &POINTER_SIZE )
         if runfunc2( compare, ptr_x, ptr_a ) < 0
            j = j - 1
         else
            exit
         endif
      enddo

      if i <= j
         swap_ptrs( heap + i * &POINTER_SIZE, heap + j * &POINTER_SIZE )
         i = i + 1
         j = j - 1
      endif

      if (i > j)
         go_on = .F.
      endif
   enddo

   if lo < j
      qs_sort( heap, lo, j)
   endif

   if i < hi
      qs_sort( heap, i, hi )
   endif

ENDPRO
*-------------------------------------------------------------------------
* function: heap_sort()
*
* description: heap_sort() just sets things up for qs_sort(), which
*    performs a quick sort on the heap.  Last I heard, quick_sort()
*    was the fastest sorting algorithm developed.
*-------------------------------------------------------------------------
PROCEDURE heap_sort
   PARAMETERS VALUE LONG heap_header

   VARDEF
      INT            n_nodes
      LONG           heap
   ENDDEF

   heap    = heap_get_heap( heap_header )
   n_nodes = heap_get_nodes( heap_header )
   compare = heap_get_cmp( heap_header )
   if compare <> 0
      qs_sort( heap, 0, n_nodes-1 )
   endif

ENDPRO
*-- EOF: hsort.prg -------------------------------------------------------





