;-------------------------------------------------------------------------
; hash.asm -- FORCE FAQ Sample Code -- A_Exmpl1.zip
;-------------------------------------------------------------------------
		dosseg

		public	_hash

_code		segment word public 'CODE'
		assume cs:_code
;-------------------------------------------------------------------------
; Here's a hash function that takes a NULL terminated string and
; adds all the characters in the string together, and mods by the
; given word.
;-------------------------------------------------------------------------
_hash		proc	far
		push	bp		; set up our stack ref
		mov	bp,sp
		push	ds		; save the segment registers
		push	si

		mov	ax,word ptr ss:[ bp+8 ]	; grab the string's segment
		mov	ds,ax
		mov	ax,word ptr ss:[ bp+6 ]	; grab the string's offset
		mov	si,ax
		mov	dx,word ptr ss:[ bp+10] ; grab the hashvalue

		and	dx,dx
		jnz	_no_div_by_0
		mov	dx,1

	; Instead of relying on faith that the string will be NULL
	; terminated, we'll set CX to be 255, the longest FORCE string.

  _no_div_by_0:	mov	cx,0ffh

	; accumulate the hash value in bx for the moment
		xor	bx,bx
		xor	ax,ax	; clear out AH

  _hash_loop:	lodsb
		and	al,al
		jz	_found_null
		add	bx,ax
		loop	_hash_loop

  _found_null:	mov	ax,bx	; perform a modulus with an idiv: remainder
  		mov	cx,dx	
  		cwd		; is stored in DX
  		idiv	cx

		mov	ax,dx

		pop	si
		pop	ds
		pop	bp
		ret
_hash 		endp
;-------------------------------------------------------------------------
_code		ends

		end
