*-------------------------------------------------------------------------
* test.prg -- Test function for alloc.hdr
*-------------------------------------------------------------------------
#include io.hdr
#include string.hdr
#include alloc.hdr
*-------------------------------------------------------------------------
VARDEF
   CHAR                 RCSid = "$Header:$"
   ULONG                ptr
   ULONG                mem_allocated
   ULONG                avail_mem
ENDDEF
*-------------------------------------------------------------------------
PROCEDURE test_kalloc

   @3,10 ?? "* * * Testing kalloc() * * *"

   do while ptr <> 0
      ptr = kalloc( 5, 200 )      && +16 for handle is 1000
      @ 8,30 ?? ptr
      avail_mem = mavail()
      mem_allocated = mem_allocated + 1000 + 16
      @ 9,30 ?? avail_mem
      @ 10,30 ?? mem_allocated
   enddo
   @12,1 ?? "mavail() says: ",mavail()

ENDPRO
*-------------------------------------------------------------------------
PROCEDURE force_main
   PARAMETERS CHAR(128) cmd_line

   clear

   avail_mem = mavail()
   mem_allocated = 0
   @5,1 ?? "Available memory:", avail_mem
   @6,1 ?? "Allocating until not enough left"
   @8,1 ?? "Ptr:"
   @9,1 ?? "Available memory:"
   @10,1 ?? "Allocated memory:"
   ptr = 1
   if trim( cmd_line ) = "/k"
      test_kalloc()
      quit
   endif
   @3,10 ?? "* * * Testing alloc() * * *"

   do while ptr <> 0
      ptr = alloc( 984 )      && +16 for handle is 1000
      @ 8,30 ?? ptr
      avail_mem = mavail()
      mem_allocated = mem_allocated + 1000
      @ 9,30 ?? avail_mem
      @ 10,30 ?? mem_allocated
   enddo
   @12,1 ?? "mavail() says: ",mavail()

ENDPRO
*-- EOF: -----------------------------------------------------------------




