/*-------------------------------------------------------------------*/
/* mosh.c -- sample C code to show how to receive arrays from Force  */
/*-------------------------------------------------------------------*/
/*
** this function simply divides each element of the array by 2 and
** then adds one to it, and puts it back in the array.
**
** if you follow through the code with a low-level debugger, you find
** that Force allocates the entire array from the stack segment, but
** correctly passes the stack segment as the segment half of the
** pointer the array.
**
** remember, you must use the Large C model when you link with Force,
** because otherwise the C code won't be expecting a segment:offset
** type address, and will corrupt your stack when it tries to return.
**
*/
void mosh(int *array)
{
   int            j;

   for (j = 0; j < 10; j++)
      array[j] = (array[j] >> 1) + 1;
}


