*-------------------------------------------------------------------------
* hcreate.prg -- FORCE FAQ heap toolkit
*-------------------------------------------------------------------------
#define HEAP_CREATE_PRG
#include heap.hdr
*-------------------------------------------------------------------------
VARDEF PRIVATE
   CHAR                 RCSid = "$Header: G:\HEAP\RCS\hcreate.prg 0.10 1992/04/07 04:54:33 holmesda Exp holmesda $"
ENDDEF
*-------------------------------------------------------------------------
* function: heap_create()
*
* description: heap_create() allocates space for a heap, and a structure
*    around that heap.  Think of it as an example of how to fake
*    structures in FORCE.  Its not pretty, but it works.
*-------------------------------------------------------------------------
FUNCTION LONG heap_create
   PARAMETERS VALUE LONG compare_function

   VARDEF
      LONG           heap_header
      LONG           heap
   ENDDEF

   if &HEAP_INCREM * &POINTER_SIZE + &SAFETY_FACTOR > mavail()
      return &NULL
   endif

   heap_header    = alloc( &HEAP_HEADER_SIZE )
   heap           = kalloc( &HEAP_INCREM, &POINTER_SIZE )
   heap_set_heap( heap_header, heap )
   heap_set_size( heap_header, 0 )
   heap_set_nodes( heap_header, 0)
   heap_set_cmp( heap_header, compare_function )

   return heap_header

ENDPRO
*-- EOF: -----------------------------------------------------------------



