*-------------------------------------------------------------------------
* copyfile.prg -- FORCE FAQ example code for ALLOC.HDR
*
* This module contains the two functions icopy_file() and append_files().
*
* iCopy_file() is an example of when you might want to use an allocated
* buffer instead of a BYTE array.
*
* Append_files() is basically the same example, but is much more general
* in its usage.  It has no indicator like Icopy_file() does.  In fact,
* it has no screen output at all.
*
* iCopy_file() is called from the module iCopy.prg, and Append_files()
* is called by the module Fsort.prg.
*-------------------------------------------------------------------------
#include fileio.hdr
#include io.hdr

#include i_pf.hdr
#pragma W_FUNC_PROC-
*-------------------------------------------------------------------------
VARDEF PRIVATE
   CHAR                 RCSid = "$Header: C:\TECH\FAQ\ALLOC\RCS\copyfile.prg 0.10 1992/04/07 04:17:07 holmesda Exp $"
ENDDEF

VARDEF EXTERN
   LONG                 buffer
   UINT                 buf_size
   UINT                 fb_in
   UINT                 fb_out
   ULONG                fb_in_size
   CHAR(25)             infilename
   CHAR(25)             outfilename
ENDDEF
*-------------------------------------------------------------------------
* function: icopy_file
*
* description: icopy_file() does the actual copying.  If the program
*     gets this far, it's been able to open the files, so that the
*     global file handles fb_in and fb_out are set, and the copy buffer]
*     has been allocated.
*
* Note the clever way that we fool FORCE into taking an allocated memory
*     address as a byte array (actually, a byte address) through the
*     use of mismatching prototypes.
*-------------------------------------------------------------------------
PROCEDURE icopy_file
   PARAMETERS BYTE copy_buffer      && remember, this is just an address!

   vardef
      uint                    temp_size
      ulong                   total_bytes
      uint                    bytes_read
      uint                    i
      ulong                   increm
   enddef

   @ row(),1 ?? infilename
   @ row(),30 ?? "-> " + outfilename
   @ row(),55 ??" "
   @ row(),col() - 10

   increm = fb_in_size / 10L
   total_bytes = 0

   do while .not. fb_eof( fb_in )
      bytes_read = fb_read( fb_in, copy_buffer, buf_size)
      total_bytes = total_bytes + bytes_read
      if bytes_read > 0
         fb_write( fb_out, copy_buffer, bytes_read )
      endif
      if (total_bytes > increm)
         for i = 1 to total_bytes / increm
            ?? ""
         next
         total_bytes = total_bytes % increm
      endif
   enddo

   @ row(),col()-10 ?? "... done   "
   ?

ENDPRO
*-------------------------------------------------------------------------
* function: append_files()
*
* description: append_files() takes two file handles, the first an input,
*    the second an output, and a BYTE address that points to a memory
*    buffer.  append_files() reads BUF_SIZE bytes from the first file
*    and then writes them to the second handle.
*-------------------------------------------------------------------------
PROCEDURE append_files
   PARAMETERS VALUE UINT in_handle, ;
              VALUE UINT out_handle, ;
                    BYTE copy_buffer

   VARDEF
      INT               bytes_read
   ENDDEF

   do while .not. fb_eof( in_handle )
      bytes_read = fb_read( in_handle, copy_buffer, buf_size )
      if bytes_read > 0
         fb_write( out_handle, copy_buffer, bytes_read )
      endif
   enddo

ENDPRO
*-- EOF: copyfile.prg ----------------------------------------------------



