#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

FUNCTION Test()
	LOCAL oEdit := ARRAY(4)
	LOCAL cText := ARRAY(4)
	LOCAL nKey := 0
	LOCAL np := 1
	LOCAL cBlock
	LOCAL nLineNum
	LOCAL GetList := {}

	cText[1] := "This is a window with ::wordWrap ON"
	oEdit[1] := FastEdit():New(5, 1, 10, 20, "W+/B", cText[1])
	oEdit[1]:insert := .T.
	oEdit[1]:goBottom()
	oEdit[1]:bColorBlock := {|nCode, nColor| DoIt(nCode, nColor) }
	oEdit[1]:addCode("")
	oEdit[1]:addCode("")

	oEdit[2] := FastEdit():New(3, 25, 15, 78, "W/R", cText[2], .F.,,.F.)
	oEdit[2]:readText("sample.txt")
	oEdit[2]:nLine := 5
	oEdit[2]:nRow := 4
	oEdit[2]:lAutoBlock := .F.
	oEdit[2]:bColorBlock := {|nCode, nColor| DoIt(nCode, nColor) }
	oEdit[2]:addCode("{BOLD}")
	oEdit[2]:addCode("{UNDERLINE}")

	cText[3] := "This window is like a rectangular GET.  <RETURN> will exit"
	oEdit[3] := FastEdit():New(12, 1, 14, 20, "G/RB", cText[3], .T.)
	oEdit[3]:bColorBlock := {|nCode, nColor| DoIt(nCode, nColor) }

	cText[4] := "This window is read only..."+CHR(13)+"and has two lines"
	oEdit[4] := FastEdit():New(21, 0, 22, 10, "W+/G", cText[4], .F.,, .F.)
	oEdit[4]:readOnly := .T.

	DISPBEGIN()

	CLEAR SCREEN


	// display a box around one of the edit windows
	DISPBOX(2, 24, 16, 79, B_SINGLE, "W/R")

	// stabilize ALL the edit windows
	oEdit[1]:stabilize()
	oEdit[2]:stabilize()
	oEdit[3]:stabilize()
	oEdit[4]:stabilize()


	@ MAXROW(), 2 SAY "F10: Next Window   ALT-M: Mark Text   ALT-G: Copy Text   ALT-I: Insert Text"

	DISPEND()

	DO WHILE nKey != K_ESC
		// stabilize current edit window -- NOT incremental!
		oEdit[np]:stabilize()

		SETCURSOR(IF(oEdit[np]:insert, SC_INSERT, SC_NORMAL))

		// wait for keystroke
		nKey := INKEY(0)


		DO CASE
		CASE nKey == K_ALT_F1
			oEdit[np]:textColor("W+/G")
		CASE nKey == K_ALT_L
			nLineNum := 1
			@ 24,0 SAY "Line:" GET nLineNum
			READ
			oEdit[np]:gotoLine(nLineNum)
		CASE nKey == 397	// ctrl-up
			oEdit[np]:panUp()
		CASE nKey == 401	// ctrl-down
			oEdit[np]:panDown()
		CASE nKey == 127
			oEdit[np]:delWord()
		CASE nKey == K_ALT_I
			// insert marked block
			IF cBlock != NIL
				oEdit[np]:putChar(cBlock, .T.)
			ENDIF
		CASE nKey == K_ALT_G
			// store marked block and turn block mode off
			cBlock := oEdit[np]:blockGet()
			oEdit[np]:blockOff()
		CASE nKey == K_ALT_M
			// toggle block mode
			IF oEdit[np]:lBlockOn
				oEdit[np]:blockOff()
			ELSE
				IF np == 2
					oEdit[2]:blockOn({oEdit[2]:nLine, 1})
				ELSE
					oEdit[np]:blockOn()
				ENDIF
			ENDIF
		CASE nKey == K_ALT_W
			oEdit[np]:writeText("rktest")
		CASE nKey == K_F10
			np++
			IF np > LEN(oEdit)
				np := 1
			ENDIF
		CASE nKey == K_ESC
		CASE nKey == K_ENTER .AND. oEdit[np]:rectGet
			// in a rectangular GET, <return> exits
			nKey := K_ESC
		CASE nKey == K_ALT_1
			oEdit[np]:putCode(1)
		CASE nKey == K_ALT_2
			oEdit[np]:putCode(2)
		CASE nKey == K_ALT_3
			oEdit[np]:putCode(3)
		CASE nKey == K_ALT_B
			oEdit[np]:putCode(1)
		OTHERWISE
			oEdit[np]:defaultKey(nKey)
		ENDCASE
		IF oEdit[2]:lBlockOn
			oEdit[2]:blockOn(,{oEdit[2]:nLine, oEdit[2]:nLineLen})
		ENDIF
//		oEdit[2]:readOnly := oEdit[2]:nLine < 5
		IF oEdit[2]:nLine < 5
			oEdit[2]:nRow := 4
			oEdit[2]:nLine := 5
			oEdit[2]:refreshAll := .T.
		ENDIF

	ENDDO

	CLEAR SCREEN
	? "Contents of current buffer:"
	?
	? oEdit[np]:getText()

	RETURN (NIL)


FUNCTION DoIt(nCode, nColor)

	DO CASE
	CASE nCode == 1
		nColor := "W/B"
	CASE nCode == 2
		nColor := "W+/B"
	CASE nCode == 3
		nColor := "W+/R"
	ENDCASE

	RETURN nColor


