#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

FUNCTION Test()
	LOCAL cText

	SET SCOREBOARD OFF

	cText := WordPerf(0, 0, MAXROW(), MAXCOL(), "W/B")
	CLEAR SCREEN

	RETURN .T.


FUNCTION WordPerf(nTop, nLeft, nBottom, nRight, cColor, cFile)
	LOCAL oEdit := ARRAY(4)
	LOCAL nKey := 0
	LOCAL lQuit := .F.
	LOCAL cSaveColor
	LOCAL cSaveScr
	LOCAL nHome := 0
	LOCAL i
	LOCAL nRepeat := 1
	LOCAL lDone := .F.
	LOCAL cBlock := ""
	LOCAL nChoice

	// draw screen
	cSaveScr := SAVESCREEN(nTop, nLeft, nBottom, nRight)
	cSaveColor := SETCOLOR(cColor)
	SCROLL(nTop, nLeft, nBottom, nRight, 0)


	oEdit[1] := NewEdit(nTop, nLeft, nBottom-1, nRight, cColor, cFile)
	oEdit[1]:insert := .T.

	DO WHILE !lQuit

		DISPBEGIN()

		SETCURSOR(SC_NONE)
		@ nBottom, 0
		@ nBottom, MAXCOL()-15 SAY "Line "+LTRIM(STR(oEdit[1]:nLine))+ ;
		  "  Pos "+LTRIM(STR(oEdit[1]:nCol))

		// stabilize current edit window -- NOT incremental!
		oEdit[1]:stabilize()

		SETCURSOR(IF(oEdit[1]:insert, SC_INSERT, SC_NORMAL))
		DISPEND()

		// wait for keystroke
		nKey := INKEY(0)

		nHome := IF(nHome == 3, 0, nHome)
		DO CASE
		CASE nHome == 1
			nHome := 3
			DO CASE
			CASE nKey == K_HOME
				nHome := 2
			CASE nKey == K_DOWN
				oEdit[1]:down(oEdit:nBottom - oEdit:nTop - oEdit:nRow)
			CASE nKey == K_UP
				oEdit[1]:up(oEdit[1]:nRow)
			CASE nKey == K_LEFT
				oEdit[1]:home()
			CASE nKey == K_RIGHT
				oEdit[1]:end()
			OTHERWISE
				nHome := 0
			ENDCASE

		CASE nHome == 2
			nHome := 3
			DO CASE
			CASE nKey == K_DOWN
				oEdit[1]:goBottom()
			CASE nKey == K_UP
				oEdit[1]:goTop()
			OTHERWISE
				nHome := 0
			ENDCASE
		ENDCASE

		IF nHome == 0
			IF nKey == K_ESC
				nRepeat := MsgNum("Repeat Value = ", oEdit[1]:nBottom+1, "99", "8", @nKey)
			ENDIF
			lDone := .F.
			i := 1
			DO WHILE i <= nRepeat .AND. !lDone
				DO CASE
				CASE nKey >= 32 .AND. nKey <= 122
					oEdit[1]:putChar(nKey)
				CASE nKey == K_LEFT
					oEdit[1]:moveLeft()
				CASE nKey == K_RIGHT
					oEdit[1]:moveRight()
				CASE nKey == K_UP
					oEdit[1]:up()
				CASE nKey == K_DOWN
					oEdit[1]:down()
				CASE nKey == K_DEL
					oEdit[1]:delChar()
				CASE nKey == K_PGUP
					oEdit[1]:pageUp()
				CASE nKey == K_PGDN
					oEdit[1]:pageDown()
				CASE nKey == K_F10
					lDone := .T.
					cFile := MsgChar("Document to be saved:", oEdit[1]:nBottom + 1, cFile)
					oEdit[1]:writeText(cFile)
				CASE nKey == K_SH_F10
					lDone := .T.
					cFile := MsgChar("Document to be retrieved:", oEdit[1]:nBottom + 1)
					IF FILE(cFile)
						oEdit[1] := NewEdit(nTop, nLeft, nBottom-1, nRight, cColor)
						oEdit[1]:readText(cFile)
						oEdit[1]:wrap()	// force word-wrap of entire text
					ENDIF
				CASE nKey == K_HOME
					lDone := .T.
					nHome := 1 
				CASE nKey == K_F7
					lDone := .T.
					IF MsgYN("Save document?", oEdit[1]:nBottom + 1, .T.)
						IF EMPTY(cFile)
							cFile := MsgChar("Document to be saved:", oEdit[1]:nBottom + 1)
						ENDIF
						oEdit[1]:writeText(cFile)
					ENDIF
					lQuit := MsgYN("Quit WP?", oEdit[1]:nBottom + 1, .F.)
					IF !lQuit
						oEdit[1] := NewEdit(nTop, nLeft, nBottom-1, nRight, cColor)
					ENDIF

				CASE nKey == 127	// ctrl-backspace
					oEdit[1]:wordLeft()
					oEdit[1]:delWord()
				CASE nKey == K_BS
					oEdit[1]:backspace()
				CASE nKey == K_INS
					lDone := .T.
					oEdit[1]:insert := !oEdit[1]:insert
				CASE nKey == K_END
					oEdit[1]:end()
				CASE nKey == K_HOME
					nHome++
				CASE nKey == K_ALT_D
					oEdit[1]:delLine()
				CASE nKey == K_ALT_I
					oEdit[1]:home()
					oEdit[1]:insLine()
				CASE nKey == K_CTRL_LEFT
					oEdit[1]:wordLeft()
				CASE nKey == K_CTRL_RIGHT
					oEdit[1]:wordRight()
				CASE nKey == K_CTRL_END
					oEdit[1]:delRest()
				CASE nKey == K_ALT_B
					oEdit[1]:putColor(2)
					oEdit[1]:putColor(1)
					oEdit[1]:moveLeft()
				CASE nKey == K_ALT_F4
					IF oEdit[1]:lBlockOn
						oEdit[1]:blockOff()
					ELSE
						oEdit[1]:blockOn()
					ENDIF
				CASE nKey == K_CTRL_F4 .AND. !EMPTY(cBlock)
					nChoice := WPMenu(oEdit[1]:nBottom + 1,{"Move", "Copy", "Delete", "Append"})
					oEdit[1]:lBlockOn := .F.
					DO CASE
					CASE nChoice == 1
						cBlock := oEdit[1]:blockGet()
						oEdit[1]:blockDel()
					CASE nChoice == 2
						cBlock := oEdit[1]:blockGet()
						Paste(oEdit[1], cBlock)
					CASE nChoice == 3
						oEdit[1]:blockDel()
					CASE nChoice == 4
						cBlock += oEdit[1]:blockGet()
					ENDCASE
					oEdit[1]:blockOff()


				OTHERWISE
					oEdit[1]:putChar(nKey)
				ENDCASE

				i++
			ENDDO
			nRepeat := 1
		ENDIF

	ENDDO


	SETCOLOR(cSaveColor)
	RESTSCREEN(nTop, nLeft, nBottom, nRight, cSaveScr)

	RETURN oEdit[1]:getText()


STATIC FUNCTION Paste(oEdit, cText)
	LOCAL nKey := 0
	DO WHILE nKey != K_ENTER
		// stabilize current edit window -- NOT incremental!
		oEdit:stabilize()

		nKey := INKEY(0)
		IF nKey != K_ENTER
			oEdit:defaultKey(nKey)
		ENDIF
	ENDDO
	oEdit:putChar(cText, .T.)

	RETURN (NIL)


STATIC FUNCTION MsgChar(cMsg, nRow, cDefault)
	LOCAL GetList := {}
	LOCAL cSaveScr

	cDefault := IF(cDefault == NIL, SPACE(35), PADR(cDefault, 35))

	cSaveScr := SAVESCREEN(nRow, 0, nRow, MAXCOL())
	@ nRow, 0 SAY cMsg COLOR "W+/B" GET cDefault PICTURE "@K"
	READ

	RESTSCREEN(nRow, 0, nRow, MAXCOL(), cSaveScr)

	RETURN cDefault


STATIC FUNCTION MsgYN(cMsg, nRow, lResponse)
	LOCAL GetList := {}
	LOCAL cSaveScr

	lResponse := IF(lResponse == NIL, .F., lResponse)

	cSaveScr := SAVESCREEN(nRow, 0, nRow, MAXCOL())
	@ nRow, 0 SAY cMsg COLOR "W+/B" GET lResponse PICTURE "Y"
	READ

	RESTSCREEN(nRow, 0, nRow, MAXCOL(), cSaveScr)

	RETURN lResponse


STATIC FUNCTION WPMenu(nRow, aMenu)
	LOCAL nChoice := 1
	LOCAL GetList := {}
	LOCAL i
	LOCAL nPos := 0
	LOCAL cSaveScr

	cSaveScr := SAVESCREEN(nRow, 0, nRow, MAXCOL())

	FOR i := 1 TO LEN(aMenu)
		@ nRow, nPos SAY STR(i, 1) + " " + LEFT(aMenu[i], 1) COLOR "W+/B"
		@ nRow, nPos+3 SAY SUBSTR(aMenu[i], 2) + IF(i != LEN(aMenu), "; ", ":") COLOR "W/B"
		nPos += LEN(aMenu[i])+4
	NEXT
	@ nRow, nPos GET nChoice PICTURE "9" VALID (nChoice > 0 .AND. nChoice <= LEN(aMenu))
	READ


	RESTSCREEN(nRow, 0, nRow, MAXCOL(), cSaveScr)

	RETURN nChoice


STATIC FUNCTION MsgNum(cMsg, nRow, cPicture, cDefault, nKey)
	LOCAL cSaveScr
	LOCAL cKey
	LOCAL cNum := ""

	cSaveScr := SAVESCREEN(nRow, 0, nRow, MAXCOL())

	@ nRow, 0 SAY cMsg+" "+cDefault COLOR "W+/B"
	SETPOS(nRow, LEN(cMsg)+1)
	nKey := INKEY(0)
	cKey := CHR(nKey)
	DO WHILE (cKey >= '0' .AND. cKey <= '9') .OR. nKey == K_BS
		IF nKey == K_BS
			cNum := IF(cNum == "", "", LEFT(cNum, LEN(cNum)-1))
		ELSE
			cNum += cKey
		ENDIF
		@ nRow, LEN(cMsg)
		@ nRow, LEN(cMsg)+1 SAY cNum
		nKey := INKEY(0)
		cKey := CHR(nKey)
	ENDDO

	RESTSCREEN(nRow, 0, nRow, MAXCOL(), cSaveScr)
	
	IF nKey == K_F1 .OR. nKey == K_F7 .OR. nKey == K_ESC
		cNum := "0"
	ENDIF

	RETURN IF(cNum == "", VAL(cDefault), VAL(cNum))

FUNCTION ColorChg(nCode, nColor)
	DO CASE
	CASE nCode == 1
		RETURN "W/B"
	CASE nCode == 2
		RETURN "W+/B"
	ENDCASE

	RETURN nColor

FUNCTION NewEdit( nTop, nLeft, nBottom, nRight, cColor, cFile )
	LOCAL oEdit := ARRAY(4)

	oEdit[1] := FastEdit():New(nTop, nLeft, nBottom, nRight, cColor)
	IF FILE(cFile)
		oEdit[1]:readText(cFile)
	ENDIF
	oEdit[1]:bColorBlock := {|nCode, nColor| ColorChg(nCode, nColor) }
	oEdit[1]:nTabSize := 5
	oEdit[1]:wordWrap := .T.
	oEdit[1]:wrap()	// force word-wrap of entire text


	RETURN oEdit[1]
