*****************************************************************************
*              Copyright 1989, Financial Dynamics, Inc.                     *
*                                                                           *
*                      (703) 671 - 3003                                                     *
*****************************************************************************

*  PICKS.PRG
PARA top_row,left_col,bot_row,right_col

*  vars defined in calling prg:
*   mtitle
*   wtitle
*   wfields

PRIVATE firstrow, ;  &&  starting row
        mquit , ;    &&  Logical Quit/ not Quit
        keypress,;   &&  ASCII of key pressed
        mloop   ,;   &&  Logical Loop/ not Loop
        lastrow ,;   &&  last row displayed in browse
        mchoice ,;
        cur_row,;      &&  current row of cursor
        last_col,;
        white,;
        selected

DO set_browse

* see if any GROUP is specified:
IF TYPE([M->group_key]) = [U]
   group_key = []
ENDIF
IF TYPE([M->group]) = [U]
   group  = IF(EMPTY(M->Group_key), [], &group_key)
ENDIF

key_field = IF(TYPE([M->key_field])=[U], INDEXKEY(0), M->key_field)

*  Screen 
CO_PUSH()
CO_CHG(0,c_frame)
DRAWSHADOW(top_row,left_col,bot_row,right_col)
CO_CHG(c_window,c_frame)
@ top_row,left_col,bot_row,right_col BOX stdbox
SCROLL(top_row+1,left_col+1,bot_row-1,right_col-1,0)
CO_CHG(curr_grp,c_sayget)
IF ! EMPTY(mtitle)
   mtitle = [ ]+TRIM(LTRIM(mtitle))+[ ]
   xcol = left_col + (((right_col-left_col) - LEN(mtitle)) / 2)
   CO_CHG(curr_grp,c_title)
   @ top_row,xcol SAY mtitle
ENDIF
CO_CHG(curr_grp,c_text)
wprompt       = IF(TYPE([wprompt])=[U],'Press letter to list from, [Enter] to select/unselect record. [Esc] when done',wprompt)
@ 24,0
@ 24,0 SAY wprompt

*  Ready to go 
CURS_OFF()
SET MESSAGE TO
firstrow = top_row+3

white     = .F.
mquit     = .F.
mrepl_ok  = .T.
DO WHIL ! Mquit
    CO_CHG(curr_grp,c_text)
    @ top_row+2,left_col+3 SAY wtitle

    DO list_em
    white = .F.
    mloop = .T.
    DO WHIL mloop
        IF ! M->white
           DO rev_line
        ENDIF

        SET CONS OFF
        WAIT []
        SET CONS ON
        keypress = LASTKEY()
        mchoice = UPPER(CHR(keypress))

        IF keypress =  13
           IF TYPE([selected]) = [C]  &&  there is a field
              IF rec_lock(5)
                 REPL selected WITH IIF(EMPTY(selected), CHR(2), [ ])
                 UNLOCK
              ENDIF
           ELSE
              * no "selected" field, so add to a temporary database
              * DO pick_record  && see below
           ENDIF
           DO rev_line
           @ cur_row,left_col+4 SAY &wfields
           LOOP
        ENDIF

        IF ! CURSORKEY(keypress) .AND. ! ESC()
           IF ! EMPTY(INDEXKEY(0))
              PRIV mrec
              mrec = RECNO()
              SET SOFTSEEK ON
              SEEK UPPER(CHR(LASTKEY()))
              SET SOFTSEEK OFF
              IF EOF()
                 GOTO mrec
                 LOOP
              ENDIF
              mloop = .F.
              LOOP
           ENDIF
        ENDIF

        DO rev_line
        DO cursor
        * @ cur_row,left_col+4 SAY &wfields
    ENDDO
ENDDO
CO_POP()
CURS_ON()
RETURN
***  Eof:  PICKS.prg

PROC pick_record
  * Called from picks, when there is no "selected" field to replace
  * Assumes the user has already opened a PICKS alias, with the field RECNO

  PRIVATE oldarea, picked_rec
  picked_rec = RECNO()

  SELE picks
  LOCA FOR recno = M->picked_rec
  IF FOUND()
     DELE
  ELSE
     APPEN BLANK
     REPLA recno WITH M->picked_rec
  ENDIF

  SELE (oldarea)
RETURN