*****************************************************************************
*              Copyright 1989, Financial Dynamics, Inc.                     *
*                                                                           *
*                      (703) 671 - 3003                                                     *
*****************************************************************************


*  GLOBAL replace and delete, Multi or single user

FUNC global_repl     && global Replace
   PARA var,;        && Variable to test and replace with
        dbf,;        && target database
        t_fld,;      && target field
        use_index,;  && Which Index Order?  - 0 = no index
        ask          && ask whether to change key field
   PRIV oldkey,newkey,not_open,oldarea

   IF ADDING()
      RETU .F.
   ENDIF
   use_index = IF(TYPE([use_index])=[N],use_index,0)
   ask       = IF(TYPE([ask])=[U],.F.,ask)
   oldkey    = &var
   newkey    = M->&var
   IF M->&var <> M->oldkey
       oldarea  = SELECT()
       mquit    = .F.
      IF M->ask
         YES_NO([Change key field? (Y/N)])
      ELSE
         myn = [Y]
      ENDIF
      mquit = myn=[N]
      IF myn = [Y]
         @ 24,0
         @ 24,0 SAY [Please wait.  Updating related files ...]
         not_open  = SELE(dbf) = 0  && it was not already open
         IF not_open
            SELE 0
            DO &dbf
         ELSE
            SELE &dbf
         ENDIF
         oldord = INDEXORD()
         IF use_index = 0  && Do not use index
            SET ORDE TO 0
            IF FIL_LOCK(10)
               REPL &t_fld WITH M->newkey FOR &t_fld = M->oldkey
               UNLOCK
            ENDIF
         ELSE
            SET ORDE TO (use_index)
            SEEK oldkey
            DO WHILE FOUND()
               IF REC_LOCK(20)
                  REPL &t_fld WITH M->newkey
                  UNLOCK
               ENDIF
               SEEK oldkey
            ENDDO
         ENDIF
         SET ORDE TO oldord
         IF not_open
            USE   && close it
         ENDIF
      ENDIF  &&  myn = [Y]
      SELE (oldarea)
   ENDIF     &&  M->&var <> oldkey
RETU ! mquit

* 
FUNC chk_dele
   PARA var,;      &&  variable to find
        dbf,;      &&  database to look in
        t_field,;  &&  target field
        use_index  &&  Which Index Order?  - 0 = no index
   multchk = IF(TYPE([multchk])=[U],.F.,multchk)
   IF multchk
      mret = .T.
   ELSE
      PRIV malias,;
           mret, not_open

      malias    = ALIAS()
      use_index = IF(TYPE([use_index])=[N],use_index,0)
      not_open  = SELE(dbf) = 0  && it was already open

      IF not_open
         SELE 0
         DO &dbf
      ELSE
         SELE &dbf
      ENDIF
      oldord = INDEXORD()
      IF use_index = 0  && Do not use index
         SET ORDE TO 0
         LOCATE FOR &t_field = &malias.->&var
      ELSE
         SET ORDE TO (use_index)
         SEEK &malias.->&var
      ENDIF
      mret = (FOUND())
      SET ORDE TO oldord

      IF not_open
         USE
      ENDIF

      SELE &malias
   ENDIF
   multchk = mret
RETU mret
