*****************************************************************************
*              Copyright 1989, Financial Dynamics, Inc.                     *
*                                                                           *
*                      (703) 671 - 3003                                                     *
*****************************************************************************

*  Errorsys.prg  Clipper error trapping programs

* 
FUNC print_error
   PARA name, line
   ERRCOLORS([push])
   PRIV err_choice,mscreen,ret_val,etype
   SET DEVI TO SCRE
   SET CONS ON
   SET PRINT OFF
   * ----- BEEP/BOXX/SAY the error
   DO errorbeep
   SAVE SCRE TO mscreen
   DO WHIL ! ISPRINTER()
      BOXX(2,2,[Printer Error - Please Correct - Any Key Continues...])
      DO kbhit
      IF ESC()
         DO breakout
      ENDIF
   ENDDO
   REST SCRE FROM mscreen
   SET DEVI TO PRINT
   SET PRINT ON
   ERRCOLORS([pop])
RETU .T.

* 
FUNC undef_error
   PARA name, line, info, model, _1
   PRIVATE etype,mscreen
   ERRCOLORS([push])
   etype = PROCNAME()
   DO errorwrite
   * ----- BEEP/BOXX/SAY the error
   DO errorbeep
   SAVE SCREEN TO mscreen
   BOXX(2,2,PROCNAME() + [ Proc ] + M->name + [ line ] + LTRIM(STR(M->line)) +[, ] + M->info + [: ] + _1)
   INKEY(0)
   ERRCOLORS([pop])
   DO breakout
RETU .F.

* 
FUNC db_error
   PARA name, line, info
   ERRCOLORS([push])
   PRIV err_choice,mscreen,ret_val,etype,mfield,i,highnum
   etype = PROCNAME()
   mfield = []
   IF [numeric overflow] $ LOWER(info)
       PRIV fname[FCOUNT()],;
            ftype[FCOUNT()],;
            fwide[FCOUNT()],;
            fdec[FCOUNT()]
       AFIELDS(fname,ftype,fwide,fdec)
       FOR i = 1 TO FCOUNT()
          mfield = fname[i]
          IF ftype[i] <> [N]
             LOOP
          ENDIF
          highnum = REPL([9],fwide[i]-IF(fdec[i]=0,0,fdec[i]+1))
          IF fdec[i]=0
             highnum =highnum + [.] + REPL([9],fdec[i])
          ENDIF
          IF &mfield > VAL(highnum)
             EXIT
          ENDIF
       NEXT
       i=i-1
   ENDIF

   _1 = mfield
   DO errorwrite

   * ----- BEEP/BOXX/SAY the error
   DO errorbeep
   SAVE SCREEN TO mscreen
   BOXX(2,2,PROCNAME() + [ Proc ] + M->name + [ line ] + LTRIM(STR(M->line)) +[, ] + M->info + [, Field=] + IF(!EMPTY(_1),_1,[]))
   INKEY(0)
   ERRCOLORS([pop])
   DO breakout
RETU .F.

* 
FUNC open_error
   PARA name, line, info, model, _1
   PRIV err_choice,mscreen,ret_val,_5,etype
   etype = PROCNAME()

   * ----- Record the error in the error database
   M->_5 = [DOSERROR ] + STR(DOSERROR(),1,0)
   IF DOSERROR() = 4  && already too many files open, close to write to disk
      IF yes_no( [Too many files open. Invoke Debugger ?] )
         ALTD()
      ENDIF
      CLOSE DATA
   ELSEIF DOSERROR() = 5
      *DO errorwrite
      *DO kbhit WITH [File in use exclusively by another station ?]
      *ALTD()
      RETU(.f.)           && caused by attempting to use a file that is
   ENDIF                  && used exclusively by another station
   DO errorwrite

   * ----- BEEP/BOXX/SAY the error
   DO errorbeep
   SAVE SCREEN TO mscreen
   ERRCOLORS([push])
   BOXX(2,2,PROCNAME() + [ Proc ] + M->name + [ line ] + LTRIM(STR(M->line)) +[, ]+ M->info +[, ]+ M->model,;
                         M->_1 + [ (] + LTRIM(M->_5) + [)])
   INKEY(0)
   ERRCOLORS([pop])
   DO breakout
RETU .F.

* 
FUNC expr_error
   PARA name, line, info, model, _1, _2, _3
   ERRCOLORS([push])
   PRIV err_choice,mscreen,ret_val,etype
   etype = PROCNAME()

   * ----- Record the error in the error database
   DO errorwrite

   * ----- BEEP/BOXX/SAY the error
   DO errorbeep
   SAVE SCREEN TO mscreen
   BOXX(2,2,PROCNAME() + [ Proc ] + M->name + [ line ] + LTRIM(STR(M->line)) +[, ]+ M->info,;
           IF(DEFINED([M->_1]),CVAL(M->_1),[])+IF(DEFINED([M->_2]),+[   and   ]+CVAL(M->_2),[])+IF(DEFINED([M->_3]),+[   and   ]+CVAL(M->_3),[]))
   INKEY(0)
   ERRCOLORS([pop])
   DO breakout
RETU .F.


* 
FUNC misc_error
   PARA name,line,info,model
   ERRCOLORS([push])
   PRIV xchoice,malias,mscreen,etype
   etype = PROCNAME()
   IF LOWER(info) = [run error]
      _5 = [DOSERROR ] + STR(DOSERROR(),1,0)
   ENDIF

   * ----- Record the error in the error database
   DO errorwrite

   * ----- BEEP/BOXX/SAY the error
   DO errorbeep
   SAVE SCREEN TO mscreen
   BOXX(2,2,PROCNAME() + [ Proc ] + M->name + [ line ] + LTRIM(STR(M->line)) +[, ] + M->info +[, ] + M->model)
   INKEY(0)
   ERRCOLORS([pop])
   DO breakout
RETU .T.


* 
PROC errorbeep
   TONE(60,1)
RETU

* 
PROC breakout
   CLEAR GETS
   BREAK
RETU


* 
PROC errorwrite
   PRIV handle,mstr,len,x
   IF ! FILE([errorsys.txt])
      handle = FCREATE([errorsys.txt])
   ELSE
      handle = FOPEN([errorsys.txt],2)
   ENDIF
   mstr = CHR(13)+CHR(10)                                                  +;
          CHR(13)+CHR(10)                                                  +;
          DTOC(DATE())                                             + [   ] +;
          TIME()                                                   + [   ] +;
          SUBS(M->etype+SPAC(10),1,10)                             + [   ] +;
          SUBS(M->name+SPAC(10),1,10)                              + [   ] +;
          SUBS(ALLTRIM(STR(M->line,0))+SPAC(5),1,5)                + [   ] +;
          IF(DEFINED([M->info]),SUBS(M->info+SPAC(25),1,25),[])            +;
          CHR(13)+CHR(10)                                                  +;
          IF(DEFINED([M->model]),SUBS(M->model+SPAC(20),1,20),[])  + [   ] +;
          IF(DEFINED([M->_1]),SUBS(CVAL(M->_1)+SPAC(20),1,20),[])  + [   ] +;
          IF(DEFINED([M->_2]),SUBS(CVAL(M->_2)+SPAC(20),1,20),[])  + [   ] +;
          IF(DEFINED([M->_3]),SUBS(CVAL(M->_3)+SPAC(20),1,20),[])  + [   ] +;
          IF(DEFINED([M->_4]),SUBS(CVAL(M->_4)+SPAC(20),1,20),[])  + [   ] +;
          IF(DEFINED([M->_5]),SUBS(CVAL(M->_5)+SPAC(20),1,20),[])

   len = FSEEK(handle,0,2)    && number of bytes in file
   FSEEK(handle,len,0)        && move to end of file
   x = FWRITE(handle,mstr)
   x = FCLOSE(handle)
RETU

* 
FUNC cval   && return char val
   PARA mval
   PRIV mret
   DO CASE
      CASE TYPE([mval]) = [C]
         mret = mval             + [ :C]
      CASE TYPE([mval]) = [N]
         mret = STR(mval,15,5)   + [ :N]
      CASE TYPE([mval]) = [D]
         mret = DTOC(mval)       + [ :D]
      CASE TYPE([mval]) = [L]
         mret = IF(mval,[T],[F]) + [ :L]
      CASE TYPE([mval]) = [A]
         mret = IF(mval,[T],[F]) + [ :A]
      OTHERWISE 
         mret = [NULL]
   ENDCASE
RETU mret            

* 
FUNC errcolors
   PARA pop_push
   PRIV proc_name
   IF pop_push = [push] .AND. TYPE([CO_PUSH()])=[UI]
      proc_name = [CO_PUSH()]
      x = &proc_name
      proc_name = [CO_CHG(c_error)]
      x = &proc_name
   ENDIF
   IF pop_push = [pop] .AND. TYPE([CO_POP()])=[UI]
      proc_name = [CO_POP()]
      x = &proc_name
   ENDIF
RETU []

