*****************************************************************************
*              Copyright 1989, Financial Dynamics, Inc.                     *
*                                                                           *
*                      (703) 671 - 3003                                                     *
*****************************************************************************


* STD_SET.prg      Initialize from SETUP.DBF
CO_PUSH()
IF FILE([stdprint.dbf])
   DO stdprint
ENDIF

*------the SETUP alais may already be open, so use open_file:
IF ! OPEN_FILE( [setup] )
    CLEAR
    ? "ERROR: SETUP not found. Unable to continue, program halted"
    INKEY(0)
    CLOSE DATA
    QUIT
ENDIF

mcomp_name = ALLTRIM(company)
maddr1     = IF(TYPE([addr1])=[C],ALLTRIM(addr1),[])
maddr2     = IF(TYPE([addr2])=[C],ALLTRIM(addr2),[])
maddr3     = IF(TYPE([addr3])=[C],ALLTRIM(addr3),[])
mphone     = IF(TYPE([phone])=[C],ALLTRIM(phone),[])
videotype  = ALLTRIM(videotype)

IF ! ISCOLO()
   videotype = [MONO]  && no matter what's in the shared SETUP.DBF
ENDIF

IF ! EMPTY(GETE([DISPLAY]))
   videotype = GETE([DISPLAY])  &&  no matter what's in the shared SETUP.DBF
ENDIF

*-----this is for OLD code that uses normal, reverse, etc.
IF IF(TYPE([monitor])=[C],monitor = [M], .F.) .OR. TRIM(M->videotype) $ [MONO/COMPAQ]
   gets    = [W/ , /w, ]
   normal  = [W/ , /w, ]
   reverse = [ /W, /W, ]
   intense =  [W+/ , /W, ]
   blink   =  [W*/ , /W, ]
   blinkrev=  [ */W, /W, ]
ELSE
   gets  =  [W+/B,N/W,B]
   normal  =  [W/B,N/W,B]
   reverse =  [B/W]
   intense =  [W+/B,N/W,B]
   blink   =  [W*/B,N/W,B]
   blinkrev=  [*B/W]
ENDIF

IF EMPTY(menu_title)
   mhead_1 = CENTER('Financial Dynamics',36)
ELSE
   mhead_1 = CENTER(menu_title, 36)
ENDIF

* Printer Controls: convert to strings,
*  fields in setup will override the memvars
IF FILE([stdprint.dbf])
   SELE stdprint
   SEEK setup->printer
   FOR i = 1 TO FCOUNT()
      mfield = FIELD(i)
      PUBLIC &mfield
      M->&mfield = PR_STR(&mfield)
   NEXT i
   mprinter = printer
ELSE
   STORE [] TO M->bold, M->condensed, M->init, M->sideways
   condense = PR_STR(condensed)
   init     = PR_STR(init)
   bold     = PR_STR(bold)
   sideways = PR_STR(sideways)
   mprinter = printer
ENDIF
CLOS DATA

IF FILE([stdcolor.dbf])
   DO co_load WITH M->videotype  && opens and closes stdcolor.dbf
   CURS_ON()         && turn the cursor on initially
   CO_POP()
   backdrop = .F.
ELSE
   SET COLOR TO &normal
   CLEAR
ENDIF

RETURN


* 
FUNC pr_str   && Printer control strings, like Lotus 1-2-3
   PARAM  var
   PRIVATE setup_string, leftover, at_slash
   IF ! TYPE([var]) = [C]                   &&  undefined variable
      setup_string = var
   ELSE
      IF [\] $ M->var                      &&  convert ASCII decimal to text
         setup_string = []
         leftover = M->var
         DO WHILE [\] $ M->leftover
            at_slash = AT([\],M->leftover)
            IF M->at_slash > 1      &&  there are characters before the slash
               setup_string = M->setup_string + SUBS(M->leftover,1,M->at_slash-1)
            ENDIF
            setup_string = M->setup_string + CHR(VAL(SUBS(M->leftover,M->at_slash+1,3)))
            leftover = SUBS(M->leftover,M->at_slash+4)
         ENDDO
         setup_string = M->setup_string + M->leftover
      ELSE
         setup_string = M->var             &&  just text
      ENDIF
      setup_string = TRIM(setup_string)
   ENDIF
RETURN M->setup_string

* 
PROC std_define  &&     allow changes to SETUP.DBF
   IF FILE([stdprint.dbf])
      DO stdprint
   ENDIF
   DO open_file WITH [setup]
   allow_browse = .f.
   module    = [SETUP]
   IF FILE([stdprint.dbf])
      scrmenu   = [+Printers-Add-Delete-Find-Print-Next-Back]
      proc_keys = [ADFP]
   ELSE
      scrmenu   = [-Add-Delete-Find-Print-Next-Back]
      proc_keys = [ADFP]
      KEYBOARD CHR(13)
   ENDIF
   key_field = [Printer]
   DO browse
   DO std_set
   CO_CHG(c_menus)
RETU

PROC setup_gets
   PARAM marea
   @ 04,14 GET &marea->company       PICT "@S50"
   @ 06,14 GET &marea->contact
   @ 12,19 GET &marea->menu_title
   IF TYPE([monitor])=[C]
      @ 15,21 GET &marea->monitor       PICT "!"               VALID M->monitor $ [CM]
   ENDIF
   @ 16,21 GET &marea->videotype     PICT [@!]              VALID ALLTRIM(M->videotype) $ [VGA/EGA/CGA/MONO]
   @ 18,21 GET &marea->printer       PICT [@!]              VALID IF(FILE([stdprint.dbf]),LOOKUP([stdprint],M->printer,.T.),.T.)
RETU

PROC setup_frame
   FRAMEBOX(3,3,19,72)
   SCRTITLE([Standard Setup Maintenance Screen],3,3,72)
   @ 04,05 SAY "Company"
   @ 06,05 SAY "Contact"
   @ 12,05 SAY "Menu Title"
   @ 15,05 SAY "Monitor .......                 (C/M)"
   @ 16,05 SAY "Videotype .....                 (VGA/EGA/CGA/MONO)"
   @ 18,05 SAY "Printer ......."
RETU

PROC setup_P
   PRIV brow_menu,;           && browse mode menu
        scr_menu,;            && full screen mode menu
        module,;              && 2 letter code identifying maintenance module
        wtitle,;              && title on top of field listing
        wfields,;             && fields to list
        mtitle,;              && title at top of browse window
        full_screen,;         && flag : .T. if there is a full screen module
        mreplace,;            && flag : .T. if there is a custom replace procedure
        meminit,;             && flag : .T. if there is a custom init procedure
        proc_keys,;           && list of non-standard keys
        key_field,;           && primary key field
        allow_browse,;
        old_screen


   module      = [_P]
   mtitle      = [Printer Table]
   proc_keys   = [P]
   key_field   = [Printer]

   wtitle      =  [ Printer Name]
   wfields     =  [printer]
   browmenu    =  [-Print]
   Scrmenu     =  [-Print]

   SELE stdprint
   GO TOP

   old_screen = browse(6,30,22,49,.f.)
   RESTSCR(old_screen)
   SELE setup
RETURN

PROC _P_frame
   PRIV i
   CLEAR SCREEN
   @0,0,23,79 BOX single
   FOR i = 1 TO FCOUNT()
      @ 7+i,05 SAY DOTS(FIELD(i),15)
   NEXT i
   SCRTITLE([Edit Printer Table],0,10,70)
RETU

PROC _P_gets
   PARAM marea
   FOR i = 1 TO FCOUNT()
      mfield = FIELD(i)
      @ 7+i,20 GET &marea->&mfield PICT [@s50]
   NEXT i
RETU

PROC stdprint
   DO make_ntx WITH [stdprint],[stdprint],[printer]
   OPEN_FILE([stdprint],[stdprint])
RETU

PROC pick_print
   PRIV old_alias,;
        mtitle,;
        wfields,;
        wtitle,;
        group,;
        group_key,;
        old_screen,;
        mprompt,;
        file_is_open

   old_alias = SELECT()
   file_is_open = SELE([stdprint])>0
   DO stdprint
   mtitle  = [Printer Table]
   wtitle  = []
   wfields = [printer]
   old_screen = window( 10,10,20,40 )
   IF ! ESC()
      FOR i = 1 TO FCOUNT()
          mfield = FIELD(i)
          M->&mfield = PR_STR(&mfield)
      NEXT i
   ENDIF
   mprinter = printer
   IF ! file_is_open
      USE  && close stdprint
   ENDIF
   SELE (old_alias)
   RESTSCR(old_screen)
   mprompt = SUBS('Set up '+TRIM(M->mprinter)+'.  [F1] for list, [Esc] to Quit, any key to print',1,80)
   @ 24,0
   @ 24,0 SAY mprompt
RETU
